/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Supplier;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestDataNodeMetricsLogger {
    static final Log LOG = LogFactory.getLog(TestDataNodeMetricsLogger.class);
    private static final String DATA_DIR = MiniDFSCluster.getBaseDirectory() + "data";
    private static final InetSocketAddress NN_ADDR = new InetSocketAddress("localhost", 5020);
    private DataNode dn;
    static final Random random = new Random(System.currentTimeMillis());
    @Rule
    public Timeout timeout = new Timeout(300000);

    public void startDNForTest(boolean enableMetricsLogging) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.data.dir", DATA_DIR);
        conf.set("dfs.datanode.address", "0.0.0.0:0");
        conf.set("dfs.datanode.http.address", "0.0.0.0:0");
        conf.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        conf.setInt("ipc.client.connect.max.retries", 0);
        conf.setInt("dfs.datanode.metrics.logger.period.seconds", enableMetricsLogging ? 1 : 0);
        this.dn = InternalDataNodeTestUtils.startDNWithMockNN((Configuration)conf, NN_ADDR, DATA_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws IOException {
        if (this.dn != null) {
            try {
                this.dn.shutdown();
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot close: ", (Throwable)e);
            }
            finally {
                File dir = new File(DATA_DIR);
                if (dir.exists()) {
                    Assert.assertTrue((String)"Cannot delete data-node dirs", (boolean)FileUtil.fullyDelete((File)dir));
                }
            }
        }
        this.dn = null;
    }

    @Test
    public void testMetricsLoggerOnByDefault() throws IOException {
        this.startDNForTest(true);
        Assert.assertNotNull((Object)this.dn);
        Assert.assertNotNull((Object)this.dn.getMetricsLoggerTimer());
    }

    @Test
    public void testDisableMetricsLogger() throws IOException {
        this.startDNForTest(false);
        Assert.assertNotNull((Object)this.dn);
        Assert.assertNull((Object)this.dn.getMetricsLoggerTimer());
    }

    @Test
    public void testMetricsLoggerIsAsync() throws IOException {
        this.startDNForTest(true);
        Assert.assertNotNull((Object)this.dn);
        Logger logger = ((Log4JLogger)DataNode.METRICS_LOG).getLogger();
        ArrayList appenders = Collections.list(logger.getAllAppenders());
        Assert.assertTrue((boolean)(appenders.get(0) instanceof AsyncAppender));
    }

    @Test
    public void testMetricsLogOutput() throws IOException, InterruptedException, TimeoutException {
        TestFakeMetric metricsProvider = new TestFakeMetric();
        MBeans.register((String)this.getClass().getSimpleName(), (String)"DummyMetrics", (Object)metricsProvider);
        this.startDNForTest(true);
        Assert.assertNotNull((Object)this.dn);
        final PatternMatchingAppender appender = new PatternMatchingAppender("^.*FakeMetric.*$");
        this.addAppender(DataNode.METRICS_LOG, (Appender)appender);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return appender.isMatched();
            }
        }, (int)1000, (int)60000);
        this.dn.shutdown();
    }

    private void addAppender(Log log, Appender appender) {
        Logger logger = ((Log4JLogger)log).getLogger();
        ArrayList appenders = Collections.list(logger.getAllAppenders());
        ((AsyncAppender)appenders.get(0)).addAppender(appender);
    }

    public static class PatternMatchingAppender
    extends AppenderSkeleton {
        private final Pattern pattern;
        private volatile boolean matched;

        public PatternMatchingAppender(String pattern) {
            this.pattern = Pattern.compile(pattern);
            this.matched = false;
        }

        public boolean isMatched() {
            return this.matched;
        }

        protected void append(LoggingEvent event) {
            if (this.pattern.matcher(event.getMessage().toString()).matches()) {
                this.matched = true;
            }
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }
    }

    public static class TestFakeMetric
    implements TestFakeMetricMXBean {
        @Override
        public int getFakeMetric() {
            return 0;
        }
    }

    public static interface TestFakeMetricMXBean {
        public int getFakeMetric();
    }
}

