/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.common.collect.Sets;
import com.google.inject.Injector;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebApp;

@Singleton
public class RMWebAppFilter
extends GuiceContainer {
    private Injector injector;
    private static final long serialVersionUID = 1L;
    private static final Set<String> NON_REDIRECTED_URIS = Sets.newHashSet((Object[])new String[]{"/conf", "/stacks", "/logLevel", "/logs"});

    @Inject
    public RMWebAppFilter(Injector injector) {
        super(injector);
        this.injector = injector;
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String redirectPath;
        response.setCharacterEncoding("UTF-8");
        String uri = HtmlQuoting.quoteHtmlChars((String)request.getRequestURI());
        if (uri == null) {
            uri = "/";
        }
        RMWebApp rmWebApp = (RMWebApp)((Object)this.injector.getInstance(RMWebApp.class));
        rmWebApp.checkIfStandbyRM();
        if (rmWebApp.isStandby() && this.shouldRedirect(rmWebApp, uri) && (redirectPath = rmWebApp.getRedirectPath() + uri) != null && !redirectPath.isEmpty()) {
            String redirectMsg = "This is standby RM. The redirect url is: " + redirectPath;
            PrintWriter out = response.getWriter();
            out.println(redirectMsg);
            response.setHeader("Location", redirectPath);
            response.setStatus(307);
            return;
        }
        super.doFilter(request, response, chain);
    }

    private boolean shouldRedirect(RMWebApp rmWebApp, String uri) {
        return !uri.equals("/" + rmWebApp.wsName() + "/v1/cluster/info") && !uri.equals("/" + rmWebApp.name() + "/cluster") && !uri.startsWith("/proxy/") && !NON_REDIRECTED_URIS.contains(uri);
    }
}

