/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
public class AsyncCall
extends DefaultPromise<Message> {
    public static final Log LOG = LogFactory.getLog((String)AsyncCall.class.getName());
    final int id;
    final Descriptors.MethodDescriptor method;
    final Message param;
    final PayloadCarryingRpcController controller;
    final Message responseDefaultType;
    final long startTime;
    final long rpcTimeout;

    public AsyncCall(EventLoop eventLoop, int connectId, Descriptors.MethodDescriptor md, Message param, PayloadCarryingRpcController controller, Message responseDefaultType) {
        super((EventExecutor)eventLoop);
        this.id = connectId;
        this.method = md;
        this.param = param;
        this.controller = controller;
        this.responseDefaultType = responseDefaultType;
        this.startTime = EnvironmentEdgeManager.currentTime();
        this.rpcTimeout = controller.hasCallTimeout() ? (long)controller.getCallTimeout() : 0L;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String toString() {
        return "callId=" + this.id + ", method=" + this.method.getName() + ", rpcTimeout=" + this.rpcTimeout + ", param {" + (this.param != null ? ProtobufUtil.getShortTextFormat(this.param) : "") + "}";
    }

    public void setSuccess(Message value, CellScanner cellBlockScanner) {
        if (cellBlockScanner != null) {
            this.controller.setCellScanner(cellBlockScanner);
        }
        if (LOG.isTraceEnabled()) {
            long callTime = EnvironmentEdgeManager.currentTime() - this.startTime;
            LOG.trace((Object)("Call: " + this.method.getName() + ", callTime: " + callTime + "ms"));
        }
        this.setSuccess(value);
    }

    public void setFailed(IOException exception) {
        if (ExceptionUtil.isInterrupt((Throwable)exception)) {
            exception = ExceptionUtil.asInterrupt((Throwable)exception);
        }
        if (exception instanceof RemoteException) {
            exception = ((RemoteException)((Object)exception)).unwrapRemoteException();
        }
        this.setFailure(exception);
    }

    public long getRpcTimeout() {
        return this.rpcTimeout;
    }
}

