/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.MultiByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RPCTests.class, SmallTests.class})
public class TestByteBuffAllocator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestByteBuffAllocator.class);

    @Test
    public void testRecycleOnlyPooledBuffers() {
        int maxBuffersInPool = 10;
        int bufSize = 1024;
        int minSize = bufSize / 8;
        ByteBuffAllocator alloc = new ByteBuffAllocator(true, maxBuffersInPool, bufSize, minSize);
        ByteBuff buff = alloc.allocate(minSize - 1);
        Assert.assertSame((Object)ByteBuffAllocator.NONE, (Object)buff.getRefCnt().getRecycler());
        alloc = new ByteBuffAllocator(true, 0, bufSize, minSize);
        buff = alloc.allocate(minSize * 2);
        Assert.assertSame((Object)ByteBuffAllocator.NONE, (Object)buff.getRefCnt().getRecycler());
    }

    @Test
    public void testAllocateByteBuffToReadInto() {
        int maxBuffersInPool = 10;
        int bufSize = 6144;
        ByteBuffAllocator alloc = new ByteBuffAllocator(true, maxBuffersInPool, bufSize, bufSize / 6);
        Assert.assertEquals((long)0L, (long)alloc.getUsedBufferCount());
        ByteBuff buff = alloc.allocate(10 * bufSize);
        Assert.assertEquals((long)61440L, (long)alloc.getPoolAllocationBytes());
        Assert.assertEquals((long)0L, (long)alloc.getHeapAllocationBytes());
        Assert.assertEquals((long)10L, (long)alloc.getUsedBufferCount());
        buff.release();
        buff = alloc.allocate(200);
        Assert.assertTrue((boolean)buff.hasArray());
        Assert.assertEquals((long)maxBuffersInPool, (long)alloc.getFreeBufferCount());
        Assert.assertEquals((long)maxBuffersInPool, (long)alloc.getTotalBufferCount());
        Assert.assertEquals((long)61440L, (long)alloc.getPoolAllocationBytes());
        Assert.assertEquals((long)200L, (long)alloc.getHeapAllocationBytes());
        Assert.assertEquals((long)10L, (long)alloc.getUsedBufferCount());
        buff.release();
        buff = alloc.allocate(1024);
        Assert.assertFalse((boolean)buff.hasArray());
        Assert.assertEquals((long)(maxBuffersInPool - 1), (long)alloc.getFreeBufferCount());
        Assert.assertEquals((long)67584L, (long)alloc.getPoolAllocationBytes());
        Assert.assertEquals((long)200L, (long)alloc.getHeapAllocationBytes());
        Assert.assertEquals((long)10L, (long)alloc.getUsedBufferCount());
        buff.release();
        Assert.assertEquals((long)maxBuffersInPool, (long)alloc.getFreeBufferCount());
        buff = alloc.allocate(7168);
        Assert.assertFalse((boolean)buff.hasArray());
        Assert.assertTrue((boolean)(buff instanceof MultiByteBuff));
        ByteBuffer[] bbs = buff.nioByteBuffers();
        Assert.assertEquals((long)2L, (long)bbs.length);
        Assert.assertTrue((boolean)bbs[0].isDirect());
        Assert.assertTrue((boolean)bbs[1].isDirect());
        Assert.assertEquals((long)6144L, (long)bbs[0].limit());
        Assert.assertEquals((long)1024L, (long)bbs[1].limit());
        Assert.assertEquals((long)(maxBuffersInPool - 2), (long)alloc.getFreeBufferCount());
        Assert.assertEquals((long)79872L, (long)alloc.getPoolAllocationBytes());
        Assert.assertEquals((long)200L, (long)alloc.getHeapAllocationBytes());
        Assert.assertEquals((long)10L, (long)alloc.getUsedBufferCount());
        buff.release();
        Assert.assertEquals((long)maxBuffersInPool, (long)alloc.getFreeBufferCount());
        buff = alloc.allocate(6344);
        Assert.assertFalse((boolean)buff.hasArray());
        Assert.assertTrue((boolean)(buff instanceof MultiByteBuff));
        bbs = buff.nioByteBuffers();
        Assert.assertEquals((long)2L, (long)bbs.length);
        Assert.assertTrue((boolean)bbs[0].isDirect());
        Assert.assertFalse((boolean)bbs[1].isDirect());
        Assert.assertEquals((long)6144L, (long)bbs[0].limit());
        Assert.assertEquals((long)200L, (long)bbs[1].limit());
        Assert.assertEquals((long)(maxBuffersInPool - 1), (long)alloc.getFreeBufferCount());
        Assert.assertEquals((long)86016L, (long)alloc.getPoolAllocationBytes());
        Assert.assertEquals((long)400L, (long)alloc.getHeapAllocationBytes());
        Assert.assertEquals((long)10L, (long)alloc.getUsedBufferCount());
        buff.release();
        Assert.assertEquals((long)maxBuffersInPool, (long)alloc.getFreeBufferCount());
        alloc.allocate(bufSize * (maxBuffersInPool - 1));
        Assert.assertEquals((long)141312L, (long)alloc.getPoolAllocationBytes());
        Assert.assertEquals((long)400L, (long)alloc.getHeapAllocationBytes());
        Assert.assertEquals((long)10L, (long)alloc.getUsedBufferCount());
        buff = alloc.allocate(20480);
        Assert.assertFalse((boolean)buff.hasArray());
        Assert.assertTrue((boolean)(buff instanceof MultiByteBuff));
        bbs = buff.nioByteBuffers();
        Assert.assertEquals((long)2L, (long)bbs.length);
        Assert.assertTrue((boolean)bbs[0].isDirect());
        Assert.assertFalse((boolean)bbs[1].isDirect());
        Assert.assertEquals((long)6144L, (long)bbs[0].limit());
        Assert.assertEquals((long)14336L, (long)bbs[1].limit());
        Assert.assertEquals((long)0L, (long)alloc.getFreeBufferCount());
        Assert.assertEquals((long)147456L, (long)alloc.getPoolAllocationBytes());
        Assert.assertEquals((long)14736L, (long)alloc.getHeapAllocationBytes());
        Assert.assertEquals((long)10L, (long)alloc.getUsedBufferCount());
        buff.release();
        Assert.assertEquals((long)1L, (long)alloc.getFreeBufferCount());
        alloc.allocateOneBuffer();
        Assert.assertEquals((long)153600L, (long)alloc.getPoolAllocationBytes());
        Assert.assertEquals((long)14736L, (long)alloc.getHeapAllocationBytes());
        Assert.assertEquals((long)10L, (long)alloc.getUsedBufferCount());
        buff = alloc.allocate(7168);
        Assert.assertTrue((boolean)buff.hasArray());
        Assert.assertTrue((boolean)(buff instanceof SingleByteBuff));
        Assert.assertEquals((long)7168L, (long)buff.nioByteBuffers()[0].limit());
        Assert.assertEquals((long)153600L, (long)alloc.getPoolAllocationBytes());
        Assert.assertEquals((long)21904L, (long)alloc.getHeapAllocationBytes());
        Assert.assertEquals((long)10L, (long)alloc.getUsedBufferCount());
        buff.release();
    }

    @Test
    public void testNegativeAllocatedSize() {
        int maxBuffersInPool = 10;
        ByteBuffAllocator allocator = new ByteBuffAllocator(true, maxBuffersInPool, 6144, 1024);
        try {
            allocator.allocate(-1);
            Assert.fail((String)"Should throw exception when size < 0");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ByteBuff bb = allocator.allocate(0);
        Assert.assertEquals((long)0L, (long)allocator.getHeapAllocationBytes());
        bb.release();
    }

    @Test
    public void testAllocateOneBuffer() {
        ByteBuffAllocator allocator = ByteBuffAllocator.HEAP;
        SingleByteBuff buf = allocator.allocateOneBuffer();
        Assert.assertTrue((boolean)buf.hasArray());
        Assert.assertEquals((long)66560L, (long)buf.remaining());
        buf.release();
        int bufSize = 10;
        allocator = new ByteBuffAllocator(true, 1, 10, 3);
        buf = allocator.allocateOneBuffer();
        Assert.assertFalse((boolean)buf.hasArray());
        Assert.assertEquals((long)buf.remaining(), (long)bufSize);
        SingleByteBuff buf2 = allocator.allocateOneBuffer();
        Assert.assertTrue((boolean)buf2.hasArray());
        Assert.assertEquals((long)buf2.remaining(), (long)bufSize);
        buf.release();
        buf = allocator.allocateOneBuffer();
        Assert.assertFalse((boolean)buf.hasArray());
        Assert.assertEquals((long)buf.remaining(), (long)bufSize);
        buf.release();
    }

    @Test
    public void testReferenceCount() {
        int bufSize = 64;
        ByteBuffAllocator alloc = new ByteBuffAllocator(true, 2, bufSize, 3);
        ByteBuff buf1 = alloc.allocate(bufSize * 2);
        Assert.assertFalse((boolean)buf1.hasArray());
        SingleByteBuff buf2 = alloc.allocateOneBuffer();
        Assert.assertTrue((boolean)buf2.hasArray());
        ByteBuff dup2 = buf2.duplicate();
        dup2.release();
        Assert.assertEquals((long)0L, (long)buf2.refCnt());
        Assert.assertEquals((long)0L, (long)dup2.refCnt());
        Assert.assertEquals((long)0L, (long)alloc.getFreeBufferCount());
        this.assertException(() -> ((ByteBuff)dup2).position());
        this.assertException(() -> ((ByteBuff)buf2).position());
        ByteBuff dup1 = buf1.duplicate();
        dup1.release();
        Assert.assertEquals((long)0L, (long)buf1.refCnt());
        Assert.assertEquals((long)0L, (long)dup1.refCnt());
        Assert.assertEquals((long)2L, (long)alloc.getFreeBufferCount());
        this.assertException(() -> ((ByteBuff)dup1).position());
        this.assertException(() -> ((ByteBuff)buf1).position());
        SingleByteBuff buf3 = alloc.allocateOneBuffer();
        Assert.assertFalse((boolean)buf3.hasArray());
        ByteBuff slice3 = buf3.slice();
        slice3.release();
        Assert.assertEquals((long)0L, (long)buf3.refCnt());
        Assert.assertEquals((long)0L, (long)slice3.refCnt());
        Assert.assertEquals((long)2L, (long)alloc.getFreeBufferCount());
        ByteBuff buf4 = alloc.allocate(bufSize * 2);
        Assert.assertFalse((boolean)buf4.hasArray());
        ByteBuff slice4 = buf4.slice();
        slice4.release();
        Assert.assertEquals((long)0L, (long)buf4.refCnt());
        Assert.assertEquals((long)0L, (long)slice4.refCnt());
        Assert.assertEquals((long)2L, (long)alloc.getFreeBufferCount());
        SingleByteBuff buf5 = alloc.allocateOneBuffer();
        ByteBuff slice5 = buf5.duplicate().duplicate().duplicate().slice().slice();
        slice5.release();
        Assert.assertEquals((long)0L, (long)buf5.refCnt());
        Assert.assertEquals((long)0L, (long)slice5.refCnt());
        Assert.assertEquals((long)2L, (long)alloc.getFreeBufferCount());
        this.assertException(() -> ((ByteBuff)slice5).position());
        this.assertException(() -> ((ByteBuff)buf5).position());
        ByteBuff buf6 = alloc.allocate(bufSize >> 2);
        ByteBuff slice6 = buf6.duplicate().duplicate().duplicate().slice().slice();
        slice6.release();
        Assert.assertEquals((long)0L, (long)buf6.refCnt());
        Assert.assertEquals((long)0L, (long)slice6.refCnt());
        Assert.assertEquals((long)2L, (long)alloc.getFreeBufferCount());
        SingleByteBuff parent = alloc.allocateOneBuffer();
        ByteBuff child = parent.duplicate();
        child.retain();
        parent.release();
        Assert.assertEquals((long)1L, (long)child.refCnt());
        Assert.assertEquals((long)1L, (long)parent.refCnt());
        Assert.assertEquals((long)1L, (long)alloc.getFreeBufferCount());
        parent.release();
        Assert.assertEquals((long)0L, (long)child.refCnt());
        Assert.assertEquals((long)0L, (long)parent.refCnt());
        Assert.assertEquals((long)2L, (long)alloc.getFreeBufferCount());
        parent = alloc.allocate(bufSize << 1);
        child = parent.duplicate();
        child.retain();
        parent.release();
        Assert.assertEquals((long)1L, (long)child.refCnt());
        Assert.assertEquals((long)1L, (long)parent.refCnt());
        Assert.assertEquals((long)0L, (long)alloc.getFreeBufferCount());
        parent.release();
        Assert.assertEquals((long)0L, (long)child.refCnt());
        Assert.assertEquals((long)0L, (long)parent.refCnt());
        Assert.assertEquals((long)2L, (long)alloc.getFreeBufferCount());
        parent = alloc.allocateOneBuffer();
        child = parent.slice();
        child.retain();
        parent.release();
        Assert.assertEquals((long)1L, (long)child.refCnt());
        Assert.assertEquals((long)1L, (long)parent.refCnt());
        Assert.assertEquals((long)1L, (long)alloc.getFreeBufferCount());
        parent.release();
        Assert.assertEquals((long)0L, (long)child.refCnt());
        Assert.assertEquals((long)0L, (long)parent.refCnt());
        Assert.assertEquals((long)2L, (long)alloc.getFreeBufferCount());
        parent = alloc.allocate(bufSize << 1);
        child = parent.slice();
        child.retain();
        parent.release();
        Assert.assertEquals((long)1L, (long)child.refCnt());
        Assert.assertEquals((long)1L, (long)parent.refCnt());
        Assert.assertEquals((long)0L, (long)alloc.getFreeBufferCount());
        parent.release();
        Assert.assertEquals((long)0L, (long)child.refCnt());
        Assert.assertEquals((long)0L, (long)parent.refCnt());
        Assert.assertEquals((long)2L, (long)alloc.getFreeBufferCount());
    }

    @Test
    public void testReverseRef() {
        int bufSize = 64;
        ByteBuffAllocator alloc = new ByteBuffAllocator(true, 1, bufSize, 3);
        ByteBuff buf1 = alloc.allocate(bufSize);
        ByteBuff dup1 = buf1.duplicate();
        Assert.assertEquals((long)1L, (long)buf1.refCnt());
        Assert.assertEquals((long)1L, (long)dup1.refCnt());
        buf1.release();
        Assert.assertEquals((long)0L, (long)buf1.refCnt());
        Assert.assertEquals((long)0L, (long)dup1.refCnt());
        Assert.assertEquals((long)1L, (long)alloc.getFreeBufferCount());
        this.assertException(() -> ((ByteBuff)buf1).position());
        this.assertException(() -> ((ByteBuff)dup1).position());
    }

    @Test
    public void testByteBuffUnsupportedMethods() {
        int bufSize = 64;
        ByteBuffAllocator alloc = new ByteBuffAllocator(true, 1, bufSize, 3);
        ByteBuff buf = alloc.allocate(bufSize);
        this.assertException(() -> buf.retain(2));
        this.assertException(() -> buf.release(2));
    }

    private void assertException(Runnable r) {
        try {
            r.run();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDeprecatedConfigs() {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.ipc.server.reservoir.initial.max", 10);
        conf.setInt("hbase.ipc.server.reservoir.initial.buffer.size", 1024);
        ByteBuffAllocator allocator = ByteBuffAllocator.create((Configuration)conf, (boolean)true);
        Assert.assertEquals((long)1024L, (long)allocator.getBufferSize());
        Assert.assertEquals((long)10L, (long)allocator.getTotalBufferCount());
        conf = new Configuration();
        conf.setInt("hbase.server.allocator.max.buffer.count", 11);
        conf.setInt("hbase.server.allocator.buffer.size", 2048);
        allocator = ByteBuffAllocator.create((Configuration)conf, (boolean)true);
        Assert.assertEquals((long)2048L, (long)allocator.getBufferSize());
        Assert.assertEquals((long)11L, (long)allocator.getTotalBufferCount());
        conf = new Configuration();
        conf.setBoolean("hbase.ipc.server.reservoir.enabled", false);
        Assert.assertFalse((boolean)conf.getBoolean("hbase.server.allocator.pool.enabled", true));
        conf.setBoolean("hbase.ipc.server.reservoir.enabled", true);
        Assert.assertTrue((boolean)conf.getBoolean("hbase.server.allocator.pool.enabled", false));
        conf.setBoolean("hbase.server.allocator.pool.enabled", true);
        Assert.assertTrue((boolean)conf.getBoolean("hbase.server.allocator.pool.enabled", false));
        conf.setBoolean("hbase.server.allocator.pool.enabled", false);
        Assert.assertFalse((boolean)conf.getBoolean("hbase.server.allocator.pool.enabled", true));
    }

    @Test
    public void testHeapAllocationRatio() {
        Configuration conf = new Configuration();
        conf.setInt("hbase.server.allocator.max.buffer.count", 11);
        conf.setInt("hbase.server.allocator.buffer.size", 2048);
        ByteBuffAllocator alloc1 = ByteBuffAllocator.create((Configuration)conf, (boolean)true);
        Assert.assertEquals((double)ByteBuffAllocator.getHeapAllocationRatio((ByteBuffAllocator[])new ByteBuffAllocator[]{alloc1}), (double)0.0, (double)1.0E-6);
        alloc1.allocate(1);
        Assert.assertEquals((double)ByteBuffAllocator.getHeapAllocationRatio((ByteBuffAllocator[])new ByteBuffAllocator[]{alloc1}), (double)1.0, (double)1.0E-6);
        alloc1.allocate(340);
        Assert.assertEquals((double)ByteBuffAllocator.getHeapAllocationRatio((ByteBuffAllocator[])new ByteBuffAllocator[]{alloc1}), (double)1.0, (double)1.0E-6);
        alloc1.allocate(24);
        alloc1.allocate(1024);
        Assert.assertEquals((double)ByteBuffAllocator.getHeapAllocationRatio((ByteBuffAllocator[])new ByteBuffAllocator[]{alloc1}), (double)0.011583011597394943, (double)1.0E-6);
        Assert.assertEquals((double)ByteBuffAllocator.getHeapAllocationRatio((ByteBuffAllocator[])new ByteBuffAllocator[]{alloc1}), (double)0.0, (double)1.0E-6);
        ByteBuffAllocator.HEAP.allocate(1024);
        alloc1.allocate(24);
        alloc1.allocate(1024);
        Assert.assertEquals((double)ByteBuffAllocator.getHeapAllocationRatio((ByteBuffAllocator[])new ByteBuffAllocator[]{ByteBuffAllocator.HEAP, alloc1}), (double)0.3385013f, (double)1.0E-6);
        Assert.assertEquals((double)ByteBuffAllocator.getHeapAllocationRatio((ByteBuffAllocator[])new ByteBuffAllocator[]{ByteBuffAllocator.HEAP, alloc1}), (double)0.0, (double)1.0E-6);
        ByteBuffAllocator.HEAP.allocate(1024);
        alloc1.allocate(1024);
        Assert.assertEquals((double)ByteBuffAllocator.getHeapAllocationRatio((ByteBuffAllocator[])new ByteBuffAllocator[]{ByteBuffAllocator.HEAP, ByteBuffAllocator.HEAP, alloc1}), (double)0.3333333432674408, (double)1.0E-6);
    }
}

