/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestRegionLoad {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Admin admin;
    private static final TableName TABLE_1;
    private static final TableName TABLE_2;
    private static final TableName TABLE_3;
    private static final TableName[] tables;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster(4);
        admin = UTIL.getAdmin();
        admin.setBalancerRunning(false, true);
        TestRegionLoad.createTables();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        for (TableName table : tables) {
            UTIL.deleteTableIfAny(table);
        }
        UTIL.shutdownMiniCluster();
    }

    private static void createTables() throws IOException, InterruptedException {
        byte[] FAMILY = Bytes.toBytes((String)"f");
        for (TableName tableName : tables) {
            Table table = UTIL.createMultiRegionTable(tableName, FAMILY, 16);
            UTIL.waitTableAvailable(tableName);
            UTIL.loadTable(table, FAMILY);
        }
    }

    @Test
    public void testRegionLoad() throws Exception {
        for (ServerName serverName : admin.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS)).getServers()) {
            List regions = admin.getOnlineRegions(serverName);
            Collection<RegionLoad> regionLoads = admin.getRegionLoad(serverName).values();
            this.checkRegionsAndRegionLoads(regions, regionLoads);
        }
        for (TableName table : new TableName[]{TABLE_1, TABLE_2, TABLE_3}) {
            List tableRegions = admin.getTableRegions(table);
            ArrayList regionLoads = Lists.newArrayList();
            for (ServerName serverName : admin.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS)).getServers()) {
                regionLoads.addAll(admin.getRegionLoad(serverName, table).values());
            }
            this.checkRegionsAndRegionLoads(tableRegions, regionLoads);
        }
        ClusterStatus clusterStatus = admin.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS));
        for (ServerName serverName : clusterStatus.getServers()) {
            ServerLoad serverLoad = clusterStatus.getLoad(serverName);
            Map regionLoads = admin.getRegionLoad(serverName);
            this.compareRegionLoads(serverLoad.getRegionsLoad(), regionLoads);
        }
    }

    private void compareRegionLoads(Map<byte[], RegionLoad> regionLoadCluster, Map<byte[], RegionLoad> regionLoads) {
        Assert.assertEquals((String)"No of regionLoads from clusterStatus and regionloads from RS doesn't match", (long)regionLoadCluster.size(), (long)regionLoads.size());
        for (byte[] regionName : regionLoadCluster.keySet()) {
            regionLoads.remove(regionName);
        }
        Assert.assertEquals((String)"regionLoads from SN should be empty", (long)0L, (long)regionLoads.size());
    }

    private void checkRegionsAndRegionLoads(Collection<HRegionInfo> regions, Collection<RegionLoad> regionLoads) {
        Assert.assertEquals((String)"No of regions and regionloads doesn't match", (long)regions.size(), (long)regionLoads.size());
        TreeMap regionLoadMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        for (RegionLoad regionLoad : regionLoads) {
            regionLoadMap.put(regionLoad.getName(), regionLoad);
        }
        for (HRegionInfo info : regions) {
            Assert.assertTrue((String)("Region not in regionLoadMap region:" + info.getRegionNameAsString() + " regionMap: " + regionLoadMap), (boolean)regionLoadMap.containsKey(info.getRegionName()));
        }
    }

    static {
        TABLE_1 = TableName.valueOf((String)"table_1");
        TABLE_2 = TableName.valueOf((String)"table_2");
        TABLE_3 = TableName.valueOf((String)"table_3");
        tables = new TableName[]{TABLE_1, TABLE_2, TABLE_3};
    }
}

