/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestServerLoad {
    @Test
    public void testRegionLoadAggregation() {
        ServerLoad sl = new ServerLoad(this.createServerLoadProto());
        Assert.assertEquals((long)13L, (long)sl.getStores());
        Assert.assertEquals((long)114L, (long)sl.getStorefiles());
        Assert.assertEquals((long)129L, (long)sl.getStoreUncompressedSizeMB());
        Assert.assertEquals((long)504L, (long)sl.getRootIndexSizeKB());
        Assert.assertEquals((long)820L, (long)sl.getStorefileSizeMB());
        Assert.assertEquals((long)82L, (long)sl.getStorefileIndexSizeKB());
        Assert.assertEquals((long)0xFFFFFFFEL, (long)sl.getReadRequestsCount());
        Assert.assertEquals((long)300L, (long)sl.getFilteredReadRequestsCount());
    }

    @Test
    public void testToString() {
        ServerLoad sl = new ServerLoad(this.createServerLoadProto());
        String slToString = sl.toString();
        Assert.assertTrue((boolean)slToString.contains("numberOfStores=13"));
        Assert.assertTrue((boolean)slToString.contains("numberOfStorefiles=114"));
        Assert.assertTrue((boolean)slToString.contains("storefileUncompressedSizeMB=129"));
        Assert.assertTrue((boolean)slToString.contains("storefileSizeMB=820"));
        Assert.assertTrue((boolean)slToString.contains("rootIndexSizeKB=504"));
        Assert.assertTrue((boolean)slToString.contains("coprocessors=[]"));
        Assert.assertTrue((boolean)slToString.contains("filteredReadRequestsCount=300"));
    }

    @Test
    public void testRegionLoadWrapAroundAggregation() {
        ServerLoad sl = new ServerLoad(this.createServerLoadProto());
        long totalCount = 0xFFFFFFFEL;
        Assert.assertEquals((long)totalCount, (long)sl.getReadRequestsCount());
        Assert.assertEquals((long)totalCount, (long)sl.getWriteRequestsCount());
    }

    private ClusterStatusProtos.ServerLoad createServerLoadProto() {
        HBaseProtos.RegionSpecifier rSpecOne = HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME).setValue(ByteString.copyFromUtf8((String)"ASDFGQWERT")).build();
        HBaseProtos.RegionSpecifier rSpecTwo = HBaseProtos.RegionSpecifier.newBuilder().setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME).setValue(ByteString.copyFromUtf8((String)"QWERTYUIOP")).build();
        ClusterStatusProtos.RegionLoad rlOne = ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(rSpecOne).setStores(10).setStorefiles(101).setStoreUncompressedSizeMB(106).setStorefileSizeMB(520).setFilteredReadRequestsCount(100L).setStorefileIndexSizeKB(42L).setRootIndexSizeKB(201).setReadRequestsCount(Integer.MAX_VALUE).setWriteRequestsCount(Integer.MAX_VALUE).build();
        ClusterStatusProtos.RegionLoad rlTwo = ClusterStatusProtos.RegionLoad.newBuilder().setRegionSpecifier(rSpecTwo).setStores(3).setStorefiles(13).setStoreUncompressedSizeMB(23).setStorefileSizeMB(300).setFilteredReadRequestsCount(200L).setStorefileIndexSizeKB(40L).setRootIndexSizeKB(303).setReadRequestsCount(Integer.MAX_VALUE).setWriteRequestsCount(Integer.MAX_VALUE).build();
        ClusterStatusProtos.ServerLoad sl = ClusterStatusProtos.ServerLoad.newBuilder().addRegionLoads(rlOne).addRegionLoads(rlTwo).build();
        return sl;
    }
}

