/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveTestingUtil;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.StoppableImplementation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, MiscTests.class})
public class TestHFileArchiving {
    private static final Log LOG = LogFactory.getLog(TestHFileArchiving.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] TEST_FAM = Bytes.toBytes((String)"fam");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestHFileArchiving.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster();
        UTIL.getMiniHBaseCluster().getMaster().getHFileCleaner().cancel(true);
    }

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.regionsever.info.port", -1);
        conf.setInt("hbase.hregion.memstore.flush.size", 25000);
        conf.setInt("hbase.hregion.majorcompaction", 0);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.clearArchiveDirectory();
        }
        catch (IOException e) {
            Assert.fail((String)("Failure to delete archive directory:" + e.getMessage()));
        }
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRemovesRegionDirOnArchive() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.createTable(tableName, TEST_FAM);
        Admin admin = UTIL.getAdmin();
        List<HRegion> servingRegions = UTIL.getHBaseCluster().getRegions(tableName);
        Assert.assertEquals((long)1L, (long)servingRegions.size());
        HRegion region = servingRegions.get(0);
        UTIL.loadRegion(region, TEST_FAM);
        admin.disableTable(tableName);
        FileSystem fs = UTIL.getTestFileSystem();
        Path rootDir = region.getRegionFileSystem().getTableDir().getParent();
        Path regionDir = HRegion.getRegionDir((Path)rootDir, (RegionInfo)region.getRegionInfo());
        HFileArchiver.archiveRegion((Configuration)UTIL.getConfiguration(), (FileSystem)fs, (RegionInfo)region.getRegionInfo());
        Path archiveDir = HFileArchiveTestingUtil.getRegionArchiveDir(UTIL.getConfiguration(), region);
        Assert.assertTrue((boolean)fs.exists(archiveDir));
        FileStatus[] stores = fs.listStatus(archiveDir, new PathFilter(){

            public boolean accept(Path p) {
                return !p.getName().contains("recovered.edits");
            }
        });
        Assert.assertTrue((stores.length == 1 ? 1 : 0) != 0);
        FileStatus[] storeFiles = fs.listStatus(stores[0].getPath());
        Assert.assertTrue((storeFiles.length > 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)fs.exists(regionDir));
        UTIL.deleteTable(tableName);
    }

    @Test
    public void testDeleteRegionWithNoStoreFiles() throws Exception {
        FileStatus[] storeDirs;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.createTable(tableName, TEST_FAM);
        List<HRegion> servingRegions = UTIL.getHBaseCluster().getRegions(tableName);
        Assert.assertEquals((long)1L, (long)servingRegions.size());
        HRegion region = servingRegions.get(0);
        FileSystem fs = region.getRegionFileSystem().getFileSystem();
        Path rootDir = FSUtils.getRootDir((Configuration)fs.getConf());
        Path regionDir = HRegion.getRegionDir((Path)rootDir, (RegionInfo)region.getRegionInfo());
        FileStatus[] regionFiles = FSUtils.listStatus((FileSystem)fs, (Path)regionDir, null);
        Assert.assertNotNull((String)"No files in the region directory", (Object)regionFiles);
        if (LOG.isDebugEnabled()) {
            ArrayList<Path> files = new ArrayList<Path>();
            for (FileStatus file : regionFiles) {
                files.add(file.getPath());
            }
            LOG.debug((Object)("Current files:" + files));
        }
        FSUtils.DirFilter dirFilter = new FSUtils.DirFilter(fs);
        PathFilter nonHidden = new PathFilter((PathFilter)dirFilter){
            final /* synthetic */ PathFilter val$dirFilter;
            {
                this.val$dirFilter = pathFilter;
            }

            public boolean accept(Path file) {
                return this.val$dirFilter.accept(file) && !file.getName().toString().startsWith(".");
            }
        };
        for (FileStatus store : storeDirs = FSUtils.listStatus((FileSystem)fs, (Path)regionDir, (PathFilter)nonHidden)) {
            LOG.debug((Object)"Deleting store for test");
            fs.delete(store.getPath(), true);
        }
        HFileArchiver.archiveRegion((Configuration)UTIL.getConfiguration(), (FileSystem)fs, (RegionInfo)region.getRegionInfo());
        Assert.assertFalse((String)("Region directory (" + regionDir + "), still exists."), (boolean)fs.exists(regionDir));
        UTIL.deleteTable(tableName);
    }

    @Test
    public void testArchiveOnTableDelete() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.createTable(tableName, TEST_FAM);
        List<HRegion> servingRegions = UTIL.getHBaseCluster().getRegions(tableName);
        Assert.assertEquals((long)1L, (long)servingRegions.size());
        HRegion region = servingRegions.get(0);
        HRegionServer hrs = UTIL.getRSForFirstRegionInTable(tableName);
        FileSystem fs = hrs.getFileSystem();
        LOG.debug((Object)"-------Loading table");
        UTIL.loadRegion(region, TEST_FAM);
        List regions = hrs.getRegions(tableName);
        Assert.assertEquals((String)"More that 1 region for test table.", (long)1L, (long)regions.size());
        region = (HRegion)regions.get(0);
        region.waitForFlushesAndCompactions();
        UTIL.getAdmin().disableTable(tableName);
        LOG.debug((Object)"Disabled table");
        this.clearArchiveDirectory();
        byte[][] columns = (byte[][])region.getTableDescriptor().getColumnFamilyNames().toArray((T[])new byte[0][]);
        List storeFiles = region.getStoreFileList(columns);
        UTIL.deleteTable(tableName);
        LOG.debug((Object)"Deleted table");
        this.assertArchiveFiles(fs, storeFiles, 30000L);
    }

    private void assertArchiveFiles(FileSystem fs, List<String> storeFiles, long timeout) throws IOException {
        int i;
        long end = System.currentTimeMillis() + timeout;
        Path archiveDir = HFileArchiveUtil.getArchivePath((Configuration)UTIL.getConfiguration());
        List<Object> archivedFiles = new ArrayList();
        while (System.currentTimeMillis() < end && (archivedFiles = this.getAllFileNames(fs, archiveDir)).size() < storeFiles.size()) {
        }
        Collections.sort(storeFiles);
        Collections.sort(archivedFiles);
        LOG.debug((Object)"Store files:");
        for (i = 0; i < storeFiles.size(); ++i) {
            LOG.debug((Object)(i + " - " + storeFiles.get(i)));
        }
        LOG.debug((Object)"Archive files:");
        for (i = 0; i < archivedFiles.size(); ++i) {
            LOG.debug((Object)(i + " - " + (String)archivedFiles.get(i)));
        }
        Assert.assertTrue((String)"Archived files are missing some of the store files!", (boolean)archivedFiles.containsAll(storeFiles));
    }

    @Test
    public void testArchiveOnTableFamilyDelete() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.createTable(tableName, (byte[][])new byte[][]{TEST_FAM, Bytes.toBytes((String)"fam2")});
        List<HRegion> servingRegions = UTIL.getHBaseCluster().getRegions(tableName);
        Assert.assertEquals((long)1L, (long)servingRegions.size());
        HRegion region = servingRegions.get(0);
        HRegionServer hrs = UTIL.getRSForFirstRegionInTable(tableName);
        FileSystem fs = hrs.getFileSystem();
        LOG.debug((Object)"-------Loading table");
        UTIL.loadRegion(region, TEST_FAM);
        List regions = hrs.getRegions(tableName);
        Assert.assertEquals((String)"More that 1 region for test table.", (long)1L, (long)regions.size());
        region = (HRegion)regions.get(0);
        region.waitForFlushesAndCompactions();
        UTIL.getAdmin().disableTable(tableName);
        LOG.debug((Object)"Disabled table");
        this.clearArchiveDirectory();
        byte[][] columns = (byte[][])region.getTableDescriptor().getColumnFamilyNames().toArray((T[])new byte[0][]);
        List storeFiles = region.getStoreFileList(columns);
        UTIL.getAdmin().deleteColumnFamily(tableName, TEST_FAM);
        this.assertArchiveFiles(fs, storeFiles, 30000L);
        UTIL.deleteTable(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleaningRace() throws Exception {
        long TEST_TIME = 20000L;
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        Configuration conf = UTIL.getMiniHBaseCluster().getMaster().getConfiguration();
        Path rootDir = UTIL.getDataTestDirOnTestFS("testCleaningRace");
        FileSystem fs = UTIL.getTestFileSystem();
        Path archiveDir = new Path(rootDir, "archive");
        Path regionDir = new Path(FSUtils.getTableDir((Path)new Path("./"), (TableName)TableName.valueOf((String)this.name.getMethodName())), "abcdef");
        Path familyDir = new Path(regionDir, "cf");
        Path sourceRegionDir = new Path(rootDir, regionDir);
        fs.mkdirs(sourceRegionDir);
        StoppableImplementation stoppable = new StoppableImplementation();
        HFileCleaner cleaner = new HFileCleaner(1, (Stoppable)stoppable, conf, fs, archiveDir);
        try {
            choreService.scheduleChore((ScheduledChore)cleaner);
            long startTime = System.currentTimeMillis();
            long fid = 0L;
            while (System.currentTimeMillis() - startTime < 20000L) {
                Path file = new Path(familyDir, String.valueOf(fid));
                Path sourceFile = new Path(rootDir, file);
                Path archiveFile = new Path(archiveDir, file);
                fs.createNewFile(sourceFile);
                try {
                    HFileArchiver.archiveRegion((FileSystem)fs, (Path)rootDir, (Path)sourceRegionDir.getParent(), (Path)sourceRegionDir);
                    LOG.debug((Object)("hfile=" + fid + " should be in the archive"));
                    Assert.assertTrue((boolean)fs.exists(archiveFile));
                    Assert.assertFalse((boolean)fs.exists(sourceFile));
                }
                catch (IOException e) {
                    LOG.debug((Object)("hfile=" + fid + " should be in the source location"));
                    Assert.assertFalse((boolean)fs.exists(archiveFile));
                    Assert.assertTrue((boolean)fs.exists(sourceFile));
                    fs.delete(sourceFile, false);
                }
                ++fid;
            }
        }
        finally {
            stoppable.stop("test end");
            cleaner.cancel(true);
            choreService.shutdown();
            fs.delete(rootDir, true);
        }
    }

    private void clearArchiveDirectory() throws IOException {
        UTIL.getTestFileSystem().delete(new Path(UTIL.getDefaultRootDirPath(), "archive"), true);
    }

    private List<String> getAllFileNames(FileSystem fs, Path archiveDir) throws IOException {
        FileStatus[] files = FSUtils.listStatus((FileSystem)fs, (Path)archiveDir, (PathFilter)new PathFilter(){

            public boolean accept(Path p) {
                return !p.getName().contains("recovered.edits");
            }
        });
        return this.recurseOnFiles(fs, files, new ArrayList<String>());
    }

    private List<String> recurseOnFiles(FileSystem fs, FileStatus[] files, List<String> fileNames) throws IOException {
        if (files == null || files.length == 0) {
            return fileNames;
        }
        for (FileStatus file : files) {
            if (file.isDirectory()) {
                this.recurseOnFiles(fs, FSUtils.listStatus((FileSystem)fs, (Path)file.getPath(), null), fileNames);
                continue;
            }
            fileNames.add(file.getPath().getName());
        }
        return fileNames;
    }
}

