/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runners.Parameterized;

public abstract class TestAsyncAdminBase {
    protected static final Log LOG = LogFactory.getLog(TestAsyncAdminBase.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static final byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    protected static final byte[] FAMILY_0 = Bytes.toBytes((String)"cf0");
    protected static final byte[] FAMILY_1 = Bytes.toBytes((String)"cf1");
    protected static AsyncConnection ASYNC_CONN;
    protected AsyncAdmin admin;
    @Parameterized.Parameter
    public Supplier<AsyncAdmin> getAdmin;
    @Rule
    public TestName testName = new TestName();
    protected TableName tableName;

    private static AsyncAdmin getRawAsyncAdmin() {
        return ASYNC_CONN.getAdmin();
    }

    private static AsyncAdmin getAsyncAdmin() {
        return ASYNC_CONN.getAdmin((ExecutorService)ForkJoinPool.commonPool());
    }

    @Parameterized.Parameters
    public static List<Object[]> params() {
        return Arrays.asList({TestAsyncAdminBase::getRawAsyncAdmin}, {TestAsyncAdminBase::getAsyncAdmin});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 60000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.operation.timeout", 120000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.client.start.log.errors.counter", 0);
        TEST_UTIL.startMiniCluster(2);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        IOUtils.closeQuietly((Closeable)ASYNC_CONN);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = this.getAdmin.get();
        String methodName = this.testName.getMethodName();
        this.tableName = TableName.valueOf((String)methodName.substring(0, methodName.length() - 3));
    }

    @After
    public void tearDown() throws Exception {
        ((CompletableFuture)this.admin.listTableNames(Optional.of(Pattern.compile(this.tableName.getNameAsString() + ".*")), false).whenCompleteAsync((tables, err) -> {
            if (tables != null) {
                tables.forEach(table -> {
                    try {
                        this.admin.disableTable(table).join();
                    }
                    catch (Exception e) {
                        LOG.debug((Object)("Table: " + this.tableName + " already disabled, so just deleting it."));
                    }
                    this.admin.deleteTable(table).join();
                });
            }
        }, (Executor)ForkJoinPool.commonPool())).join();
    }

    protected void createTableWithDefaultConf(TableName tableName) {
        this.createTableWithDefaultConf(tableName, Optional.empty());
    }

    protected void createTableWithDefaultConf(TableName tableName, Optional<byte[][]> splitKeys) {
        this.createTableWithDefaultConf(tableName, splitKeys, new byte[][]{FAMILY});
    }

    protected void createTableWithDefaultConf(TableName tableName, Optional<byte[][]> splitKeys, byte[] ... families) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (byte[] family : families) {
            builder.addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        this.admin.createTable(builder.build(), splitKeys).join();
    }
}

