/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.AsyncMetaRegionLocator;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.AsyncRegistryFactory;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncMetaRegionLocator {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static AsyncRegistry REGISTRY;
    private static AsyncMetaRegionLocator LOCATOR;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.balancer.tablesOnMaster", "none");
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.waitUntilAllSystemRegionsAssigned();
        TEST_UTIL.getAdmin().setBalancerRunning(false, true);
        REGISTRY = AsyncRegistryFactory.getRegistry((Configuration)TEST_UTIL.getConfiguration());
        LOCATOR = new AsyncMetaRegionLocator(REGISTRY);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        IOUtils.closeQuietly((Closeable)REGISTRY);
        TEST_UTIL.shutdownMiniCluster();
    }

    private Optional<ServerName> getRSCarryingMeta() {
        return TEST_UTIL.getHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer()).filter(rs -> !rs.getRegions(TableName.META_TABLE_NAME).isEmpty()).findAny().map(rs -> rs.getServerName());
    }

    @Test
    public void testReload() throws Exception {
        final ServerName serverName = this.getRSCarryingMeta().get();
        Assert.assertEquals((Object)serverName, (Object)((HRegionLocation)LOCATOR.getRegionLocation(false).get()).getServerName());
        ServerName newServerName = TEST_UTIL.getHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer().getServerName()).filter(sn -> !sn.equals((Object)serverName)).findAny().get();
        TEST_UTIL.getAdmin().move(HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), Bytes.toBytes((String)newServerName.getServerName()));
        TEST_UTIL.waitFor(30000L, new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                Optional newServerName = TestAsyncMetaRegionLocator.this.getRSCarryingMeta();
                return newServerName.isPresent() && !((ServerName)newServerName.get()).equals((Object)serverName);
            }

            public String explainFailure() throws Exception {
                return HRegionInfo.FIRST_META_REGIONINFO.getRegionNameAsString() + " is still on " + serverName;
            }
        });
        Assert.assertEquals((Object)serverName, (Object)((HRegionLocation)LOCATOR.getRegionLocation(false).get()).getServerName());
        Assert.assertEquals((Object)newServerName, (Object)((HRegionLocation)LOCATOR.getRegionLocation(true).get()).getServerName());
        Assert.assertEquals((Object)newServerName, (Object)((HRegionLocation)LOCATOR.getRegionLocation(false).get()).getServerName());
    }
}

