/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceExistException;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.ZKNamespaceManager;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncNamespaceAdminApi
extends TestAsyncAdminBase {
    private String prefix = "TestNamespace";
    private static HMaster master;
    private static ZKNamespaceManager zkNamespaceManager;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 60000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.operation.timeout", 120000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.client.start.log.errors.counter", 0);
        TEST_UTIL.startMiniCluster(1);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        master = TEST_UTIL.getHBaseCluster().getMaster();
        zkNamespaceManager = new ZKNamespaceManager(master.getZooKeeper());
        zkNamespaceManager.start();
        LOG.info((Object)"Done initializing cluster");
    }

    @Test(timeout=60000L)
    public void testCreateAndDelete() throws Exception {
        String testName = "testCreateAndDelete";
        String nsName = this.prefix + "_" + testName;
        this.admin.createNamespace(NamespaceDescriptor.create((String)nsName).build()).join();
        Assert.assertEquals((long)3L, (long)((List)this.admin.listNamespaceDescriptors().get()).size());
        TEST_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return zkNamespaceManager.list().size() == 3;
            }
        });
        Assert.assertNotNull((Object)zkNamespaceManager.get(nsName));
        this.admin.deleteNamespace(nsName).join();
        Assert.assertEquals((long)2L, (long)((List)this.admin.listNamespaceDescriptors().get()).size());
        Assert.assertEquals((long)2L, (long)zkNamespaceManager.list().size());
        Assert.assertNull((Object)zkNamespaceManager.get(nsName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDeleteReservedNS() throws Exception {
        boolean exceptionCaught = false;
        try {
            this.admin.deleteNamespace(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR).join();
        }
        catch (Exception exp) {
            LOG.warn((Object)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
        try {
            this.admin.deleteNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR).join();
        }
        catch (Exception exp) {
            LOG.warn((Object)exp);
            exceptionCaught = true;
        }
        finally {
            Assert.assertTrue((boolean)exceptionCaught);
        }
    }

    @Test(timeout=60000L)
    public void testNamespaceOperations() throws Exception {
        this.admin.createNamespace(NamespaceDescriptor.create((String)(this.prefix + "ns1")).build()).join();
        this.admin.createNamespace(NamespaceDescriptor.create((String)(this.prefix + "ns2")).build()).join();
        TestAsyncNamespaceAdminApi.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestAsyncNamespaceAdminApi.this.admin.createNamespace(NamespaceDescriptor.create((String)(TestAsyncNamespaceAdminApi.this.prefix + "ns1")).build()).join();
                return null;
            }
        }, NamespaceExistException.class);
        TestAsyncNamespaceAdminApi.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"non_existing_namespace", (String)"table1"));
                htd.addFamily(new HColumnDescriptor("family1"));
                TestAsyncNamespaceAdminApi.this.admin.createTable((TableDescriptor)htd).join();
                return null;
            }
        }, NamespaceNotFoundException.class);
        NamespaceDescriptor ns1 = (NamespaceDescriptor)this.admin.getNamespaceDescriptor(this.prefix + "ns1").get();
        Assert.assertEquals((Object)(this.prefix + "ns1"), (Object)ns1.getName());
        TestAsyncNamespaceAdminApi.runWithExpectedException(new Callable<NamespaceDescriptor>(){

            @Override
            public NamespaceDescriptor call() throws Exception {
                return (NamespaceDescriptor)TestAsyncNamespaceAdminApi.this.admin.getNamespaceDescriptor("non_existing_namespace").get();
            }
        }, NamespaceNotFoundException.class);
        this.admin.deleteNamespace(this.prefix + "ns2").join();
        TestAsyncNamespaceAdminApi.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestAsyncNamespaceAdminApi.this.admin.deleteNamespace("non_existing_namespace").join();
                return null;
            }
        }, NamespaceNotFoundException.class);
        ns1 = (NamespaceDescriptor)this.admin.getNamespaceDescriptor(this.prefix + "ns1").get();
        ns1.setConfiguration("foo", "bar");
        this.admin.modifyNamespace(ns1).join();
        ns1 = (NamespaceDescriptor)this.admin.getNamespaceDescriptor(this.prefix + "ns1").get();
        Assert.assertEquals((Object)"bar", (Object)ns1.getConfigurationValue("foo"));
        TestAsyncNamespaceAdminApi.runWithExpectedException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestAsyncNamespaceAdminApi.this.admin.modifyNamespace(NamespaceDescriptor.create((String)"non_existing_namespace").build()).join();
                return null;
            }
        }, NamespaceNotFoundException.class);
        this.admin.deleteNamespace(this.prefix + "ns1").join();
    }

    private static <V, E> void runWithExpectedException(Callable<V> callable, Class<E> exceptionClass) {
        try {
            callable.call();
        }
        catch (Exception ex) {
            LOG.info((Object)("Get exception is " + ex));
            Assert.assertEquals(exceptionClass, ex.getCause().getClass());
            return;
        }
        Assert.fail((String)("Should have thrown exception " + exceptionClass));
    }
}

