/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.HashMap;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.procedure.SimpleMasterProcedureManager;
import org.apache.hadoop.hbase.procedure.SimpleRSProcedureManager;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncProcedureAdminApi
extends TestAsyncAdminBase {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 60000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.operation.timeout", 120000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.client.start.log.errors.counter", 0);
        TEST_UTIL.getConfiguration().set("hbase.procedure.master.classes", SimpleMasterProcedureManager.class.getName());
        TEST_UTIL.getConfiguration().set("hbase.procedure.regionserver.classes", SimpleRSProcedureManager.class.getName());
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TEST_UTIL.startMiniCluster(2);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecProcedure() throws Exception {
        String snapshotString = "offlineTableSnapshot";
        try {
            Table table = TEST_UTIL.createTable(this.tableName, Bytes.toBytes((String)"cf"));
            for (int i = 0; i < 100; ++i) {
                Put put = new Put(Bytes.toBytes((int)i)).addColumn(Bytes.toBytes((String)"cf"), null, Bytes.toBytes((int)i));
                table.put(put);
            }
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("table", this.tableName.getNameAsString());
            this.admin.execProcedure("online-snapshot", snapshotString, props).get();
            LOG.debug((Object)"Snapshot completed.");
        }
        finally {
            this.admin.deleteSnapshot(snapshotString).join();
            TEST_UTIL.deleteTable(this.tableName);
        }
    }

    @Test
    public void testExecProcedureWithRet() throws Exception {
        byte[] result = (byte[])this.admin.execProcedureWithRet("simple_test", "myTest2", new HashMap()).get();
        Assert.assertArrayEquals((String)"Incorrect return data from execProcedure", (byte[])"simple_test_data".getBytes(), (byte[])result);
    }

    @Test
    public void listProcedure() throws Exception {
        String procList = (String)this.admin.getProcedures().get();
        Assert.assertTrue((boolean)procList.startsWith("["));
    }

    @Test
    public void isProcedureFinished() throws Exception {
        boolean failed = false;
        try {
            this.admin.isProcedureFinished("fake-signature", "fake-instance", new HashMap()).get();
        }
        catch (Exception e) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
    }

    @Test
    public void abortProcedure() throws Exception {
        Random randomGenerator = new Random();
        long procId = randomGenerator.nextLong();
        boolean abortResult = (Boolean)this.admin.abortProcedure(procId, true).get();
        Assert.assertFalse((boolean)abortResult);
    }
}

