/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.AsyncMetaTableAccessor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RawAsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.NoSuchProcedureException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncRegionAdminApi
extends TestAsyncAdminBase {
    @Test
    public void testGetRegionLocation() throws Exception {
        RawAsyncHBaseAdmin rawAdmin = (RawAsyncHBaseAdmin)ASYNC_CONN.getAdmin();
        TEST_UTIL.createMultiRegionTable(this.tableName, HConstants.CATALOG_FAMILY);
        AsyncTableRegionLocator locator = ASYNC_CONN.getRegionLocator(this.tableName);
        HRegionLocation regionLocation = (HRegionLocation)locator.getRegionLocation(Bytes.toBytes((String)"mmm")).get();
        HRegionInfo region = regionLocation.getRegionInfo();
        byte[] regionName = regionLocation.getRegionInfo().getRegionName();
        HRegionLocation location = (HRegionLocation)rawAdmin.getRegionLocation(regionName).get();
        Assert.assertTrue((boolean)Bytes.equals((byte[])regionName, (byte[])location.getRegionInfo().getRegionName()));
        location = (HRegionLocation)rawAdmin.getRegionLocation(region.getEncodedNameAsBytes()).get();
        Assert.assertTrue((boolean)Bytes.equals((byte[])regionName, (byte[])location.getRegionInfo().getRegionName()));
    }

    @Test
    public void testAssignRegionAndUnassignRegion() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        AssignmentManager am = master.getAssignmentManager();
        RegionInfo hri = (RegionInfo)am.getRegionStates().getRegionsOfTable(this.tableName).get(0);
        RegionStates regionStates = am.getRegionStates();
        ServerName serverName = regionStates.getRegionServerOfRegion(hri);
        TEST_UTIL.assertRegionOnServer(hri, serverName, 200L);
        Assert.assertTrue((boolean)regionStates.getRegionState(hri).isOpened());
        this.admin.assign(hri.getRegionName()).get();
        try {
            am.waitForAssignment(hri);
            Assert.fail((String)"Expected NoSuchProcedureException");
        }
        catch (NoSuchProcedureException noSuchProcedureException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)regionStates.getRegionState(hri).isOpened());
        this.admin.unassign(hri.getRegionName(), true).get();
        try {
            am.waitForAssignment(hri);
            Assert.fail((String)"Expected NoSuchProcedureException");
        }
        catch (NoSuchProcedureException noSuchProcedureException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)regionStates.getRegionState(hri).isClosed());
    }

    RegionInfo createTableAndGetOneRegion(TableName tableName) throws IOException, InterruptedException, ExecutionException {
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
        this.admin.createTable(desc, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"), 5).get();
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        long timeoutTime = System.currentTimeMillis() + 3000L;
        List regions;
        while ((regions = master.getAssignmentManager().getRegionStates().getRegionsOfTable(tableName)).size() <= 3) {
            long now = System.currentTimeMillis();
            if (now > timeoutTime) {
                Assert.fail((String)"Could not find an online region");
            }
            Thread.sleep(10L);
        }
        return (RegionInfo)regions.get(2);
    }

    @Ignore
    @Test
    public void testOfflineRegion() throws Exception {
        RegionInfo hri = this.createTableAndGetOneRegion(this.tableName);
        RegionStates regionStates = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
        this.admin.offline(hri.getRegionName()).get();
        long timeoutTime = System.currentTimeMillis() + 3000L;
        while (!((List)regionStates.getRegionByStateOfTable(this.tableName).get(RegionState.State.OFFLINE)).stream().anyMatch(r -> RegionInfo.COMPARATOR.compare(r, hri) == 0)) {
            long now = System.currentTimeMillis();
            if (now > timeoutTime) {
                Assert.fail((String)"Failed to offline the region in time");
                break;
            }
            Thread.sleep(10L);
        }
        RegionState regionState = regionStates.getRegionState(hri);
        Assert.assertTrue((boolean)regionState.isOffline());
    }

    @Test
    public void testGetRegionByStateOfTable() throws Exception {
        RegionInfo hri = this.createTableAndGetOneRegion(this.tableName);
        RegionStates regionStates = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates();
        Assert.assertTrue((boolean)((List)regionStates.getRegionByStateOfTable(this.tableName).get(RegionState.State.OPEN)).stream().anyMatch(r -> RegionInfo.COMPARATOR.compare(r, hri) == 0));
        Assert.assertFalse((boolean)((List)regionStates.getRegionByStateOfTable(TableName.valueOf((String)"I_am_the_phantom")).get(RegionState.State.OPEN)).stream().anyMatch(r -> RegionInfo.COMPARATOR.compare(r, hri) == 0));
    }

    @Test
    public void testMoveRegion() throws Exception {
        ServerName sn;
        JVMClusterUtil.RegionServerThread regionServer;
        HRegionServer destServer;
        this.admin.setBalancerOn(false).join();
        RegionInfo hri = this.createTableAndGetOneRegion(this.tableName);
        RawAsyncHBaseAdmin rawAdmin = (RawAsyncHBaseAdmin)ASYNC_CONN.getAdmin();
        ServerName serverName = ((HRegionLocation)rawAdmin.getRegionLocation(hri.getRegionName()).get()).getServerName();
        HMaster master = TEST_UTIL.getHBaseCluster().getMaster();
        ServerManager serverManager = master.getServerManager();
        ServerName destServerName = null;
        List<JVMClusterUtil.RegionServerThread> regionServers = TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads();
        Iterator<JVMClusterUtil.RegionServerThread> iterator = regionServers.iterator();
        while (iterator.hasNext() && ((destServerName = (destServer = (regionServer = iterator.next()).getRegionServer()).getServerName()).equals((Object)serverName) || !serverManager.isServerOnline(destServerName))) {
        }
        Assert.assertTrue((destServerName != null && !destServerName.equals((Object)serverName) ? 1 : 0) != 0);
        this.admin.move(hri.getRegionName(), Optional.of(destServerName)).get();
        long timeoutTime = System.currentTimeMillis() + 30000L;
        while ((sn = ((HRegionLocation)rawAdmin.getRegionLocation(hri.getRegionName()).get()).getServerName()) == null || !sn.equals((Object)destServerName)) {
            long now = System.currentTimeMillis();
            if (now > timeoutTime) {
                Assert.fail((String)("Failed to move the region in time: " + hri));
            }
            Thread.sleep(100L);
        }
        this.admin.setBalancerOn(true).join();
    }

    @Test
    public void testGetOnlineRegions() throws Exception {
        this.createTableAndGetOneRegion(this.tableName);
        AtomicInteger regionServerCount = new AtomicInteger(0);
        TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().stream().map(rsThread -> rsThread.getRegionServer()).forEach(rs -> {
            ServerName serverName = rs.getServerName();
            try {
                Assert.assertEquals((long)((List)this.admin.getOnlineRegions(serverName).get()).size(), (long)rs.getRegions().size());
            }
            catch (Exception e) {
                Assert.fail((String)("admin.getOnlineRegions() method throws a exception: " + e.getMessage()));
            }
            regionServerCount.incrementAndGet();
        });
        Assert.assertEquals((long)regionServerCount.get(), (long)2L);
    }

    @Test
    public void testFlushTableAndRegion() throws Exception {
        RegionInfo hri = this.createTableAndGetOneRegion(this.tableName);
        ServerName serverName = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getRegionServerOfRegion(hri);
        HRegionServer regionServer = TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().stream().map(rsThread -> rsThread.getRegionServer()).filter(rs -> rs.getServerName().equals((Object)serverName)).findFirst().get();
        ASYNC_CONN.getRawTable(this.tableName).put(new Put(hri.getStartKey()).addColumn(FAMILY, FAMILY_0, Bytes.toBytes((String)"value-1"))).join();
        Assert.assertTrue((regionServer.getOnlineRegion(hri.getRegionName()).getMemStoreSize() > 0L ? 1 : 0) != 0);
        LOG.info((Object)("flushing region: " + Bytes.toStringBinary((byte[])hri.getRegionName())));
        this.admin.flushRegion(hri.getRegionName()).get();
        LOG.info((Object)("blocking until flush is complete: " + Bytes.toStringBinary((byte[])hri.getRegionName())));
        Threads.sleepWithoutInterrupt((long)500L);
        while (regionServer.getOnlineRegion(hri.getRegionName()).getMemStoreSize() > 0L) {
            Threads.sleep((long)50L);
        }
        Assert.assertEquals((long)regionServer.getOnlineRegion(hri.getRegionName()).getMemStoreSize(), (long)0L);
        ASYNC_CONN.getRawTable(this.tableName).put(new Put(hri.getStartKey()).addColumn(FAMILY, FAMILY_0, Bytes.toBytes((String)"value-2"))).join();
        Assert.assertTrue((regionServer.getOnlineRegion(hri.getRegionName()).getMemStoreSize() > 0L ? 1 : 0) != 0);
        this.admin.flush(this.tableName).get();
        Threads.sleepWithoutInterrupt((long)500L);
        while (regionServer.getOnlineRegion(hri.getRegionName()).getMemStoreSize() > 0L) {
            Threads.sleep((long)50L);
        }
        Assert.assertEquals((long)regionServer.getOnlineRegion(hri.getRegionName()).getMemStoreSize(), (long)0L);
    }

    @Test
    public void testSplitSwitch() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        byte[][] families = new byte[][]{FAMILY};
        int rows = 10000;
        TestAsyncRegionAdminApi.loadData(this.tableName, families, 10000);
        RawAsyncTable metaTable = ASYNC_CONN.getRawTable(TableName.META_TABLE_NAME);
        List regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(this.tableName)).get();
        int originalCount = regionLocations.size();
        this.initSplitMergeSwitch();
        Assert.assertTrue((boolean)((Boolean)this.admin.setSplitOn(false).get()));
        try {
            this.admin.split(this.tableName, Bytes.toBytes((int)5000)).join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int count = ((List)this.admin.getTableRegions(this.tableName).get()).size();
        Assert.assertTrue((originalCount == count ? 1 : 0) != 0);
        Assert.assertFalse((boolean)((Boolean)this.admin.setSplitOn(true).get()));
        this.admin.split(this.tableName).join();
        while ((count = ((List)this.admin.getTableRegions(this.tableName).get()).size()) == originalCount) {
            Threads.sleep((long)100L);
        }
        Assert.assertTrue((originalCount < count ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    public void testMergeSwitch() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        byte[][] families = new byte[][]{FAMILY};
        TestAsyncRegionAdminApi.loadData(this.tableName, families, 1000);
        RawAsyncTable metaTable = ASYNC_CONN.getRawTable(TableName.META_TABLE_NAME);
        List regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(this.tableName)).get();
        int originalCount = regionLocations.size();
        this.initSplitMergeSwitch();
        this.admin.split(this.tableName).join();
        int postSplitCount = originalCount;
        while ((postSplitCount = ((List)this.admin.getTableRegions(this.tableName).get()).size()) == originalCount) {
            Threads.sleep((long)100L);
        }
        Assert.assertTrue((String)("originalCount=" + originalCount + ", postSplitCount=" + postSplitCount), (originalCount != postSplitCount ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Boolean)this.admin.setMergeOn(false).get()));
        List regions = (List)this.admin.getTableRegions(this.tableName).get();
        Assert.assertTrue((regions.size() > 1 ? 1 : 0) != 0);
        this.admin.mergeRegions(((RegionInfo)regions.get(0)).getRegionName(), ((RegionInfo)regions.get(1)).getRegionName(), true).join();
        int count = ((List)this.admin.getTableRegions(this.tableName).get()).size();
        Assert.assertTrue((String)("postSplitCount=" + postSplitCount + ", count=" + count), (postSplitCount == count ? 1 : 0) != 0);
        Assert.assertFalse((boolean)((Boolean)this.admin.setMergeOn(true).get()));
        this.admin.mergeRegions(((RegionInfo)regions.get(0)).getRegionName(), ((RegionInfo)regions.get(1)).getRegionName(), true).join();
        count = ((List)this.admin.getTableRegions(this.tableName).get()).size();
        Assert.assertTrue((postSplitCount / 2 == count ? 1 : 0) != 0);
    }

    private void initSplitMergeSwitch() throws Exception {
        if (!((Boolean)this.admin.isSplitOn().get()).booleanValue()) {
            this.admin.setSplitOn(true).get();
        }
        if (!((Boolean)this.admin.isMergeOn().get()).booleanValue()) {
            this.admin.setMergeOn(true).get();
        }
        Assert.assertTrue((boolean)((Boolean)this.admin.isSplitOn().get()));
        Assert.assertTrue((boolean)((Boolean)this.admin.isMergeOn().get()));
    }

    @Test
    public void testMergeRegions() throws Exception {
        byte[][] splitRows = new byte[][]{Bytes.toBytes((String)"3"), Bytes.toBytes((String)"6")};
        this.createTableWithDefaultConf(this.tableName, Optional.of(splitRows));
        RawAsyncTable metaTable = ASYNC_CONN.getRawTable(TableName.META_TABLE_NAME);
        List regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(this.tableName)).get();
        Assert.assertEquals((long)3L, (long)regionLocations.size());
        HRegionInfo regionA = ((HRegionLocation)regionLocations.get(0)).getRegionInfo();
        HRegionInfo regionB = ((HRegionLocation)regionLocations.get(1)).getRegionInfo();
        this.admin.mergeRegions(regionA.getRegionName(), regionB.getRegionName(), false).get();
        regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(this.tableName)).get();
        Assert.assertEquals((long)2L, (long)regionLocations.size());
        regionA = ((HRegionLocation)regionLocations.get(0)).getRegionInfo();
        regionB = ((HRegionLocation)regionLocations.get(1)).getRegionInfo();
        this.admin.mergeRegions(regionA.getRegionName(), regionB.getRegionName(), false).get();
        regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(this.tableName)).get();
        Assert.assertEquals((long)1L, (long)regionLocations.size());
    }

    @Test
    public void testSplitTable() throws Exception {
        this.initSplitMergeSwitch();
        this.splitTest(TableName.valueOf((String)"testSplitTable"), 3000, false, null);
        this.splitTest(TableName.valueOf((String)"testSplitTableWithSplitPoint"), 3000, false, Bytes.toBytes((String)"3"));
        this.splitTest(TableName.valueOf((String)"testSplitTableRegion"), 3000, true, null);
        this.splitTest(TableName.valueOf((String)"testSplitTableRegionWithSplitPoint2"), 3000, true, Bytes.toBytes((String)"3"));
    }

    private void splitTest(TableName tableName, int rowCount, boolean isSplitRegion, byte[] splitPoint) throws Exception {
        this.createTableWithDefaultConf(tableName);
        RawAsyncTable metaTable = ASYNC_CONN.getRawTable(TableName.META_TABLE_NAME);
        List regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(tableName)).get();
        Assert.assertEquals((long)1L, (long)regionLocations.size());
        RawAsyncTable table = ASYNC_CONN.getRawTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < rowCount; ++i) {
            Put put = new Put(Bytes.toBytes((int)i));
            put.addColumn(FAMILY, null, Bytes.toBytes((String)("value" + i)));
            puts.add(put);
        }
        table.putAll(puts).join();
        if (isSplitRegion) {
            this.admin.splitRegion(((HRegionLocation)regionLocations.get(0)).getRegionInfo().getRegionName(), Optional.ofNullable(splitPoint)).get();
        } else if (splitPoint == null) {
            this.admin.split(tableName).get();
        } else {
            this.admin.split(tableName, splitPoint).get();
        }
        int count = 0;
        for (int i = 0; i < 45; ++i) {
            try {
                regionLocations = (List)AsyncMetaTableAccessor.getTableHRegionLocations((RawAsyncTable)metaTable, Optional.of(tableName)).get();
                count = regionLocations.size();
                if (count >= 2) break;
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        Assert.assertEquals((long)count, (long)2L);
    }

    @Test
    public void testCompactRegionServer() throws Exception {
        byte[][] families = new byte[][]{Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"f2"), Bytes.toBytes((String)"f3")};
        this.createTableWithDefaultConf(this.tableName, Optional.empty(), families);
        TestAsyncRegionAdminApi.loadData(this.tableName, families, 3000, 8);
        List<HRegionServer> rsList = TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().stream().map(rsThread -> rsThread.getRegionServer()).collect(Collectors.toList());
        ArrayList<Region> regions = new ArrayList<Region>();
        rsList.forEach(rs -> regions.addAll(rs.getRegions(this.tableName)));
        Assert.assertEquals((long)regions.size(), (long)1L);
        int countBefore = TestAsyncRegionAdminApi.countStoreFilesInFamilies(regions, families);
        Assert.assertTrue((countBefore > 0 ? 1 : 0) != 0);
        for (HRegionServer hRegionServer : rsList) {
            this.admin.compactRegionServer(hRegionServer.getServerName()).get();
        }
        Thread.sleep(5000L);
        int countAfterMinorCompaction = TestAsyncRegionAdminApi.countStoreFilesInFamilies(regions, families);
        Assert.assertTrue((countAfterMinorCompaction < countBefore ? 1 : 0) != 0);
        for (HRegionServer rs3 : rsList) {
            this.admin.majorCompactRegionServer(rs3.getServerName()).get();
        }
        Thread.sleep(5000L);
        int n = TestAsyncRegionAdminApi.countStoreFilesInFamilies(regions, families);
        Assert.assertEquals((long)n, (long)3L);
    }

    @Test
    public void testCompact() throws Exception {
        this.compactionTest(TableName.valueOf((String)"testCompact1"), 8, CompactionState.MAJOR, false);
        this.compactionTest(TableName.valueOf((String)"testCompact2"), 15, CompactionState.MINOR, false);
        this.compactionTest(TableName.valueOf((String)"testCompact3"), 8, CompactionState.MAJOR, true);
        this.compactionTest(TableName.valueOf((String)"testCompact4"), 15, CompactionState.MINOR, true);
    }

    private void compactionTest(TableName tableName, int flushes, CompactionState expectedState, boolean singleFamily) throws Exception {
        byte[] family = Bytes.toBytes((String)"family");
        byte[][] families = new byte[][]{family, Bytes.add((byte[])family, (byte[])Bytes.toBytes((String)"2")), Bytes.add((byte[])family, (byte[])Bytes.toBytes((String)"3"))};
        this.createTableWithDefaultConf(tableName, Optional.empty(), families);
        TestAsyncRegionAdminApi.loadData(tableName, families, 3000, flushes);
        ArrayList<Region> regions = new ArrayList<Region>();
        TEST_UTIL.getHBaseCluster().getLiveRegionServerThreads().forEach(rsThread -> regions.addAll(rsThread.getRegionServer().getRegions(tableName)));
        Assert.assertEquals((long)regions.size(), (long)1L);
        int countBefore = TestAsyncRegionAdminApi.countStoreFilesInFamilies(regions, families);
        int countBeforeSingleFamily = TestAsyncRegionAdminApi.countStoreFilesInFamily(regions, family);
        Assert.assertTrue((countBefore > 0 ? 1 : 0) != 0);
        if (expectedState == CompactionState.MINOR) {
            if (singleFamily) {
                this.admin.compact(tableName, Optional.of(family)).get();
            } else {
                this.admin.compact(tableName, Optional.empty()).get();
            }
        } else if (singleFamily) {
            this.admin.majorCompact(tableName, Optional.of(family)).get();
        } else {
            this.admin.majorCompact(tableName, Optional.empty()).get();
        }
        long curt = System.currentTimeMillis();
        long waitTime = 5000L;
        long endt = curt + waitTime;
        CompactionState state = (CompactionState)this.admin.getCompactionState(tableName).get();
        while (state == CompactionState.NONE && curt < endt) {
            Thread.sleep(10L);
            state = (CompactionState)this.admin.getCompactionState(tableName).get();
            curt = System.currentTimeMillis();
        }
        if (expectedState != state) {
            for (Region region : regions) {
                state = CompactionState.valueOf((String)region.getCompactionState().toString());
                Assert.assertEquals((Object)CompactionState.NONE, (Object)state);
            }
        } else {
            state = (CompactionState)this.admin.getCompactionState(tableName).get();
            while (state != CompactionState.NONE && curt < endt) {
                Thread.sleep(10L);
                state = (CompactionState)this.admin.getCompactionState(tableName).get();
            }
            Assert.assertEquals((Object)CompactionState.NONE, (Object)state);
        }
        int countAfter = TestAsyncRegionAdminApi.countStoreFilesInFamilies(regions, families);
        int countAfterSingleFamily = TestAsyncRegionAdminApi.countStoreFilesInFamily(regions, family);
        Assert.assertTrue((countAfter < countBefore ? 1 : 0) != 0);
        if (!singleFamily) {
            if (expectedState == CompactionState.MAJOR) {
                Assert.assertTrue((families.length == countAfter ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((families.length < countAfter ? 1 : 0) != 0);
            }
        } else {
            int singleFamDiff = countBeforeSingleFamily - countAfterSingleFamily;
            Assert.assertTrue((singleFamDiff == countBefore - countAfter ? 1 : 0) != 0);
            if (expectedState == CompactionState.MAJOR) {
                Assert.assertTrue((1 == countAfterSingleFamily ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((1 < countAfterSingleFamily ? 1 : 0) != 0);
            }
        }
    }

    private static int countStoreFilesInFamily(List<Region> regions, byte[] family) {
        return TestAsyncRegionAdminApi.countStoreFilesInFamilies(regions, new byte[][]{family});
    }

    private static int countStoreFilesInFamilies(List<Region> regions, byte[][] families) {
        int count = 0;
        for (Region region : regions) {
            count += region.getStoreFileList(families).size();
        }
        return count;
    }

    private static void loadData(TableName tableName, byte[][] families, int rows) throws IOException {
        TestAsyncRegionAdminApi.loadData(tableName, families, rows, 1);
    }

    private static void loadData(TableName tableName, byte[][] families, int rows, int flushes) throws IOException {
        RawAsyncTable table = ASYNC_CONN.getRawTable(tableName);
        ArrayList<Put> puts = new ArrayList<Put>(rows);
        byte[] qualifier = Bytes.toBytes((String)"val");
        for (int i = 0; i < flushes; ++i) {
            for (int k = 0; k < rows; ++k) {
                byte[] row = Bytes.add((byte[])Bytes.toBytes((int)k), (byte[])Bytes.toBytes((int)i));
                Put p = new Put(row);
                for (int j = 0; j < families.length; ++j) {
                    p.addColumn(families[j], qualifier, row);
                }
                puts.add(p);
            }
            table.putAll(puts).join();
            TEST_UTIL.flush();
            puts.clear();
        }
    }
}

