/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncTableGetMultiThreaded {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"cq");
    private static int COUNT = 1000;
    private static AsyncConnection CONN;
    private static RawAsyncTable TABLE;
    private static byte[][] SPLIT_KEYS;

    @BeforeClass
    public static void setUp() throws Exception {
        TestAsyncTableGetMultiThreaded.setUp(MemoryCompactionPolicy.NONE);
    }

    protected static void setUp(MemoryCompactionPolicy memoryCompaction) throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.balancer.tablesOnMaster", "none");
        TEST_UTIL.getConfiguration().setLong("hbase.client.meta.operation.timeout", 60000L);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.server.reservoir.initial.max", 100);
        TEST_UTIL.getConfiguration().set("hbase.hregion.compacting.memstore.type", String.valueOf(memoryCompaction));
        TEST_UTIL.startMiniCluster(5);
        SPLIT_KEYS = new byte[8][];
        for (int i2 = 111; i2 < 999; i2 += 111) {
            TestAsyncTableGetMultiThreaded.SPLIT_KEYS[i2 / 111 - 1] = Bytes.toBytes((String)String.format("%03d", i2));
        }
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        TABLE = (RawAsyncTable)CONN.getRawTableBuilder(TABLE_NAME).setReadRpcTimeout(1L, TimeUnit.SECONDS).setMaxRetries(1000).build();
        TABLE.putAll(IntStream.range(0, COUNT).mapToObj(i -> new Put(Bytes.toBytes((String)String.format("%03d", i))).addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)i))).collect(Collectors.toList())).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        IOUtils.closeQuietly((Closeable)CONN);
        TEST_UTIL.shutdownMiniCluster();
    }

    private void run(AtomicBoolean stop) throws InterruptedException, ExecutionException {
        while (!stop.get()) {
            for (int i = 0; i < COUNT; ++i) {
                Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])((Result)TABLE.get(new Get(Bytes.toBytes((String)String.format("%03d", i)))).get()).getValue(FAMILY, QUALIFIER)));
            }
        }
    }

    @Test
    public void test() throws IOException, InterruptedException, ExecutionException {
        int numThreads = 20;
        AtomicBoolean stop = new AtomicBoolean(false);
        ExecutorService executor = Executors.newFixedThreadPool(numThreads, Threads.newDaemonThreadFactory((String)"TestAsyncGet-"));
        ArrayList futures = new ArrayList();
        IntStream.range(0, numThreads).forEach(i -> futures.add(executor.submit(() -> {
            this.run(stop);
            return null;
        })));
        Collections.shuffle(Arrays.asList(SPLIT_KEYS), new Random(123L));
        Admin admin = TEST_UTIL.getAdmin();
        for (byte[] splitPoint : SPLIT_KEYS) {
            admin.split(TABLE_NAME, splitPoint);
            for (HRegion region : TEST_UTIL.getHBaseCluster().getRegions(TABLE_NAME)) {
                region.compact(true);
            }
            Thread.sleep(5000L);
            admin.balancer(true);
            Thread.sleep(5000L);
            ServerName metaServer = TEST_UTIL.getHBaseCluster().getServerHoldingMeta();
            ServerName newMetaServer = TEST_UTIL.getHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer().getServerName()).filter(s -> !s.equals((Object)metaServer)).findAny().get();
            admin.move(HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), Bytes.toBytes((String)newMetaServer.getServerName()));
            Thread.sleep(5000L);
        }
        stop.set(true);
        executor.shutdown();
        Object object = futures.iterator();
        while (object.hasNext()) {
            Future future = (Future)object.next();
            future.get();
        }
    }
}

