/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.AsyncRegistryFactory;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestClientClusterStatus {
    private static HBaseTestingUtility UTIL;
    private static Admin ADMIN;
    private static final int SLAVES = 5;
    private static final int MASTERS = 3;
    private static MiniHBaseCluster CLUSTER;
    private static HRegionServer DEAD;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        UTIL = new HBaseTestingUtility(conf);
        UTIL.startMiniCluster(3, 5);
        CLUSTER = UTIL.getHBaseCluster();
        CLUSTER.waitForActiveAndReadyMaster();
        ADMIN = UTIL.getAdmin();
        List<JVMClusterUtil.RegionServerThread> rsts = CLUSTER.getLiveRegionServerThreads();
        JVMClusterUtil.RegionServerThread rst = rsts.get(rsts.size() - 1);
        DEAD = rst.getRegionServer();
        DEAD.stop("Test dead servers status");
        while (rst.isAlive()) {
            Thread.sleep(500L);
        }
    }

    @Test
    public void testDefaults() throws Exception {
        ClusterStatus origin = ADMIN.getClusterStatus();
        ClusterStatus defaults = ADMIN.getClusterStatus(EnumSet.allOf(ClusterStatus.Option.class));
        Assert.assertEquals((Object)origin.getHBaseVersion(), (Object)defaults.getHBaseVersion());
        Assert.assertEquals((Object)origin.getClusterId(), (Object)defaults.getClusterId());
        Assert.assertTrue((origin.getAverageLoad() == defaults.getAverageLoad() ? 1 : 0) != 0);
        Assert.assertTrue((origin.getBackupMastersSize() == defaults.getBackupMastersSize() ? 1 : 0) != 0);
        Assert.assertTrue((origin.getDeadServersSize() == defaults.getDeadServersSize() ? 1 : 0) != 0);
        Assert.assertTrue((origin.getRegionsCount() == defaults.getRegionsCount() ? 1 : 0) != 0);
        Assert.assertTrue((origin.getServersSize() == defaults.getServersSize() ? 1 : 0) != 0);
        Assert.assertTrue((origin.getMasterInfoPort() == defaults.getMasterInfoPort() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)origin.equals((Object)defaults));
    }

    @Test
    public void testNone() throws Exception {
        ClusterStatus status = ADMIN.getClusterStatus(EnumSet.noneOf(ClusterStatus.Option.class));
        Assert.assertTrue((status.getMasterCoprocessors().length == 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)status.getHBaseVersion());
        Assert.assertTrue((boolean)status.getBackupMasters().isEmpty());
        Assert.assertNull((Object)status.getBalancerOn());
        Assert.assertNull((Object)status.getClusterId());
        Assert.assertTrue((boolean)status.getServers().isEmpty());
        Assert.assertTrue((boolean)status.getDeadServerNames().isEmpty());
        Assert.assertNull((Object)status.getMaster());
        Assert.assertTrue((boolean)status.getBackupMasters().isEmpty());
        Assert.assertEquals((long)-1L, (long)status.getMasterInfoPort());
        Assert.assertNotNull((Object)status.hashCode());
        ClusterStatus nullEqualsCheck = ADMIN.getClusterStatus(EnumSet.noneOf(ClusterStatus.Option.class));
        Assert.assertTrue((boolean)status.equals((Object)nullEqualsCheck));
    }

    @Test
    public void testAsyncClient() throws Exception {
        AsyncRegistry registry = AsyncRegistryFactory.getRegistry((Configuration)UTIL.getConfiguration());
        AsyncConnectionImpl asyncConnect = new AsyncConnectionImpl(UTIL.getConfiguration(), registry, (String)registry.getClusterId().get(), User.getCurrent());
        AsyncAdmin asyncAdmin = asyncConnect.getAdmin();
        CompletableFuture originFuture = asyncAdmin.getClusterStatus();
        CompletableFuture defaultsFuture = asyncAdmin.getClusterStatus(EnumSet.allOf(ClusterStatus.Option.class));
        ClusterStatus origin = (ClusterStatus)originFuture.get();
        ClusterStatus defaults = (ClusterStatus)defaultsFuture.get();
        Assert.assertEquals((Object)origin.getHBaseVersion(), (Object)defaults.getHBaseVersion());
        Assert.assertEquals((Object)origin.getClusterId(), (Object)defaults.getClusterId());
        Assert.assertTrue((origin.getAverageLoad() == defaults.getAverageLoad() ? 1 : 0) != 0);
        Assert.assertTrue((origin.getBackupMastersSize() == defaults.getBackupMastersSize() ? 1 : 0) != 0);
        Assert.assertTrue((origin.getDeadServersSize() == defaults.getDeadServersSize() ? 1 : 0) != 0);
        Assert.assertTrue((origin.getRegionsCount() == defaults.getRegionsCount() ? 1 : 0) != 0);
        Assert.assertTrue((origin.getServersSize() == defaults.getServersSize() ? 1 : 0) != 0);
        if (asyncConnect != null) {
            asyncConnect.close();
        }
    }

    @Test
    public void testLiveAndDeadServersStatus() throws Exception {
        List<JVMClusterUtil.RegionServerThread> regionserverThreads = CLUSTER.getLiveRegionServerThreads();
        int numRs = 0;
        int len = regionserverThreads.size();
        for (int i = 0; i < len; ++i) {
            if (!regionserverThreads.get(i).isAlive()) continue;
            ++numRs;
        }
        EnumSet<ClusterStatus.Option> options = EnumSet.of(ClusterStatus.Option.LIVE_SERVERS, ClusterStatus.Option.DEAD_SERVERS);
        ClusterStatus status = ADMIN.getClusterStatus(options);
        Assert.assertNotNull((Object)status);
        Assert.assertNotNull((Object)status.getServers());
        Assert.assertEquals((long)4L, (long)numRs);
        Assert.assertEquals((long)status.getServers().size(), (long)numRs);
        Assert.assertTrue((status.getRegionsCount() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)status.getDeadServerNames());
        Assert.assertEquals((long)1L, (long)status.getDeadServersSize());
        ServerName deadServerName = (ServerName)status.getDeadServerNames().iterator().next();
        Assert.assertEquals((Object)DEAD.getServerName(), (Object)deadServerName);
    }

    @Test
    public void testMasterAndBackupMastersStatus() throws Exception {
        List<JVMClusterUtil.MasterThread> masterThreads = CLUSTER.getMasterThreads();
        int numActive = 0;
        int activeIndex = 0;
        ServerName activeName = null;
        HMaster active = null;
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            ++numActive;
            activeIndex = i;
            active = masterThreads.get(activeIndex).getMaster();
            activeName = active.getServerName();
        }
        Assert.assertNotNull(active);
        Assert.assertEquals((long)1L, (long)numActive);
        Assert.assertEquals((long)3L, (long)masterThreads.size());
        EnumSet<ClusterStatus.Option> options = EnumSet.of(ClusterStatus.Option.MASTER, ClusterStatus.Option.BACKUP_MASTERS);
        ClusterStatus status = ADMIN.getClusterStatus(options);
        Assert.assertTrue((boolean)status.getMaster().equals((Object)activeName));
        Assert.assertEquals((long)2L, (long)status.getBackupMastersSize());
    }

    @Test
    public void testOtherStatusInfos() throws Exception {
        EnumSet<ClusterStatus.Option> options = EnumSet.of(ClusterStatus.Option.MASTER_COPROCESSORS, ClusterStatus.Option.HBASE_VERSION, ClusterStatus.Option.CLUSTER_ID, ClusterStatus.Option.BALANCER_ON);
        ClusterStatus status = ADMIN.getClusterStatus(options);
        Assert.assertTrue((status.getMasterCoprocessors().length == 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)status.getHBaseVersion());
        Assert.assertNotNull((Object)status.getClusterId());
        Assert.assertTrue((status.getAverageLoad() == 0.0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)(status.getBalancerOn() != false && status.getBalancerOn() == false ? 1 : 0));
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (ADMIN != null) {
            ADMIN.close();
        }
        UTIL.shutdownMiniCluster();
    }
}

