/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class, ClientTests.class})
public class TestCloneSnapshotFromClient {
    private static final Log LOG = LogFactory.getLog(TestCloneSnapshotFromClient.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected final byte[] FAMILY = Bytes.toBytes((String)"cf");
    protected byte[] emptySnapshot;
    protected byte[] snapshotName0;
    protected byte[] snapshotName1;
    protected byte[] snapshotName2;
    protected TableName tableName;
    protected int snapshot0Rows;
    protected int snapshot1Rows;
    protected Admin admin;
    @Rule
    public TestName name = new TestName();

    protected static void setupConfiguration() {
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestCloneSnapshotFromClient.setupConfiguration();
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        this.admin = TEST_UTIL.getAdmin();
        long tid = System.currentTimeMillis();
        this.tableName = TableName.valueOf((String)(this.name.getMethodName() + tid));
        this.emptySnapshot = Bytes.toBytes((String)("emptySnaptb-" + tid));
        this.snapshotName0 = Bytes.toBytes((String)("snaptb0-" + tid));
        this.snapshotName1 = Bytes.toBytes((String)("snaptb1-" + tid));
        this.snapshotName2 = Bytes.toBytes((String)("snaptb2-" + tid));
        this.createTableAndSnapshots();
    }

    protected void createTableAndSnapshots() throws Exception {
        SnapshotTestingUtils.createTable(TEST_UTIL, this.tableName, this.getNumReplicas(), (byte[][])new byte[][]{this.FAMILY});
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.emptySnapshot, this.tableName);
        this.admin.enableTable(this.tableName);
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 500, (byte[][])new byte[][]{this.FAMILY});
        try (Table table = TEST_UTIL.getConnection().getTable(this.tableName);){
            this.snapshot0Rows = TEST_UTIL.countRows(table);
        }
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName0, this.tableName);
        this.admin.enableTable(this.tableName);
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 500, (byte[][])new byte[][]{this.FAMILY});
        table = TEST_UTIL.getConnection().getTable(this.tableName);
        var2_2 = null;
        try {
            this.snapshot1Rows = TEST_UTIL.countRows(table);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (table != null) {
                if (var2_2 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    table.close();
                }
            }
        }
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName1, this.tableName);
        this.admin.enableTable(this.tableName);
    }

    protected int getNumReplicas() {
        return 1;
    }

    @After
    public void tearDown() throws Exception {
        if (this.admin.tableExists(this.tableName)) {
            TEST_UTIL.deleteTable(this.tableName);
        }
        SnapshotTestingUtils.deleteAllSnapshots(this.admin);
        SnapshotTestingUtils.deleteArchiveDirectory(TEST_UTIL);
    }

    @Test(expected=SnapshotDoesNotExistException.class)
    public void testCloneNonExistentSnapshot() throws IOException, InterruptedException {
        String snapshotName = "random-snapshot-" + System.currentTimeMillis();
        TableName tableName = TableName.valueOf((String)(this.name.getMethodName() + "-" + System.currentTimeMillis()));
        this.admin.cloneSnapshot(snapshotName, tableName);
    }

    @Test(expected=NamespaceNotFoundException.class)
    public void testCloneOnMissingNamespace() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf((String)("unknownNS:" + this.name.getMethodName()));
        this.admin.cloneSnapshot(this.snapshotName1, clonedTableName);
    }

    @Test
    public void testCloneSnapshot() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf((String)(this.name.getMethodName() + "-" + System.currentTimeMillis()));
        this.testCloneSnapshot(clonedTableName, this.snapshotName0, this.snapshot0Rows);
        this.testCloneSnapshot(clonedTableName, this.snapshotName1, this.snapshot1Rows);
        this.testCloneSnapshot(clonedTableName, this.emptySnapshot, 0);
    }

    private void testCloneSnapshot(TableName tableName, byte[] snapshotName, int snapshotRows) throws IOException, InterruptedException {
        this.admin.cloneSnapshot(snapshotName, tableName);
        this.verifyRowCount(TEST_UTIL, tableName, snapshotRows);
        this.verifyReplicasCameOnline(tableName);
        TEST_UTIL.deleteTable(tableName);
    }

    protected void verifyReplicasCameOnline(TableName tableName) throws IOException {
        SnapshotTestingUtils.verifyReplicasCameOnline(tableName, this.admin, this.getNumReplicas());
    }

    @Test
    public void testCloneSnapshotCrossNamespace() throws IOException, InterruptedException {
        String nsName = "testCloneSnapshotCrossNamespace";
        this.admin.createNamespace(NamespaceDescriptor.create((String)nsName).build());
        TableName clonedTableName = TableName.valueOf((String)nsName, (String)(this.name.getMethodName() + "-" + System.currentTimeMillis()));
        this.testCloneSnapshot(clonedTableName, this.snapshotName0, this.snapshot0Rows);
        this.testCloneSnapshot(clonedTableName, this.snapshotName1, this.snapshot1Rows);
        this.testCloneSnapshot(clonedTableName, this.emptySnapshot, 0);
    }

    @Test
    public void testCloneLinksAfterDelete() throws IOException, InterruptedException {
        TableName clonedTableName = TableName.valueOf((String)(this.name.getMethodName() + "1-" + System.currentTimeMillis()));
        this.admin.cloneSnapshot(this.snapshotName0, clonedTableName);
        this.verifyRowCount(TEST_UTIL, clonedTableName, this.snapshot0Rows);
        this.admin.disableTable(clonedTableName);
        this.admin.snapshot(this.snapshotName2, clonedTableName);
        TableName clonedTableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2-" + System.currentTimeMillis()));
        this.admin.cloneSnapshot(this.snapshotName2, clonedTableName2);
        this.verifyRowCount(TEST_UTIL, clonedTableName2, this.snapshot0Rows);
        this.admin.disableTable(clonedTableName2);
        TEST_UTIL.deleteTable(this.tableName);
        this.waitCleanerRun();
        this.admin.enableTable(clonedTableName);
        this.verifyRowCount(TEST_UTIL, clonedTableName, this.snapshot0Rows);
        this.admin.enableTable(clonedTableName2);
        this.verifyRowCount(TEST_UTIL, clonedTableName2, this.snapshot0Rows);
        this.admin.disableTable(clonedTableName2);
        TEST_UTIL.deleteTable(clonedTableName);
        this.waitCleanerRun();
        this.admin.enableTable(clonedTableName2);
        this.verifyRowCount(TEST_UTIL, clonedTableName2, this.snapshot0Rows);
        TableName clonedTableName3 = TableName.valueOf((String)(this.name.getMethodName() + "3-" + System.currentTimeMillis()));
        this.admin.cloneSnapshot(this.snapshotName2, clonedTableName3);
        this.verifyRowCount(TEST_UTIL, clonedTableName3, this.snapshot0Rows);
        TEST_UTIL.deleteTable(clonedTableName2);
        TEST_UTIL.deleteTable(clonedTableName3);
        this.admin.deleteSnapshot(this.snapshotName2);
    }

    private void waitCleanerRun() throws InterruptedException {
        TEST_UTIL.getMiniHBaseCluster().getMaster().getHFileCleaner().choreForTesting();
    }

    protected void verifyRowCount(HBaseTestingUtility util, TableName tableName, long expectedRows) throws IOException {
        SnapshotTestingUtils.verifyRowCount(util, tableName, expectedRows);
    }
}

