/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class, ClientTests.class})
public class TestMvccConsistentScanner {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Connection CONN;
    private static final byte[] CF;
    private static final byte[] CQ1;
    private static final byte[] CQ2;
    private static final byte[] CQ3;
    @Rule
    public TestName testName = new TestName();
    private TableName tableName;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster(2);
        CONN = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        CONN.close();
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws IOException, InterruptedException {
        this.tableName = TableName.valueOf((String)this.testName.getMethodName().replaceAll("[^0-9a-zA-Z]", "_"));
        UTIL.createTable(this.tableName, CF);
        UTIL.waitTableAvailable(this.tableName);
    }

    private void put(byte[] row, byte[] cq, byte[] value) throws IOException {
        try (Table table = CONN.getTable(this.tableName);){
            table.put(new Put(row).addColumn(CF, cq, value));
        }
    }

    private void move() throws IOException, InterruptedException {
        RegionInfo region = ((HRegion)UTIL.getHBaseCluster().getRegions(this.tableName).stream().findAny().get()).getRegionInfo();
        HRegionServer rs = UTIL.getHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer()).filter(r -> !r.getOnlineTables().contains(this.tableName)).findAny().get();
        UTIL.getAdmin().move(region.getEncodedNameAsBytes(), Bytes.toBytes((String)rs.getServerName().getServerName()));
        while (UTIL.getRSForFirstRegionInTable(this.tableName) != rs) {
            Thread.sleep(100L);
        }
    }

    @Test
    public void testRowAtomic() throws IOException, InterruptedException {
        byte[] row = Bytes.toBytes((String)"row");
        this.put(row, CQ1, Bytes.toBytes((int)1));
        this.put(row, CQ2, Bytes.toBytes((int)2));
        try (Table table = CONN.getTable(this.tableName);
             ResultScanner scanner = table.getScanner(new Scan().setBatch(1).setCaching(1));){
            Result result = scanner.next();
            Assert.assertEquals((long)1L, (long)result.rawCells().length);
            Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])result.getValue(CF, CQ1)));
            this.move();
            this.put(row, CQ3, Bytes.toBytes((int)3));
            result = scanner.next();
            Assert.assertEquals((long)1L, (long)result.rawCells().length);
            Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])result.getValue(CF, CQ2)));
            Assert.assertNull((Object)scanner.next());
        }
    }

    @Test
    public void testCrossRowAtomicInRegion() throws IOException, InterruptedException {
        this.put(Bytes.toBytes((String)"row1"), CQ1, Bytes.toBytes((int)1));
        this.put(Bytes.toBytes((String)"row2"), CQ1, Bytes.toBytes((int)2));
        try (Table table = CONN.getTable(this.tableName);
             ResultScanner scanner = table.getScanner(new Scan().setCaching(1));){
            Result result = scanner.next();
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"row1"), (byte[])result.getRow());
            Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])result.getValue(CF, CQ1)));
            this.move();
            this.put(Bytes.toBytes((String)"row3"), CQ1, Bytes.toBytes((int)3));
            result = scanner.next();
            Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"row2"), (byte[])result.getRow());
            Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])result.getValue(CF, CQ1)));
            Assert.assertNull((Object)scanner.next());
        }
    }

    static {
        CF = Bytes.toBytes((String)"cf");
        CQ1 = Bytes.toBytes((String)"cq1");
        CQ2 = Bytes.toBytes((String)"cq2");
        CQ3 = Bytes.toBytes((String)"cq3");
    }
}

