/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ColumnCountOnRowFilter;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestRawAsyncTableLimitedScanWithFilter {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"TestRegionScanner");
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static final byte[][] CQS = new byte[][]{Bytes.toBytes((String)"cq1"), Bytes.toBytes((String)"cq2"), Bytes.toBytes((String)"cq3"), Bytes.toBytes((String)"cq4")};
    private static int ROW_COUNT = 10;
    private static AsyncConnection CONN;
    private static RawAsyncTable TABLE;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        UTIL.createTable(TABLE_NAME, FAMILY);
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();
        TABLE = CONN.getRawTable(TABLE_NAME);
        TABLE.putAll(IntStream.range(0, ROW_COUNT).mapToObj(i -> {
            Put put = new Put(Bytes.toBytes((int)i));
            IntStream.range(0, CQS.length).forEach(j -> put.addColumn(FAMILY, CQS[j], Bytes.toBytes((int)((j + 1) * i))));
            return put;
        }).collect(Collectors.toList())).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        CONN.close();
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCompleteResult() throws InterruptedException, ExecutionException {
        int limit = 5;
        Scan scan = new Scan().setFilter((Filter)new ColumnCountOnRowFilter(2)).setMaxResultSize(1L).setLimit(limit);
        List results = (List)TABLE.scanAll(scan).get();
        Assert.assertEquals((long)limit, (long)results.size());
        IntStream.range(0, limit).forEach(i -> {
            Result result = (Result)results.get(i);
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getRow()));
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertFalse((boolean)result.mayHaveMoreCellsInRow());
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[0])));
            Assert.assertEquals((long)(2 * i), (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[1])));
        });
    }

    @Test
    public void testAllowPartial() throws InterruptedException, ExecutionException {
        int limit = 5;
        Scan scan = new Scan().setFilter((Filter)new ColumnCountOnRowFilter(2)).setMaxResultSize(1L).setAllowPartialResults(true).setLimit(limit);
        List results = (List)TABLE.scanAll(scan).get();
        Assert.assertEquals((long)(2 * limit), (long)results.size());
        IntStream.range(0, 2 * limit).forEach(i -> {
            int key = i / 2;
            Result result = (Result)results.get(i);
            Assert.assertEquals((long)key, (long)Bytes.toInt((byte[])result.getRow()));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((boolean)result.mayHaveMoreCellsInRow());
            int cqIndex = i % 2;
            Assert.assertEquals((long)(key * (cqIndex + 1)), (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[cqIndex])));
        });
    }

    @Test
    public void testBatchAllowPartial() throws InterruptedException, ExecutionException {
        int limit = 5;
        Scan scan = new Scan().setFilter((Filter)new ColumnCountOnRowFilter(3)).setBatch(2).setMaxResultSize(1L).setAllowPartialResults(true).setLimit(limit);
        List results = (List)TABLE.scanAll(scan).get();
        Assert.assertEquals((long)(3 * limit), (long)results.size());
        IntStream.range(0, 3 * limit).forEach(i -> {
            int key = i / 3;
            Result result = (Result)results.get(i);
            Assert.assertEquals((long)key, (long)Bytes.toInt((byte[])result.getRow()));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertTrue((boolean)result.mayHaveMoreCellsInRow());
            int cqIndex = i % 3;
            Assert.assertEquals((long)(key * (cqIndex + 1)), (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[cqIndex])));
        });
    }

    @Test
    public void testBatch() throws InterruptedException, ExecutionException {
        int limit = 5;
        Scan scan = new Scan().setFilter((Filter)new ColumnCountOnRowFilter(2)).setBatch(2).setMaxResultSize(1L).setLimit(limit);
        List results = (List)TABLE.scanAll(scan).get();
        Assert.assertEquals((long)limit, (long)results.size());
        IntStream.range(0, limit).forEach(i -> {
            Result result = (Result)results.get(i);
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getRow()));
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertTrue((boolean)result.mayHaveMoreCellsInRow());
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[0])));
            Assert.assertEquals((long)(2 * i), (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[1])));
        });
    }

    @Test
    public void testBatchAndFilterDiffer() throws InterruptedException, ExecutionException {
        int limit = 5;
        Scan scan = new Scan().setFilter((Filter)new ColumnCountOnRowFilter(3)).setBatch(2).setMaxResultSize(1L).setLimit(limit);
        List results = (List)TABLE.scanAll(scan).get();
        Assert.assertEquals((long)(2 * limit), (long)results.size());
        IntStream.range(0, limit).forEach(i -> {
            Result result = (Result)results.get(2 * i);
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getRow()));
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertTrue((boolean)result.mayHaveMoreCellsInRow());
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[0])));
            Assert.assertEquals((long)(2 * i), (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[1])));
            result = (Result)results.get(2 * i + 1);
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getRow()));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertFalse((boolean)result.mayHaveMoreCellsInRow());
            Assert.assertEquals((long)(3 * i), (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQS[2])));
        });
    }
}

