/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestRawAsyncTablePartialScan {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"async");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[][] CQS = new byte[][]{Bytes.toBytes((String)"cq1"), Bytes.toBytes((String)"cq2"), Bytes.toBytes((String)"cq3")};
    private static int COUNT = 100;
    private static AsyncConnection CONN;
    private static RawAsyncTable TABLE;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        TABLE = CONN.getRawTable(TABLE_NAME);
        TABLE.putAll(IntStream.range(0, COUNT).mapToObj(i -> new Put(Bytes.toBytes((String)String.format("%02d", i))).addColumn(FAMILY, CQS[0], Bytes.toBytes((int)i)).addColumn(FAMILY, CQS[1], Bytes.toBytes((int)(2 * i))).addColumn(FAMILY, CQS[2], Bytes.toBytes((int)(3 * i)))).collect(Collectors.toList())).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        CONN.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testBatchDoNotAllowPartial() throws InterruptedException, ExecutionException {
        List results = (List)TABLE.scanAll(new Scan().setBatch(2).setMaxResultSize(1L)).get();
        Assert.assertEquals((long)(2 * COUNT), (long)results.size());
        for (int i = 0; i < COUNT; ++i) {
            Result firstTwo = (Result)results.get(2 * i);
            Assert.assertEquals((Object)String.format("%02d", i), (Object)Bytes.toString((byte[])firstTwo.getRow()));
            Assert.assertEquals((long)2L, (long)firstTwo.size());
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])firstTwo.getValue(FAMILY, CQS[0])));
            Assert.assertEquals((long)(2 * i), (long)Bytes.toInt((byte[])firstTwo.getValue(FAMILY, CQS[1])));
            Result secondOne = (Result)results.get(2 * i + 1);
            Assert.assertEquals((Object)String.format("%02d", i), (Object)Bytes.toString((byte[])secondOne.getRow()));
            Assert.assertEquals((long)1L, (long)secondOne.size());
            Assert.assertEquals((long)(3 * i), (long)Bytes.toInt((byte[])secondOne.getValue(FAMILY, CQS[2])));
        }
    }

    @Test
    public void testReversedBatchDoNotAllowPartial() throws InterruptedException, ExecutionException {
        List results = (List)TABLE.scanAll(new Scan().setBatch(2).setMaxResultSize(1L).setReversed(true)).get();
        Assert.assertEquals((long)(2 * COUNT), (long)results.size());
        for (int i = 0; i < COUNT; ++i) {
            int row = COUNT - i - 1;
            Result firstTwo = (Result)results.get(2 * i);
            Assert.assertEquals((Object)String.format("%02d", row), (Object)Bytes.toString((byte[])firstTwo.getRow()));
            Assert.assertEquals((long)2L, (long)firstTwo.size());
            Assert.assertEquals((long)row, (long)Bytes.toInt((byte[])firstTwo.getValue(FAMILY, CQS[0])));
            Assert.assertEquals((long)(2 * row), (long)Bytes.toInt((byte[])firstTwo.getValue(FAMILY, CQS[1])));
            Result secondOne = (Result)results.get(2 * i + 1);
            Assert.assertEquals((Object)String.format("%02d", row), (Object)Bytes.toString((byte[])secondOne.getRow()));
            Assert.assertEquals((long)1L, (long)secondOne.size());
            Assert.assertEquals((long)(3 * row), (long)Bytes.toInt((byte[])secondOne.getValue(FAMILY, CQS[2])));
        }
    }
}

