/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class, ClientTests.class})
public class TestScannerTimeout {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestScannerTimeout.class);
    private static final byte[] SOME_BYTES = Bytes.toBytes((String)"f");
    private static final TableName TABLE_NAME = TableName.valueOf((String)"t");
    private static final int NB_ROWS = 10;
    private static final int THREAD_WAKE_FREQUENCY = 1000;
    private static final int SCANNER_TIMEOUT = 15000;
    private static final int SCANNER_CACHING = 5;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration c = TEST_UTIL.getConfiguration();
        c.setInt("hbase.client.scanner.timeout.period", 15000);
        c.setInt("hbase.server.thread.wakefrequency", 1000);
        TEST_UTIL.startMiniCluster(2);
        Table table = TEST_UTIL.createTable(TABLE_NAME, SOME_BYTES);
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(Bytes.toBytes((int)i));
            put.addColumn(SOME_BYTES, SOME_BYTES, SOME_BYTES);
            table.put(put);
        }
        table.close();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.ensureSomeNonStoppedRegionServersAvailable(2);
    }

    @Test(timeout=300000L)
    public void test2772() throws Exception {
        LOG.info((Object)"START************ test2772");
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        Scan scan = new Scan();
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.client.scanner.timeout.period", 1500000);
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        Table higherScanTimeoutTable = connection.getTable(TABLE_NAME);
        ResultScanner r = higherScanTimeoutTable.getScanner(scan);
        rs.abort("die!");
        Result[] results = r.next(10);
        Assert.assertEquals((long)10L, (long)results.length);
        r.close();
        higherScanTimeoutTable.close();
        connection.close();
        LOG.info((Object)"END ************ test2772");
    }

    @Test(timeout=300000L)
    public void test3686a() throws Exception {
        LOG.info((Object)"START ************ TEST3686A---1");
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        LOG.info((Object)"START ************ TEST3686A---1111");
        Scan scan = new Scan();
        scan.setCaching(5);
        LOG.info((Object)"************ TEST3686A");
        MetaTableAccessor.fullScanMetaAndPrint((Connection)TEST_UTIL.getAdmin().getConnection());
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.client.scanner.timeout.period", 1500000);
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        Table table = connection.getTable(TABLE_NAME);
        LOG.info((Object)"START ************ TEST3686A---22");
        ResultScanner r = table.getScanner(scan);
        LOG.info((Object)"START ************ TEST3686A---33");
        int count = 1;
        r.next();
        LOG.info((Object)"START ************ TEST3686A---44");
        rs.abort("die!");
        while (r.next() != null) {
            ++count;
        }
        Assert.assertEquals((long)10L, (long)count);
        r.close();
        table.close();
        connection.close();
        LOG.info((Object)"************ END TEST3686A");
    }

    @Test(timeout=300000L)
    public void test3686b() throws Exception {
        LOG.info((Object)"START ************ test3686b");
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        Scan scan = new Scan();
        scan.setCaching(5);
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.client.scanner.timeout.period", 1500000);
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        Table higherScanTimeoutTable = connection.getTable(TABLE_NAME);
        ResultScanner r = higherScanTimeoutTable.getScanner(scan);
        int count = 1;
        r.next();
        Thread.sleep(17000L);
        while (r.next() != null) {
            ++count;
        }
        Assert.assertEquals((long)10L, (long)count);
        r.close();
        higherScanTimeoutTable.close();
        connection.close();
        LOG.info((Object)"END ************ END test3686b");
    }
}

