/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.favored.FavoredNodesPlan;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.balancer.LoadOnlyFavoredStochasticBalancer;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={ClientTests.class, MediumTests.class})
public class TestTableFavoredNodes {
    private static final Log LOG = LogFactory.getLog(TestTableFavoredNodes.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int WAIT_TIMEOUT = 60000;
    private static final int SLAVES = 8;
    private FavoredNodesManager fnm;
    private Admin admin;
    private final byte[][] splitKeys = new byte[][]{Bytes.toBytes((int)1), Bytes.toBytes((int)9)};
    private final int NUM_REGIONS = this.splitKeys.length + 1;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setClass("hbase.master.loadbalancer.class", LoadOnlyFavoredStochasticBalancer.class, LoadBalancer.class);
        conf.set("hbase.master.wait.on.regionservers.mintostart", "8");
        conf.set("hbase.balancer.tablesOnMaster", "none");
        TEST_UTIL.startMiniCluster(8);
        TEST_UTIL.getMiniHBaseCluster().waitForActiveAndReadyMaster(60000L);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        TEST_UTIL.cleanupTestDir();
    }

    @Before
    public void setup() throws IOException {
        this.fnm = TEST_UTIL.getMiniHBaseCluster().getMaster().getFavoredNodesManager();
        this.admin = TEST_UTIL.getAdmin();
        this.admin.setBalancerRunning(false, true);
        this.admin.enableCatalogJanitor(false);
    }

    @Test
    public void testCreateTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, Bytes.toBytes((String)"f"), this.splitKeys);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        this.checkIfFavoredNodeInformationIsCorrect(tableName);
        List regions = this.admin.getTableRegions(tableName);
        TEST_UTIL.deleteTable(tableName);
        this.checkNoFNForDeletedTable(regions);
    }

    @Test
    public void testTruncateTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, Bytes.toBytes((String)"f"), this.splitKeys);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        this.checkIfFavoredNodeInformationIsCorrect(tableName);
        List regions = this.admin.getTableRegions(tableName);
        TEST_UTIL.truncateTable(tableName, true);
        this.checkNoFNForDeletedTable(regions);
        this.checkIfFavoredNodeInformationIsCorrect(tableName);
        regions = this.admin.getTableRegions(tableName);
        TEST_UTIL.truncateTable(tableName, false);
        this.checkNoFNForDeletedTable(regions);
        TEST_UTIL.deleteTable(tableName);
    }

    @Test
    public void testSplitTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table t = TEST_UTIL.createTable(tableName, Bytes.toBytes((String)"f"), this.splitKeys);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        int numberOfRegions = this.admin.getTableRegions(t.getName()).size();
        this.checkIfFavoredNodeInformationIsCorrect(tableName);
        byte[] splitPoint = Bytes.toBytes((int)0);
        RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
        HRegionInfo parent = locator.getRegionLocation(splitPoint).getRegionInfo();
        List parentFN = this.fnm.getFavoredNodes((RegionInfo)parent);
        Assert.assertNotNull((String)("FN should not be null for region: " + parent), (Object)parentFN);
        LOG.info((Object)"SPLITTING TABLE");
        this.admin.split(tableName, splitPoint);
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        LOG.info((Object)"FINISHED WAITING ON RIT");
        this.waitUntilTableRegionCountReached(tableName, numberOfRegions + 1);
        HRegionInfo daughter1 = locator.getRegionLocation(parent.getStartKey(), true).getRegionInfo();
        List daughter1FN = this.fnm.getFavoredNodes((RegionInfo)daughter1);
        HRegionInfo daughter2 = locator.getRegionLocation(splitPoint, true).getRegionInfo();
        List daughter2FN = this.fnm.getFavoredNodes((RegionInfo)daughter2);
        this.checkIfDaughterInherits2FN(parentFN, daughter1FN);
        this.checkIfDaughterInherits2FN(parentFN, daughter2FN);
        Assert.assertEquals((String)"Daughter's PRIMARY FN should be PRIMARY of parent", parentFN.get(FavoredNodesPlan.Position.PRIMARY.ordinal()), daughter1FN.get(FavoredNodesPlan.Position.PRIMARY.ordinal()));
        Assert.assertEquals((String)"Daughter's SECONDARY FN should be SECONDARY of parent", parentFN.get(FavoredNodesPlan.Position.SECONDARY.ordinal()), daughter1FN.get(FavoredNodesPlan.Position.SECONDARY.ordinal()));
        Assert.assertEquals((String)"Daughter's PRIMARY FN should be PRIMARY of parent", parentFN.get(FavoredNodesPlan.Position.PRIMARY.ordinal()), daughter2FN.get(FavoredNodesPlan.Position.PRIMARY.ordinal()));
        Assert.assertEquals((String)"Daughter's SECONDARY FN should be TERTIARY of parent", parentFN.get(FavoredNodesPlan.Position.TERTIARY.ordinal()), daughter2FN.get(FavoredNodesPlan.Position.SECONDARY.ordinal()));
        TEST_UTIL.getMiniHBaseCluster().compact(tableName, true);
        this.admin.runCatalogScan();
        ProcedureTestingUtility.waitAllProcedures((ProcedureExecutor)TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor());
        Assert.assertNull((String)"Parent FN should be null", (Object)this.fnm.getFavoredNodes((RegionInfo)parent));
        List regions = this.admin.getTableRegions(tableName);
        Threads.sleep((long)2000L);
        LOG.info((Object)"STARTING DELETE");
        TEST_UTIL.deleteTable(tableName);
        this.checkNoFNForDeletedTable(regions);
    }

    @Test
    public void testMergeTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, Bytes.toBytes((String)"f"), this.splitKeys);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        this.checkIfFavoredNodeInformationIsCorrect(tableName);
        RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
        HRegionInfo regionA = locator.getRegionLocation(HConstants.EMPTY_START_ROW).getRegionInfo();
        HRegionInfo regionB = locator.getRegionLocation(this.splitKeys[0]).getRegionInfo();
        List regionAFN = this.fnm.getFavoredNodes((RegionInfo)regionA);
        LOG.info((Object)("regionA: " + regionA.getEncodedName() + " with FN: " + this.fnm.getFavoredNodes((RegionInfo)regionA)));
        LOG.info((Object)("regionB: " + regionA.getEncodedName() + " with FN: " + this.fnm.getFavoredNodes((RegionInfo)regionB)));
        int countOfRegions = MetaTableAccessor.getRegionCount((Configuration)TEST_UTIL.getConfiguration(), (TableName)tableName);
        this.admin.mergeRegionsAsync(regionA.getEncodedNameAsBytes(), regionB.getEncodedNameAsBytes(), false).get(60L, TimeUnit.SECONDS);
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.waitUntilTableRegionCountReached(tableName, countOfRegions - 1);
        this.checkIfFavoredNodeInformationIsCorrect(tableName);
        HRegionInfo mergedRegion = locator.getRegionLocation(HConstants.EMPTY_START_ROW).getRegionInfo();
        List mergedFN = this.fnm.getFavoredNodes((RegionInfo)mergedRegion);
        Assert.assertArrayEquals((String)"Merged region doesn't match regionA's FN", (Object[])regionAFN.toArray(), (Object[])mergedFN.toArray());
        TEST_UTIL.getMiniHBaseCluster().compact(tableName, true);
        Assert.assertEquals((String)"Merge parents should have been cleaned", (long)1L, (long)this.admin.runCatalogScan());
        ProcedureTestingUtility.waitAllProcedures((ProcedureExecutor)TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor());
        Assert.assertNull((String)"Parent FN should be null", (Object)this.fnm.getFavoredNodes((RegionInfo)regionA));
        Assert.assertNull((String)"Parent FN should be null", (Object)this.fnm.getFavoredNodes((RegionInfo)regionB));
        List regions = this.admin.getTableRegions(tableName);
        TEST_UTIL.deleteTable(tableName);
        this.checkNoFNForDeletedTable(regions);
    }

    private void checkNoFNForDeletedTable(List<HRegionInfo> regions) {
        for (HRegionInfo region : regions) {
            LOG.info((Object)("Testing if FN data for " + region));
            Assert.assertNull((String)("FN not null for deleted table's region: " + region), (Object)this.fnm.getFavoredNodes((RegionInfo)region));
        }
    }

    private void checkIfFavoredNodeInformationIsCorrect(TableName tableName) throws Exception {
        HashMap snRSMap = Maps.newHashMap();
        for (JVMClusterUtil.RegionServerThread regionServerThread : TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads()) {
            snRSMap.put(regionServerThread.getRegionServer().getServerName(), regionServerThread.getRegionServer());
        }
        for (JVMClusterUtil.MasterThread masterThread : TEST_UTIL.getMiniHBaseCluster().getLiveMasterThreads()) {
            snRSMap.put(masterThread.getMaster().getServerName(), masterThread.getMaster());
        }
        int dnPort = this.fnm.getDataNodePort();
        RegionLocator regionLocator = this.admin.getConnection().getRegionLocator(tableName);
        for (HRegionLocation regionLocation : regionLocator.getAllRegionLocations()) {
            HRegionInfo regionInfo = regionLocation.getRegionInfo();
            List fnList = this.fnm.getFavoredNodes((RegionInfo)regionInfo);
            Assert.assertNotNull((String)("Favored nodes should not be null for region:" + regionInfo), (Object)fnList);
            Assert.assertEquals((String)("Incorrect favored nodes for region:" + regionInfo + " fnlist: " + fnList), (long)3L, (long)fnList.size());
            for (ServerName sn : fnList) {
                Assert.assertEquals((String)("FN should not have startCode, fnlist:" + fnList), (long)-1L, (long)sn.getStartcode());
            }
            HRegionServer regionServer = (HRegionServer)snRSMap.get(regionLocation.getServerName());
            Assert.assertNotNull((String)("RS should not be null for regionLocation: " + regionLocation), (Object)regionServer);
            InetSocketAddress[] rsFavNodes = regionServer.getFavoredNodesForRegion(regionInfo.getEncodedName());
            Assert.assertNotNull((String)("RS " + regionLocation.getServerName() + " does not have FN for region: " + regionInfo), (Object)rsFavNodes);
            Assert.assertEquals((String)("Incorrect FN for region:" + regionInfo.getEncodedName() + " on server:" + regionLocation.getServerName()), (long)3L, (long)rsFavNodes.length);
            for (ServerName sn : this.fnm.getFavoredNodesWithDNPort((RegionInfo)regionInfo)) {
                Assert.assertEquals((String)("FN should not have startCode, fnlist:" + fnList), (long)-1L, (long)sn.getStartcode());
                Assert.assertEquals((String)("FN port should belong to DN port, fnlist:" + fnList), (long)dnPort, (long)sn.getPort());
            }
        }
    }

    @Test
    public void testSystemTables() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, Bytes.toBytes((String)"f"), this.splitKeys);
        TEST_UTIL.waitUntilAllRegionsAssigned(tableName);
        this.checkIfFavoredNodeInformationIsCorrect(tableName);
        for (TableName sysTable : this.admin.listTableNamesByNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR)) {
            List regions = this.admin.getTableRegions(sysTable);
            for (HRegionInfo region : regions) {
                Assert.assertNull((String)"FN should be null for sys region", (Object)this.fnm.getFavoredNodes((RegionInfo)region));
            }
        }
        TEST_UTIL.deleteTable(tableName);
    }

    private void checkIfDaughterInherits2FN(List<ServerName> parentFN, List<ServerName> daughterFN) {
        Assert.assertNotNull(parentFN);
        Assert.assertNotNull(daughterFN);
        ArrayList favoredNodes = Lists.newArrayList(daughterFN);
        favoredNodes.removeAll(parentFN);
        Assert.assertTrue((String)("Daughter FN:" + daughterFN + " should have inherited 2 FN from parent FN:" + parentFN), (favoredNodes.size() <= 1 ? 1 : 0) != 0);
    }

    private void waitUntilTableRegionCountReached(final TableName tableName, final int numRegions) throws Exception {
        TEST_UTIL.waitFor(60000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return MetaTableAccessor.getRegionCount((Configuration)TEST_UTIL.getConfiguration(), (TableName)tableName) == numRegions;
            }
        });
    }
}

