/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ReplicationPeerNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.client.replication.ReplicationSerDeHelper;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesArguments;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, ClientTests.class})
public class TestReplicationAdmin {
    private static final Log LOG = LogFactory.getLog(TestReplicationAdmin.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final String ID_ONE = "1";
    private final String KEY_ONE = "127.0.0.1:2181:/hbase";
    private final String ID_SECOND = "2";
    private final String KEY_SECOND = "127.0.0.1:2181:/hbase2";
    private static ReplicationAdmin admin;
    private static Admin hbaseAdmin;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.retries.number", 1);
        admin = new ReplicationAdmin(conf);
        hbaseAdmin = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (admin != null) {
            admin.close();
        }
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testAddRemovePeer() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        ReplicationPeerConfig rpc2 = new ReplicationPeerConfig();
        rpc2.setClusterKey("127.0.0.1:2181:/hbase2");
        admin.addPeer("1", rpc1, null);
        try {
            admin.addPeer("1", rpc1, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        try {
            admin.removePeer("2");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        try {
            admin.addPeer("2", rpc2, null);
        }
        catch (Exception iae) {
            Assert.fail();
        }
        Assert.assertEquals((long)2L, (long)admin.getPeersCount());
        admin.removePeer("1");
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        admin.removePeer("2");
        Assert.assertEquals((long)0L, (long)admin.getPeersCount());
    }

    @Test
    public void testPeerConfig() throws Exception {
        ReplicationPeerConfig config = new ReplicationPeerConfig();
        config.setClusterKey("127.0.0.1:2181:/hbase");
        config.getConfiguration().put("key1", "value1");
        config.getConfiguration().put("key2", "value2");
        hbaseAdmin.addReplicationPeer("1", config);
        List peers = hbaseAdmin.listReplicationPeers();
        Assert.assertEquals((long)1L, (long)peers.size());
        ReplicationPeerDescription peerOne = (ReplicationPeerDescription)peers.get(0);
        Assert.assertNotNull((Object)peerOne);
        Assert.assertEquals((Object)"value1", peerOne.getPeerConfig().getConfiguration().get("key1"));
        Assert.assertEquals((Object)"value2", peerOne.getPeerConfig().getConfiguration().get("key2"));
        hbaseAdmin.removeReplicationPeer("1");
    }

    @Test
    public void testAddPeerWithUnDeletedQueues() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        ReplicationPeerConfig rpc2 = new ReplicationPeerConfig();
        rpc2.setClusterKey("127.0.0.1:2181:/hbase2");
        Configuration conf = TEST_UTIL.getConfiguration();
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "Test HBaseAdmin", null);
        ReplicationQueues repQueues = ReplicationFactory.getReplicationQueues((ReplicationQueuesArguments)new ReplicationQueuesArguments(conf, null, zkw));
        repQueues.init("server1");
        repQueues.addLog("1", "file1");
        try {
            admin.addPeer("1", rpc1, null);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        repQueues.removeQueue("1");
        Assert.assertEquals((long)0L, (long)repQueues.getAllQueues().size());
        repQueues.addLog("1-server2", "file1");
        try {
            admin.addPeer("1", rpc2, null);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        repQueues.removeAllQueues();
        zkw.close();
    }

    @Test
    public void testEnableDisable() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        admin.addPeer("1", rpc1, null);
        Assert.assertEquals((long)1L, (long)admin.getPeersCount());
        Assert.assertTrue((boolean)admin.getPeerState("1"));
        admin.disablePeer("1");
        Assert.assertFalse((boolean)admin.getPeerState("1"));
        try {
            admin.getPeerState("2");
        }
        catch (ReplicationPeerNotFoundException replicationPeerNotFoundException) {
            // empty catch block
        }
        admin.removePeer("1");
    }

    @Test
    public void testAppendPeerTableCFs() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "t1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "t2"));
        TableName tableName3 = TableName.valueOf((String)(this.name.getMethodName() + "t3"));
        TableName tableName4 = TableName.valueOf((String)(this.name.getMethodName() + "t4"));
        TableName tableName5 = TableName.valueOf((String)(this.name.getMethodName() + "t5"));
        TableName tableName6 = TableName.valueOf((String)(this.name.getMethodName() + "t6"));
        admin.addPeer("1", rpc1, null);
        HashMap tableCFs = new HashMap();
        tableCFs.put(tableName1, null);
        admin.appendPeerTableCFs("1", tableCFs);
        Map result = ReplicationSerDeHelper.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)true, (Object)result.containsKey(tableName1));
        Assert.assertNull(result.get(tableName1));
        tableCFs.clear();
        tableCFs.put(tableName2, null);
        admin.appendPeerTableCFs("1", tableCFs);
        result = ReplicationSerDeHelper.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tableName1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tableName2));
        Assert.assertNull(result.get(tableName1));
        Assert.assertNull(result.get(tableName2));
        tableCFs.clear();
        tableCFs.put(tableName3, new ArrayList());
        ((List)tableCFs.get(tableName3)).add("f1");
        admin.appendPeerTableCFs("1", tableCFs);
        result = ReplicationSerDeHelper.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tableName1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tableName2));
        Assert.assertTrue((String)"Should contain t3", (boolean)result.containsKey(tableName3));
        Assert.assertNull(result.get(tableName1));
        Assert.assertNull(result.get(tableName2));
        Assert.assertEquals((long)1L, (long)((List)result.get(tableName3)).size());
        Assert.assertEquals((Object)"f1", ((List)result.get(tableName3)).get(0));
        tableCFs.clear();
        tableCFs.put(tableName4, new ArrayList());
        ((List)tableCFs.get(tableName4)).add("f1");
        ((List)tableCFs.get(tableName4)).add("f2");
        admin.appendPeerTableCFs("1", tableCFs);
        result = ReplicationSerDeHelper.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tableName1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tableName2));
        Assert.assertTrue((String)"Should contain t3", (boolean)result.containsKey(tableName3));
        Assert.assertTrue((String)"Should contain t4", (boolean)result.containsKey(tableName4));
        Assert.assertNull(result.get(tableName1));
        Assert.assertNull(result.get(tableName2));
        Assert.assertEquals((long)1L, (long)((List)result.get(tableName3)).size());
        Assert.assertEquals((Object)"f1", ((List)result.get(tableName3)).get(0));
        Assert.assertEquals((long)2L, (long)((List)result.get(tableName4)).size());
        Assert.assertEquals((Object)"f1", ((List)result.get(tableName4)).get(0));
        Assert.assertEquals((Object)"f2", ((List)result.get(tableName4)).get(1));
        tableCFs.clear();
        tableCFs.put(tableName5, new ArrayList());
        admin.appendPeerTableCFs("1", tableCFs);
        tableCFs.clear();
        tableCFs.put(tableName5, new ArrayList());
        ((List)tableCFs.get(tableName5)).add("f1");
        admin.appendPeerTableCFs("1", tableCFs);
        result = ReplicationSerDeHelper.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)5L, (long)result.size());
        Assert.assertTrue((String)"Should contain t5", (boolean)result.containsKey(tableName5));
        Assert.assertNull(result.get(tableName5));
        tableCFs.clear();
        tableCFs.put(tableName6, new ArrayList());
        ((List)tableCFs.get(tableName6)).add("f1");
        admin.appendPeerTableCFs("1", tableCFs);
        tableCFs.clear();
        tableCFs.put(tableName6, new ArrayList());
        admin.appendPeerTableCFs("1", tableCFs);
        result = ReplicationSerDeHelper.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)6L, (long)result.size());
        Assert.assertTrue((String)"Should contain t6", (boolean)result.containsKey(tableName6));
        Assert.assertNull(result.get(tableName6));
        admin.removePeer("1");
    }

    @Test
    public void testRemovePeerTableCFs() throws Exception {
        ReplicationPeerConfig rpc1 = new ReplicationPeerConfig();
        rpc1.setClusterKey("127.0.0.1:2181:/hbase");
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "t1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "t2"));
        TableName tableName3 = TableName.valueOf((String)(this.name.getMethodName() + "t3"));
        TableName tableName4 = TableName.valueOf((String)(this.name.getMethodName() + "t4"));
        admin.addPeer("1", rpc1, null);
        HashMap tableCFs = new HashMap();
        try {
            tableCFs.put(tableName3, null);
            admin.removePeerTableCFs("1", tableCFs);
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        Assert.assertNull((Object)admin.getPeerTableCFs("1"));
        tableCFs.clear();
        tableCFs.put(tableName1, null);
        tableCFs.put(tableName2, new ArrayList());
        ((List)tableCFs.get(tableName2)).add("cf1");
        admin.setPeerTableCFs("1", tableCFs);
        try {
            tableCFs.clear();
            tableCFs.put(tableName3, null);
            admin.removePeerTableCFs("1", tableCFs);
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        Map result = ReplicationSerDeHelper.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertTrue((String)"Should contain t1", (boolean)result.containsKey(tableName1));
        Assert.assertTrue((String)"Should contain t2", (boolean)result.containsKey(tableName2));
        Assert.assertNull(result.get(tableName1));
        Assert.assertEquals((long)1L, (long)((List)result.get(tableName2)).size());
        Assert.assertEquals((Object)"cf1", ((List)result.get(tableName2)).get(0));
        try {
            tableCFs.clear();
            tableCFs.put(tableName1, new ArrayList());
            ((List)tableCFs.get(tableName1)).add("f1");
            admin.removePeerTableCFs("1", tableCFs);
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        tableCFs.clear();
        tableCFs.put(tableName1, null);
        admin.removePeerTableCFs("1", tableCFs);
        result = ReplicationSerDeHelper.parseTableCFsFromConfig((String)admin.getPeerTableCFs("1"));
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((long)1L, (long)((List)result.get(tableName2)).size());
        Assert.assertEquals((Object)"cf1", ((List)result.get(tableName2)).get(0));
        try {
            tableCFs.clear();
            tableCFs.put(tableName2, null);
            admin.removePeerTableCFs("1", tableCFs);
            Assert.assertTrue((boolean)false);
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        tableCFs.clear();
        tableCFs.put(tableName2, new ArrayList());
        ((List)tableCFs.get(tableName2)).add("cf1");
        admin.removePeerTableCFs("1", tableCFs);
        Assert.assertNull((Object)admin.getPeerTableCFs("1"));
        tableCFs.clear();
        tableCFs.put(tableName4, new ArrayList());
        admin.setPeerTableCFs("1", tableCFs);
        admin.removePeerTableCFs("1", tableCFs);
        Assert.assertNull((Object)admin.getPeerTableCFs("1"));
        admin.removePeer("1");
    }

    @Test
    public void testSetPeerNamespaces() throws Exception {
        String ns1 = "ns1";
        String ns2 = "ns2";
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        hbaseAdmin.addReplicationPeer("1", rpc);
        rpc = admin.getPeerConfig("1");
        Set<String> namespaces = new HashSet<String>();
        namespaces.add(ns1);
        namespaces.add(ns2);
        rpc.setNamespaces(namespaces);
        admin.updatePeerConfig("1", rpc);
        namespaces = admin.getPeerConfig("1").getNamespaces();
        Assert.assertEquals((long)2L, (long)namespaces.size());
        Assert.assertTrue((boolean)namespaces.contains(ns1));
        Assert.assertTrue((boolean)namespaces.contains(ns2));
        rpc = admin.getPeerConfig("1");
        namespaces.clear();
        namespaces.add(ns1);
        rpc.setNamespaces(namespaces);
        admin.updatePeerConfig("1", rpc);
        namespaces = admin.getPeerConfig("1").getNamespaces();
        Assert.assertEquals((long)1L, (long)namespaces.size());
        Assert.assertTrue((boolean)namespaces.contains(ns1));
        admin.removePeer("1");
    }

    @Test
    public void testNamespacesAndTableCfsConfigConflict() throws Exception {
        String ns1 = "ns1";
        String ns2 = "ns2";
        TableName tableName1 = TableName.valueOf((String)(ns1 + ":" + this.name.getMethodName()));
        TableName tableName2 = TableName.valueOf((String)(ns2 + ":" + this.name.getMethodName() + "2"));
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        hbaseAdmin.addReplicationPeer("1", rpc);
        rpc = admin.getPeerConfig("1");
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add(ns1);
        rpc.setNamespaces(namespaces);
        admin.updatePeerConfig("1", rpc);
        rpc = admin.getPeerConfig("1");
        HashMap tableCfs = new HashMap();
        tableCfs.put(tableName1, new ArrayList());
        rpc.setTableCFsMap(tableCfs);
        try {
            admin.updatePeerConfig("1", rpc);
            Assert.fail((String)("Should throw ReplicationException, because table " + tableName1 + " conflict with namespace " + ns1));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        rpc = admin.getPeerConfig("1");
        tableCfs.clear();
        tableCfs.put(tableName2, new ArrayList());
        rpc.setTableCFsMap(tableCfs);
        admin.updatePeerConfig("1", rpc);
        rpc = admin.getPeerConfig("1");
        namespaces.clear();
        namespaces.add(ns2);
        rpc.setNamespaces(namespaces);
        try {
            admin.updatePeerConfig("1", rpc);
            Assert.fail((String)("Should throw ReplicationException, because namespace " + ns2 + " conflict with table " + tableName2));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        admin.removePeer("1");
    }

    @Test
    public void testPeerBandwidth() throws Exception {
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey("127.0.0.1:2181:/hbase");
        hbaseAdmin.addReplicationPeer("1", rpc);
        rpc = admin.getPeerConfig("1");
        Assert.assertEquals((long)0L, (long)rpc.getBandwidth());
        rpc.setBandwidth(0x200000L);
        admin.updatePeerConfig("1", rpc);
        Assert.assertEquals((long)0x200000L, (long)admin.getPeerConfig("1").getBandwidth());
        admin.removePeer("1");
    }
}

