/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.WALCoprocessor;
import org.apache.hadoop.hbase.coprocessor.WALCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.WALObserver;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;

public class SampleRegionWALCoprocessor
implements WALCoprocessor,
RegionCoprocessor,
WALObserver,
RegionObserver {
    private static final Log LOG = LogFactory.getLog(SampleRegionWALCoprocessor.class);
    private byte[] tableName;
    private byte[] row;
    private byte[] ignoredFamily;
    private byte[] ignoredQualifier;
    private byte[] addedFamily;
    private byte[] addedQualifier;
    private byte[] changedFamily;
    private byte[] changedQualifier;
    private boolean preWALWriteCalled = false;
    private boolean postWALWriteCalled = false;
    private boolean preWALRestoreCalled = false;
    private boolean postWALRestoreCalled = false;
    private boolean preWALRollCalled = false;
    private boolean postWALRollCalled = false;

    public void setTestValues(byte[] tableName, byte[] row, byte[] igf, byte[] igq, byte[] chf, byte[] chq, byte[] addf, byte[] addq) {
        this.row = row;
        this.tableName = tableName;
        this.ignoredFamily = igf;
        this.ignoredQualifier = igq;
        this.addedFamily = addf;
        this.addedQualifier = addq;
        this.changedFamily = chf;
        this.changedQualifier = chq;
        this.preWALWriteCalled = false;
        this.postWALWriteCalled = false;
        this.preWALRestoreCalled = false;
        this.postWALRestoreCalled = false;
        this.preWALRollCalled = false;
        this.postWALRollCalled = false;
    }

    public Optional<WALObserver> getWALObserver() {
        return Optional.of(this);
    }

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void postWALWrite(ObserverContext<? extends WALCoprocessorEnvironment> env, RegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        this.postWALWriteCalled = true;
    }

    public void preWALWrite(ObserverContext<? extends WALCoprocessorEnvironment> env, RegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        if (!Bytes.equals((byte[])info.getTable().toBytes(), (byte[])this.tableName)) {
            return;
        }
        this.preWALWriteCalled = true;
        ArrayList cells = logEdit.getCells();
        Cell deletedCell = null;
        for (Cell cell : cells) {
            byte[] family = CellUtil.cloneFamily((Cell)cell);
            byte[] qulifier = CellUtil.cloneQualifier((Cell)cell);
            if (Arrays.equals(family, this.ignoredFamily) && Arrays.equals(qulifier, this.ignoredQualifier)) {
                LOG.debug((Object)"Found the KeyValue from WALEdit which should be ignored.");
                deletedCell = cell;
            }
            if (!Arrays.equals(family, this.changedFamily) || !Arrays.equals(qulifier, this.changedQualifier)) continue;
            LOG.debug((Object)"Found the KeyValue from WALEdit which should be changed.");
            byte[] byArray = cell.getValueArray();
            int n = cell.getValueOffset();
            byArray[n] = (byte)(byArray[n] + 1);
        }
        if (null != this.row) {
            cells.add(new KeyValue(this.row, this.addedFamily, this.addedQualifier));
        }
        if (deletedCell != null) {
            LOG.debug((Object)"About to delete a KeyValue from WALEdit.");
            cells.remove(deletedCell);
        }
    }

    public void preWALRestore(ObserverContext<? extends RegionCoprocessorEnvironment> env, RegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        this.preWALRestoreCalled = true;
    }

    public void preWALRoll(ObserverContext<? extends WALCoprocessorEnvironment> ctx, Path oldPath, Path newPath) throws IOException {
        this.preWALRollCalled = true;
    }

    public void postWALRoll(ObserverContext<? extends WALCoprocessorEnvironment> ctx, Path oldPath, Path newPath) throws IOException {
        this.postWALRollCalled = true;
    }

    public void postWALRestore(ObserverContext<? extends RegionCoprocessorEnvironment> env, RegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        this.postWALRestoreCalled = true;
    }

    public boolean isPreWALWriteCalled() {
        return this.preWALWriteCalled;
    }

    public boolean isPostWALWriteCalled() {
        return this.postWALWriteCalled;
    }

    public boolean isPreWALRestoreCalled() {
        LOG.debug((Object)(SampleRegionWALCoprocessor.class.getName() + ".isPreWALRestoreCalled is called."));
        return this.preWALRestoreCalled;
    }

    public boolean isPostWALRestoreCalled() {
        LOG.debug((Object)(SampleRegionWALCoprocessor.class.getName() + ".isPostWALRestoreCalled is called."));
        return this.postWALRestoreCalled;
    }

    public boolean isPreWALRollCalled() {
        return this.preWALRollCalled;
    }

    public boolean isPostWALRollCalled() {
        return this.postWALRollCalled;
    }
}

