/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.NullComparator;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={FilterTests.class, SmallTests.class})
public class TestComparatorSerialization {
    @Test
    public void testBinaryComparator() throws Exception {
        BinaryComparator binaryComparator = new BinaryComparator(Bytes.toBytes((String)"binaryComparator"));
        Assert.assertTrue((boolean)binaryComparator.areSerializedFieldsEqual(ProtobufUtil.toComparator((ComparatorProtos.Comparator)ProtobufUtil.toComparator((ByteArrayComparable)binaryComparator))));
    }

    @Test
    public void testBinaryPrefixComparator() throws Exception {
        BinaryPrefixComparator binaryPrefixComparator = new BinaryPrefixComparator(Bytes.toBytes((String)"binaryPrefixComparator"));
        Assert.assertTrue((boolean)binaryPrefixComparator.areSerializedFieldsEqual(ProtobufUtil.toComparator((ComparatorProtos.Comparator)ProtobufUtil.toComparator((ByteArrayComparable)binaryPrefixComparator))));
    }

    @Test
    public void testBitComparator() throws Exception {
        BitComparator bitComparator = new BitComparator(Bytes.toBytes((String)"bitComparator"), BitComparator.BitwiseOp.XOR);
        Assert.assertTrue((boolean)bitComparator.areSerializedFieldsEqual(ProtobufUtil.toComparator((ComparatorProtos.Comparator)ProtobufUtil.toComparator((ByteArrayComparable)bitComparator))));
    }

    @Test
    public void testNullComparator() throws Exception {
        NullComparator nullComparator = new NullComparator();
        Assert.assertTrue((boolean)nullComparator.areSerializedFieldsEqual(ProtobufUtil.toComparator((ComparatorProtos.Comparator)ProtobufUtil.toComparator((ByteArrayComparable)nullComparator))));
    }

    @Test
    public void testRegexStringComparator() throws Exception {
        RegexStringComparator regexStringComparator = new RegexStringComparator(".+-2");
        Assert.assertTrue((boolean)regexStringComparator.areSerializedFieldsEqual(ProtobufUtil.toComparator((ComparatorProtos.Comparator)ProtobufUtil.toComparator((ByteArrayComparable)regexStringComparator))));
        try {
            new RegexStringComparator("regex", 34);
        }
        catch (Throwable t) {
            Assert.assertNull((String)"Exception occurred while created the RegexStringComparator object", (Object)t);
        }
    }

    @Test
    public void testSubstringComparator() throws Exception {
        SubstringComparator substringComparator = new SubstringComparator("substr");
        Assert.assertTrue((boolean)substringComparator.areSerializedFieldsEqual(ProtobufUtil.toComparator((ComparatorProtos.Comparator)ProtobufUtil.toComparator((ByteArrayComparable)substringComparator))));
    }
}

