/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={FilterTests.class, SmallTests.class})
public class TestInclusiveStopFilter {
    private final byte[] STOP_ROW = Bytes.toBytes((String)"stop_row");
    private final byte[] GOOD_ROW = Bytes.toBytes((String)"good_row");
    private final byte[] PAST_STOP_ROW = Bytes.toBytes((String)"zzzzzz");
    Filter mainFilter;

    @Before
    public void setUp() throws Exception {
        this.mainFilter = new InclusiveStopFilter(this.STOP_ROW);
    }

    @Test
    public void testStopRowIdentification() throws Exception {
        this.stopRowTests(this.mainFilter);
    }

    @Test
    public void testSerialization() throws Exception {
        byte[] buffer = this.mainFilter.toByteArray();
        InclusiveStopFilter newFilter = InclusiveStopFilter.parseFrom((byte[])buffer);
        this.stopRowTests((Filter)newFilter);
    }

    private void stopRowTests(Filter filter) throws Exception {
        Assert.assertFalse((String)("Filtering on " + Bytes.toString((byte[])this.GOOD_ROW)), (boolean)filter.filterRowKey((Cell)KeyValueUtil.createFirstOnRow((byte[])this.GOOD_ROW)));
        Assert.assertFalse((String)("Filtering on " + Bytes.toString((byte[])this.STOP_ROW)), (boolean)filter.filterRowKey((Cell)KeyValueUtil.createFirstOnRow((byte[])this.STOP_ROW)));
        Assert.assertTrue((String)("Filtering on " + Bytes.toString((byte[])this.PAST_STOP_ROW)), (boolean)filter.filterRowKey((Cell)KeyValueUtil.createFirstOnRow((byte[])this.PAST_STOP_ROW)));
        Assert.assertTrue((String)"FilterAllRemaining", (boolean)filter.filterAllRemaining());
        Assert.assertFalse((String)"FilterNotNull", (boolean)filter.filterRow());
    }
}

