/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.filter.NullComparator;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={FilterTests.class, SmallTests.class})
public class TestNullComparator {
    @Test
    public void testNullValue() {
        byte[] value = null;
        NullComparator comparator = new NullComparator();
        int comp1 = comparator.compareTo(value);
        int comp2 = comparator.compareTo(value, 5, 15);
        Assert.assertEquals((long)0L, (long)comp1);
        Assert.assertEquals((long)0L, (long)comp2);
    }

    @Test
    public void testNonNullValue() {
        byte[] value = new byte[]{0, 1, 2, 3, 4, 5};
        NullComparator comparator = new NullComparator();
        int comp1 = comparator.compareTo(value);
        int comp2 = comparator.compareTo(value, 1, 3);
        Assert.assertEquals((long)1L, (long)comp1);
        Assert.assertEquals((long)1L, (long)comp2);
    }

    @Test
    public void testEmptyValue() {
        byte[] value = new byte[]{0};
        NullComparator comparator = new NullComparator();
        int comp1 = comparator.compareTo(value);
        int comp2 = comparator.compareTo(value, 1, 3);
        Assert.assertEquals((long)1L, (long)comp1);
        Assert.assertEquals((long)1L, (long)comp2);
    }
}

