/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={FilterTests.class, SmallTests.class})
public class TestSingleColumnValueExcludeFilter {
    private static final byte[] ROW = Bytes.toBytes((String)"test");
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"test");
    private static final byte[] COLUMN_QUALIFIER = Bytes.toBytes((String)"foo");
    private static final byte[] COLUMN_QUALIFIER_2 = Bytes.toBytes((String)"foo_2");
    private static final byte[] VAL_1 = Bytes.toBytes((String)"a");
    private static final byte[] VAL_2 = Bytes.toBytes((String)"ab");

    @Test
    public void testFilterCell() throws Exception {
        SingleColumnValueExcludeFilter filter = new SingleColumnValueExcludeFilter(COLUMN_FAMILY, COLUMN_QUALIFIER, CompareOperator.EQUAL, VAL_1);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        KeyValue c = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        kvs.add(new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1));
        kvs.add(new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_1));
        kvs.add(new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1));
        filter.filterRowCells(kvs);
        Assert.assertEquals((String)"resultSize", (long)kvs.size(), (long)2L);
        Assert.assertTrue((String)"leftKV1", (CellComparatorImpl.COMPARATOR.compare((Cell)kvs.get(0), (Cell)c) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"leftKV2", (CellComparatorImpl.COMPARATOR.compare((Cell)kvs.get(1), (Cell)c) == 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"allRemainingWhenMatch", (boolean)filter.filterAllRemaining());
        filter.reset();
        c = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        Assert.assertTrue((String)"otherColumn", (filter.filterCell((Cell)c) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        c = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_2);
        Assert.assertTrue((String)"testedMismatch", (filter.filterCell((Cell)c) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
        c = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        Assert.assertTrue((String)"otherColumn", (filter.filterCell((Cell)c) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
    }
}

