/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestPrefixTree {
    private static final String row4 = "a-b-B-2-1402397300-1402416535";
    private static final byte[] row4_bytes = Bytes.toBytes((String)"a-b-B-2-1402397300-1402416535");
    private static final String row3 = "a-b-A-1-1402397227-1402415999";
    private static final byte[] row3_bytes = Bytes.toBytes((String)"a-b-A-1-1402397227-1402415999");
    private static final String row2 = "a-b-A-1-1402329600-1402396277";
    private static final byte[] row2_bytes = Bytes.toBytes((String)"a-b-A-1-1402329600-1402396277");
    private static final String row1 = "a-b-A-1";
    private static final byte[] row1_bytes = Bytes.toBytes((String)"a-b-A-1");
    private static final byte[] fam = Bytes.toBytes((String)"cf_1");
    private static final byte[] qual1 = Bytes.toBytes((String)"qf_1");
    private static final byte[] qual2 = Bytes.toBytes((String)"qf_2");
    private final HBaseTestingUtility testUtil = new HBaseTestingUtility();
    private HRegion region;

    @Before
    public void setUp() throws Exception {
        TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName());
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(fam).setDataBlockEncoding(DataBlockEncoding.PREFIX_TREE));
        HRegionInfo info = new HRegionInfo(tableName, null, null, false);
        Path path = this.testUtil.getDataTestDir(this.getClass().getSimpleName());
        this.region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)info, path, this.testUtil.getConfiguration(), (TableDescriptor)htd);
    }

    @After
    public void tearDown() throws Exception {
        HBaseTestingUtility.closeRegionAndWAL(this.region);
        this.testUtil.cleanupTestDir();
    }

    @Test
    public void testHBASE11728() throws Exception {
        CellScanner cellScanner;
        int i;
        Put put = new Put(Bytes.toBytes((String)"a-b-0-0"));
        put.addColumn(fam, qual1, Bytes.toBytes((String)"c1-value"));
        this.region.put(put);
        put = new Put(row1_bytes);
        put.addColumn(fam, qual1, Bytes.toBytes((String)"c1-value"));
        this.region.put(put);
        put = new Put(row2_bytes);
        put.addColumn(fam, qual2, Bytes.toBytes((String)"c2-value"));
        this.region.put(put);
        put = new Put(row3_bytes);
        put.addColumn(fam, qual2, Bytes.toBytes((String)"c2-value-2"));
        this.region.put(put);
        put = new Put(row4_bytes);
        put.addColumn(fam, qual2, Bytes.toBytes((String)"c2-value-3"));
        this.region.put(put);
        this.region.flush(true);
        String[] rows = new String[]{row1, row2, row3};
        byte[][] val = new byte[][]{Bytes.toBytes((String)"c1-value"), Bytes.toBytes((String)"c2-value"), Bytes.toBytes((String)"c2-value-2")};
        Scan scan = new Scan();
        scan.setStartRow(row1_bytes);
        scan.setStopRow(Bytes.toBytes((String)"a-b-A-1:"));
        HRegion.RegionScannerImpl scanner = this.region.getScanner(scan);
        ArrayList cells = new ArrayList();
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)(i < 2 ? 1 : 0), (Object)scanner.next(cells));
            cellScanner = Result.create(cells).cellScanner();
            while (cellScanner.advance()) {
                Assert.assertEquals((Object)rows[i], (Object)Bytes.toString((byte[])cellScanner.current().getRowArray(), (int)cellScanner.current().getRowOffset(), (int)cellScanner.current().getRowLength()));
                Assert.assertEquals((Object)Bytes.toString((byte[])val[i]), (Object)Bytes.toString((byte[])cellScanner.current().getValueArray(), (int)cellScanner.current().getValueOffset(), (int)cellScanner.current().getValueLength()));
            }
            cells.clear();
        }
        scanner.close();
        scan = new Scan();
        scan.addColumn(fam, qual2);
        scan.setStartRow(row1_bytes);
        scan.setStopRow(Bytes.toBytes((String)"a-b-A-1:"));
        scanner = this.region.getScanner(scan);
        for (i = 1; i < 3; ++i) {
            Assert.assertEquals((Object)(i < 2 ? 1 : 0), (Object)scanner.next(cells));
            cellScanner = Result.create(cells).cellScanner();
            while (cellScanner.advance()) {
                Assert.assertEquals((Object)rows[i], (Object)Bytes.toString((byte[])cellScanner.current().getRowArray(), (int)cellScanner.current().getRowOffset(), (int)cellScanner.current().getRowLength()));
            }
            cells.clear();
        }
        scanner.close();
        scan = new Scan();
        scan.addColumn(fam, qual2);
        scan.setStartRow(Bytes.toBytes((String)"a-b-A-1-"));
        scan.setStopRow(Bytes.toBytes((String)"a-b-A-1:"));
        scanner = this.region.getScanner(scan);
        for (i = 1; i < 3; ++i) {
            Assert.assertEquals((Object)(i < 2 ? 1 : 0), (Object)scanner.next(cells));
            cellScanner = Result.create(cells).cellScanner();
            while (cellScanner.advance()) {
                Assert.assertEquals((Object)rows[i], (Object)Bytes.toString((byte[])cellScanner.current().getRowArray(), (int)cellScanner.current().getRowOffset(), (int)cellScanner.current().getRowLength()));
            }
            cells.clear();
        }
        scanner.close();
        scan = new Scan();
        scan.addColumn(fam, qual2);
        scan.setStartRow(Bytes.toBytes((String)"a-b-A-1-140239"));
        scan.setStopRow(Bytes.toBytes((String)"a-b-A-1:"));
        scanner = this.region.getScanner(scan);
        Assert.assertFalse((boolean)scanner.next(cells));
        Assert.assertFalse((boolean)cells.isEmpty());
        scanner.close();
    }

    @Test
    public void testHBASE12817() throws IOException {
        for (int i = 0; i < 100; ++i) {
            this.region.put(new Put(Bytes.toBytes((String)("obj" + (2900 + i)))).addColumn(fam, qual1, Bytes.toBytes((int)i)));
        }
        this.region.put(new Put(Bytes.toBytes((String)"obj299")).addColumn(fam, qual1, Bytes.toBytes((String)"whatever")));
        this.region.put(new Put(Bytes.toBytes((String)"obj29")).addColumn(fam, qual1, Bytes.toBytes((String)"whatever")));
        this.region.put(new Put(Bytes.toBytes((String)"obj2")).addColumn(fam, qual1, Bytes.toBytes((String)"whatever")));
        this.region.put(new Put(Bytes.toBytes((String)"obj3")).addColumn(fam, qual1, Bytes.toBytes((String)"whatever")));
        this.region.flush(true);
        Scan scan = new Scan(Bytes.toBytes((String)"obj29995"));
        HRegion.RegionScannerImpl scanner = this.region.getScanner(scan);
        ArrayList cells = new ArrayList();
        Assert.assertFalse((boolean)scanner.next(cells));
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"obj3"), (byte[])Result.create(cells).getRow());
    }
}

