/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={IOTests.class, MediumTests.class})
public class TestScannerSelectionUsingTTL {
    private static final Log LOG = LogFactory.getLog(TestScannerSelectionUsingTTL.class);
    private static final HBaseTestingUtility TEST_UTIL = HBaseTestingUtility.createLocalHTU();
    private static TableName TABLE = TableName.valueOf((String)"myTable");
    private static String FAMILY = "myCF";
    private static byte[] FAMILY_BYTES = Bytes.toBytes((String)FAMILY);
    private static final int TTL_SECONDS = 10;
    private static final int TTL_MS = 10000;
    private static final int NUM_EXPIRED_FILES = 2;
    private static final int NUM_ROWS = 8;
    private static final int NUM_COLS_PER_ROW = 5;
    public final int numFreshFiles;
    public final int totalNumFiles;
    private final boolean explicitCompaction;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int numFreshFiles = 1; numFreshFiles <= 3; ++numFreshFiles) {
            for (boolean explicitCompaction : new boolean[]{false, true}) {
                params.add(new Object[]{numFreshFiles, explicitCompaction});
            }
        }
        return params;
    }

    public TestScannerSelectionUsingTTL(int numFreshFiles, boolean explicitCompaction) {
        this.numFreshFiles = numFreshFiles;
        this.totalNumFiles = numFreshFiles + 2;
        this.explicitCompaction = explicitCompaction;
    }

    @Test
    public void testScannerSelection() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.store.delete.expired.storefile", false);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY_BYTES).setMaxVersions(Integer.MAX_VALUE).setTimeToLive(10);
        HTableDescriptor htd = new HTableDescriptor(TABLE);
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(TABLE);
        HRegion region = HBaseTestingUtility.createRegionAndWAL((RegionInfo)info, TEST_UTIL.getDataTestDir(info.getEncodedName()), conf, (TableDescriptor)htd);
        long ts = EnvironmentEdgeManager.currentTime();
        long version = 0L;
        for (int iFile = 0; iFile < this.totalNumFiles; ++iFile) {
            if (iFile == 2) {
                Threads.sleepWithoutInterrupt((long)10000L);
                version += 10000L;
            }
            for (int iRow = 0; iRow < 8; ++iRow) {
                Put put = new Put(Bytes.toBytes((String)("row" + iRow)));
                for (int iCol = 0; iCol < 5; ++iCol) {
                    put.addColumn(FAMILY_BYTES, Bytes.toBytes((String)("col" + iCol)), ts + version, Bytes.toBytes((String)("value" + iFile + "_" + iRow + "_" + iCol)));
                }
                region.put(put);
            }
            region.flush(true);
            ++version;
        }
        Scan scan = new Scan();
        scan.setMaxVersions(Integer.MAX_VALUE);
        CacheConfig cacheConf = new CacheConfig(conf);
        LruBlockCache cache = (LruBlockCache)cacheConf.getBlockCache();
        cache.clearCache();
        HRegion.RegionScannerImpl scanner = region.getScanner(scan);
        ArrayList results = new ArrayList();
        int expectedKVsPerRow = this.numFreshFiles * 5;
        int numReturnedRows = 0;
        LOG.info((Object)"Scanning the entire table");
        while (scanner.next(results) || results.size() > 0) {
            Assert.assertEquals((long)expectedKVsPerRow, (long)results.size());
            ++numReturnedRows;
            results.clear();
        }
        Assert.assertEquals((long)8L, (long)numReturnedRows);
        SortedSet accessedFiles = cache.getCachedFileNamesForTest();
        LOG.debug((Object)("Files accessed during scan: " + accessedFiles));
        if (this.explicitCompaction) {
            HStore store = region.getStore(FAMILY_BYTES);
            store.compactRecentForTestingAssumingDefaultPolicy(this.totalNumFiles);
        } else {
            region.compact(false);
        }
        HBaseTestingUtility.closeRegionAndWAL(region);
    }
}

