/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaMockingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;

@Category(value={MasterTests.class, MediumTests.class})
public class TestCatalogJanitorInMemoryStates {
    private static final Log LOG = LogFactory.getLog(TestCatalogJanitorInMemoryStates.class);
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    @Rule
    public final TestName name = new TestName();
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[] VALUE = Bytes.toBytes((String)"testValue");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=180000L)
    public void testInMemoryParentCleanup() throws IOException, InterruptedException {
        AssignmentManager am = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        ServerManager sm = TEST_UTIL.getHBaseCluster().getMaster().getServerManager();
        CatalogJanitor janitor = TEST_UTIL.getHBaseCluster().getMaster().getCatalogJanitor();
        Admin admin = TEST_UTIL.getAdmin();
        admin.enableCatalogJanitor(false);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table t = TEST_UTIL.createTable(tableName, FAMILY);
        int rowCount = TEST_UTIL.loadTable(t, FAMILY, false);
        RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);
        List allRegionLocations = locator.getAllRegionLocations();
        HRegionLocation parent = (HRegionLocation)allRegionLocations.get(0);
        List<HRegionLocation> daughters = this.splitRegion((RegionInfo)parent.getRegionInfo());
        LOG.info((Object)("Parent region: " + parent));
        LOG.info((Object)("Daughter regions: " + daughters));
        Assert.assertNotNull((String)("Should have found daughter regions for " + parent), daughters);
        Assert.assertTrue((String)"Parent region should exist in RegionStates", (boolean)am.getRegionStates().isRegionInRegionStates((RegionInfo)parent.getRegionInfo()));
        Assert.assertTrue((String)"Parent region should exist in ServerManager", (boolean)sm.isRegionInServerManagerStates((RegionInfo)parent.getRegionInfo()));
        Result r = MetaMockingUtil.getMetaTableRowResult(parent.getRegionInfo(), null, daughters.get(0).getRegionInfo(), daughters.get(1).getRegionInfo());
        janitor.cleanParent((RegionInfo)parent.getRegionInfo(), r);
        Assert.assertFalse((String)"Parent region should have been removed from RegionStates", (boolean)am.getRegionStates().isRegionInRegionStates((RegionInfo)parent.getRegionInfo()));
        Assert.assertFalse((String)"Parent region should have been removed from ServerManager", (boolean)sm.isRegionInServerManagerStates((RegionInfo)parent.getRegionInfo()));
    }

    private List<HRegionLocation> splitRegion(RegionInfo r) throws IOException, InterruptedException {
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>();
        Admin admin = TEST_UTIL.getAdmin();
        Connection connection = TEST_UTIL.getConnection();
        admin.splitRegion(r.getEncodedNameAsBytes());
        admin.close();
        PairOfSameType<RegionInfo> regions = this.waitOnDaughters(r);
        if (regions != null) {
            try (RegionLocator rl = connection.getRegionLocator(r.getTable());){
                locations.add(rl.getRegionLocation(((RegionInfo)regions.getFirst()).getEncodedNameAsBytes()));
                locations.add(rl.getRegionLocation(((RegionInfo)regions.getSecond()).getEncodedNameAsBytes()));
            }
            return locations;
        }
        return locations;
    }

    /*
     * Exception decompiling
     */
    private PairOfSameType<RegionInfo> waitOnDaughters(RegionInfo r) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

