/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClockOutOfSyncException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MockNoopMasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, SmallTests.class})
public class TestClockSkewDetection {
    private static final Log LOG = LogFactory.getLog(TestClockSkewDetection.class);

    @Test
    public void testClockSkewDetection() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        ServerManager sm = new ServerManager((MasterServices)new MockNoopMasterServices(conf){

            @Override
            public ClusterConnection getClusterConnection() {
                ClusterConnection conn = (ClusterConnection)Mockito.mock(ClusterConnection.class);
                Mockito.when((Object)conn.getRpcControllerFactory()).thenReturn(Mockito.mock(RpcControllerFactory.class));
                return conn;
            }
        }, true);
        LOG.debug((Object)"regionServerStartup 1");
        InetAddress ia1 = InetAddress.getLocalHost();
        RegionServerStatusProtos.RegionServerStartupRequest.Builder request = RegionServerStatusProtos.RegionServerStartupRequest.newBuilder();
        request.setPort(1234);
        request.setServerStartCode(-1L);
        request.setServerCurrentTime(System.currentTimeMillis());
        sm.regionServerStartup(request.build(), ia1);
        Configuration c = HBaseConfiguration.create();
        long maxSkew = c.getLong("hbase.master.maxclockskew", 30000L);
        long warningSkew = c.getLong("hbase.master.warningclockskew", 1000L);
        try {
            LOG.debug((Object)"Test: Master Time > Region Server Time");
            LOG.debug((Object)"regionServerStartup 2");
            InetAddress ia2 = InetAddress.getLocalHost();
            request = RegionServerStatusProtos.RegionServerStartupRequest.newBuilder();
            request.setPort(1235);
            request.setServerStartCode(-1L);
            request.setServerCurrentTime(System.currentTimeMillis() - maxSkew * 2L);
            sm.regionServerStartup(request.build(), ia2);
            Assert.fail((String)"HMaster should have thrown a ClockOutOfSyncException but didn't.");
        }
        catch (ClockOutOfSyncException e) {
            LOG.info((Object)("Received expected exception: " + (Object)((Object)e)));
        }
        try {
            LOG.debug((Object)"Test: Master Time < Region Server Time");
            LOG.debug((Object)"regionServerStartup 3");
            InetAddress ia3 = InetAddress.getLocalHost();
            request = RegionServerStatusProtos.RegionServerStartupRequest.newBuilder();
            request.setPort(1236);
            request.setServerStartCode(-1L);
            request.setServerCurrentTime(System.currentTimeMillis() + maxSkew * 2L);
            sm.regionServerStartup(request.build(), ia3);
            Assert.fail((String)"HMaster should have thrown a ClockOutOfSyncException but didn't.");
        }
        catch (ClockOutOfSyncException e) {
            LOG.info((Object)("Received expected exception: " + (Object)((Object)e)));
        }
        LOG.debug((Object)"regionServerStartup 4");
        InetAddress ia4 = InetAddress.getLocalHost();
        request = RegionServerStatusProtos.RegionServerStartupRequest.newBuilder();
        request.setPort(1237);
        request.setServerStartCode(-1L);
        request.setServerCurrentTime(System.currentTimeMillis() - warningSkew * 2L);
        sm.regionServerStartup(request.build(), ia4);
        LOG.debug((Object)"regionServerStartup 5");
        InetAddress ia5 = InetAddress.getLocalHost();
        request = RegionServerStatusProtos.RegionServerStartupRequest.newBuilder();
        request.setPort(1238);
        request.setServerStartCode(-1L);
        request.setServerCurrentTime(System.currentTimeMillis() + warningSkew * 2L);
        sm.regionServerStartup(request.build(), ia5);
    }
}

