/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.testclassification.FlakeyTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={FlakeyTests.class, LargeTests.class})
public class TestMasterFailover {
    private static final Log LOG = LogFactory.getLog(TestMasterFailover.class);

    private void log(String string) {
        LOG.info((Object)("\n\n" + string + " \n\n"));
    }

    @Test(timeout=240000L)
    public void testSimpleMasterFailover() throws Exception {
        int NUM_MASTERS = 3;
        int NUM_RS = 3;
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniCluster(3, 3);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        for (JVMClusterUtil.MasterThread mt : masterThreads) {
            Assert.assertTrue((boolean)mt.isAlive());
        }
        int numActive = 0;
        int activeIndex = -1;
        ServerName activeName = null;
        HMaster active = null;
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            ++numActive;
            activeIndex = i;
            active = masterThreads.get(activeIndex).getMaster();
            activeName = active.getServerName();
        }
        Assert.assertEquals((long)1L, (long)numActive);
        Assert.assertEquals((long)3L, (long)masterThreads.size());
        LOG.info((Object)("Active master " + activeName));
        Assert.assertNotNull((Object)active);
        ClusterStatus status = active.getClusterStatus();
        Assert.assertTrue((boolean)status.getMaster().equals((Object)activeName));
        Assert.assertEquals((long)2L, (long)status.getBackupMastersSize());
        Assert.assertEquals((long)2L, (long)status.getBackupMasters().size());
        int backupIndex = activeIndex == 0 ? 1 : activeIndex - 1;
        HMaster master = cluster.getMaster(backupIndex);
        LOG.debug((Object)("\n\nStopping a backup master: " + master.getServerName() + "\n"));
        cluster.stopMaster(backupIndex, false);
        cluster.waitOnMaster(backupIndex);
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            Assert.assertTrue((boolean)activeName.equals((Object)masterThreads.get(i).getMaster().getServerName()));
            activeIndex = i;
            active = masterThreads.get(activeIndex).getMaster();
        }
        Assert.assertEquals((long)1L, (long)numActive);
        Assert.assertEquals((long)2L, (long)masterThreads.size());
        int rsCount = masterThreads.get(activeIndex).getMaster().getClusterStatus().getServersSize();
        LOG.info((Object)("Active master " + active.getServerName() + " managing " + rsCount + " regions servers"));
        Assert.assertEquals((long)3L, (long)rsCount);
        Assert.assertNotNull((Object)active);
        status = active.getClusterStatus();
        Assert.assertTrue((boolean)status.getMaster().equals((Object)activeName));
        Assert.assertEquals((long)1L, (long)status.getBackupMastersSize());
        Assert.assertEquals((long)1L, (long)status.getBackupMasters().size());
        LOG.debug((Object)("\n\nStopping the active master " + active.getServerName() + "\n"));
        cluster.stopMaster(activeIndex, false);
        cluster.waitOnMaster(activeIndex);
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        LOG.debug((Object)"\n\nVerifying backup master is now active\n");
        Assert.assertEquals((long)1L, (long)masterThreads.size());
        active = masterThreads.get(0).getMaster();
        Assert.assertNotNull((Object)active);
        status = active.getClusterStatus();
        ServerName mastername = status.getMaster();
        Assert.assertTrue((boolean)mastername.equals((Object)active.getServerName()));
        Assert.assertTrue((boolean)active.isActiveMaster());
        Assert.assertEquals((long)0L, (long)status.getBackupMastersSize());
        Assert.assertEquals((long)0L, (long)status.getBackupMasters().size());
        int rss = status.getServersSize();
        LOG.info((Object)("Active master " + mastername.getServerName() + " managing " + rss + " region servers"));
        Assert.assertEquals((long)3L, (long)rss);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=180000L)
    public void testMetaInTransitionWhenMasterFailover() throws Exception {
        boolean NUM_MASTERS = true;
        boolean NUM_RS = true;
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniCluster(1, 1);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        this.log("Cluster started");
        this.log("Moving meta off the master");
        HMaster activeMaster = cluster.getMaster();
        HRegionServer rs = cluster.getRegionServer(0);
        ServerName metaServerName = cluster.getLiveRegionServerThreads().get(0).getRegionServer().getServerName();
        activeMaster.move(HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), Bytes.toBytes((String)metaServerName.getServerName()));
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        Assert.assertEquals((String)"Meta should be assigned on expected regionserver", (Object)metaServerName, (Object)activeMaster.getMetaTableLocator().getMetaRegionLocation(activeMaster.getZooKeeper()));
        this.log("Aborting master");
        activeMaster.abort("test-kill");
        cluster.waitForMasterToStop(activeMaster.getServerName(), 30000L);
        this.log("Master has aborted");
        RegionState metaState = MetaTableLocator.getMetaRegionState((ZooKeeperWatcher)rs.getZooKeeper());
        Assert.assertEquals((String)"hbase:meta should be online on RS", (Object)metaState.getServerName(), (Object)rs.getServerName());
        Assert.assertEquals((String)"hbase:meta should be online on RS", (Object)metaState.getState(), (Object)RegionState.State.OPEN);
        this.log("Starting up a new master");
        activeMaster = cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        this.log("Master is ready");
        metaState = MetaTableLocator.getMetaRegionState((ZooKeeperWatcher)activeMaster.getZooKeeper());
        Assert.assertEquals((String)"hbase:meta should be online on RS", (Object)metaState.getServerName(), (Object)rs.getServerName());
        Assert.assertEquals((String)"hbase:meta should be online on RS", (Object)metaState.getState(), (Object)RegionState.State.OPEN);
        MetaTableLocator.setMetaLocation((ZooKeeperWatcher)activeMaster.getZooKeeper(), (ServerName)rs.getServerName(), (RegionState.State)RegionState.State.OPENING);
        HRegion meta = rs.getRegion(HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
        rs.removeRegion(meta, null);
        meta.close();
        this.log("Aborting master");
        activeMaster.abort("test-kill");
        cluster.waitForMasterToStop(activeMaster.getServerName(), 30000L);
        this.log("Master has aborted");
        this.log("Starting up a new master");
        activeMaster = cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        this.log("Master is ready");
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.log("Meta was assigned");
        metaState = MetaTableLocator.getMetaRegionState((ZooKeeperWatcher)activeMaster.getZooKeeper());
        Assert.assertEquals((String)"hbase:meta should be online on RS", (Object)metaState.getServerName(), (Object)rs.getServerName());
        Assert.assertEquals((String)"hbase:meta should be online on RS", (Object)metaState.getState(), (Object)RegionState.State.OPEN);
        MetaTableLocator.setMetaLocation((ZooKeeperWatcher)activeMaster.getZooKeeper(), (ServerName)rs.getServerName(), (RegionState.State)RegionState.State.CLOSING);
        this.log("Aborting master");
        activeMaster.abort("test-kill");
        cluster.waitForMasterToStop(activeMaster.getServerName(), 30000L);
        this.log("Master has aborted");
        rs.getRSRpcServices().closeRegion(null, ProtobufUtil.buildCloseRegionRequest((ServerName)rs.getServerName(), (byte[])HRegionInfo.FIRST_META_REGIONINFO.getRegionName()));
        this.log("Starting up a new master");
        activeMaster = cluster.startMaster().getMaster();
        Assert.assertNotNull((Object)activeMaster);
        this.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        this.log("Master is ready");
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.log("Meta was assigned");
        TEST_UTIL.shutdownMiniCluster();
    }
}

