/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMasterTransitions {
    private static final Log LOG = LogFactory.getLog(TestMasterTransitions.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLENAME = TableName.valueOf((String)"master_transitions");
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.startMiniCluster(2);
        TEST_UTIL.createMultiRegionTable(TABLENAME, FAMILIES);
        Table t = TEST_UTIL.getConnection().getTable(TABLENAME);
        int countOfRegions = -1;
        try (RegionLocator r = TEST_UTIL.getConnection().getRegionLocator(TABLENAME);){
            countOfRegions = r.getStartKeys().length;
        }
        TEST_UTIL.waitUntilAllRegionsAssigned(TABLENAME);
        TestMasterTransitions.addToEachStartKey(countOfRegions);
        t.close();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        TEST_UTIL.ensureSomeRegionServersAvailable(2);
    }

    @Ignore
    @Test(timeout=300000L)
    public void testRegionCloseWhenNoMetaHBase2428() throws Exception {
    }

    @Ignore
    @Test(timeout=300000L)
    public void testAddingServerBeforeOldIsDead2413() throws IOException {
    }

    @Ignore
    @Test(timeout=300000L)
    public void testKillRSWithOpeningRegion2482() throws Exception {
    }

    private static int addToEachStartKey(int expected) throws IOException {
        RegionInfo hri;
        Table t = TEST_UTIL.getConnection().getTable(TABLENAME);
        Table meta = TEST_UTIL.getConnection().getTable(TableName.META_TABLE_NAME);
        int rows = 0;
        Scan scan = new Scan();
        scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        ResultScanner s = meta.getScanner(scan);
        Result r = null;
        while ((r = s.next()) != null && (hri = MetaTableAccessor.getRegionInfo((Result)r)) != null) {
            if (!hri.getTable().equals((Object)TABLENAME) || !hri.getTable().equals((Object)TABLENAME)) continue;
            byte[] row = TestMasterTransitions.getStartKey(hri);
            Put p = new Put(row);
            p.setDurability(Durability.SKIP_WAL);
            p.addColumn(TestMasterTransitions.getTestFamily(), TestMasterTransitions.getTestQualifier(), row);
            t.put(p);
            ++rows;
        }
        s.close();
        Assert.assertEquals((long)expected, (long)rows);
        t.close();
        meta.close();
        return rows;
    }

    private static byte[] getStartKey(RegionInfo hri) {
        return Bytes.equals((byte[])HConstants.EMPTY_START_ROW, (byte[])hri.getStartKey()) ? Bytes.toBytes((String)"aaa") : hri.getStartKey();
    }

    private static byte[] getTestFamily() {
        return FAMILIES[0];
    }

    private static byte[] getTestQualifier() {
        return TestMasterTransitions.getTestFamily();
    }
}

