/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestAssignmentOnRSCrash {
    private static final Log LOG = LogFactory.getLog(TestAssignmentOnRSCrash.class);
    private static final TableName TEST_TABLE = TableName.valueOf((String)"testb");
    private static final String FAMILY_STR = "f";
    private static final byte[] FAMILY = Bytes.toBytes((String)"f");
    private static final int NUM_RS = 3;
    private HBaseTestingUtility UTIL;

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
        conf.set("hbase.balancer.tablesOnMaster", "none");
    }

    @Before
    public void setup() throws Exception {
        this.UTIL = new HBaseTestingUtility();
        TestAssignmentOnRSCrash.setupConf(this.UTIL.getConfiguration());
        this.UTIL.startMiniCluster(3);
        this.UTIL.createTable(TEST_TABLE, (byte[][])new byte[][]{FAMILY}, (byte[][])new byte[][]{Bytes.toBytes((String)"B"), Bytes.toBytes((String)"D"), Bytes.toBytes((String)"F"), Bytes.toBytes((String)"L")});
    }

    @After
    public void tearDown() throws Exception {
        this.UTIL.shutdownMiniCluster();
    }

    @Test(timeout=30000L)
    public void testKillRsWithUserRegionWithData() throws Exception {
        this.testCrashRsWithUserRegion(true, true);
    }

    @Test(timeout=30000L)
    public void testKillRsWithUserRegionWithoutData() throws Exception {
        this.testCrashRsWithUserRegion(true, false);
    }

    @Test(timeout=30000L)
    public void testStopRsWithUserRegionWithData() throws Exception {
        this.testCrashRsWithUserRegion(false, true);
    }

    @Test(timeout=30000L)
    public void testStopRsWithUserRegionWithoutData() throws Exception {
        this.testCrashRsWithUserRegion(false, false);
    }

    private void testCrashRsWithUserRegion(boolean kill, boolean withData) throws Exception {
        int NROWS = 100;
        int nkilled = 0;
        for (RegionInfo hri : this.UTIL.getHBaseAdmin().getTableRegions(TEST_TABLE)) {
            ServerName serverName = AssignmentTestingUtil.getServerHoldingRegion(this.UTIL, hri);
            if (AssignmentTestingUtil.isServerHoldingMeta(this.UTIL, serverName)) continue;
            if (withData) {
                this.testInsert(hri, 100);
            }
            AssignmentTestingUtil.crashRs(this.UTIL, serverName, kill);
            AssignmentTestingUtil.waitForRegionToBeInTransition(this.UTIL, hri);
            this.UTIL.waitUntilNoRegionsInTransition();
            if (withData) {
                Assert.assertEquals((long)100L, (long)this.testGet(hri, 100));
            }
            Assert.assertNotEquals((Object)serverName, (Object)AssignmentTestingUtil.getServerHoldingRegion(this.UTIL, hri));
            if (++nkilled != 2) continue;
            break;
        }
        Assert.assertTrue((String)"expected RSs to be killed", (nkilled > 0 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testKillRsWithMetaRegion() throws Exception {
        this.testCrashRsWithMetaRegion(true);
    }

    @Test(timeout=60000L)
    public void testStopRsWithMetaRegion() throws Exception {
        this.testCrashRsWithMetaRegion(false);
    }

    private void testCrashRsWithMetaRegion(boolean kill) throws Exception {
        int nkilled = 0;
        for (RegionInfo hri : AssignmentTestingUtil.getMetaRegions(this.UTIL)) {
            ServerName serverName = AssignmentTestingUtil.crashRsWithRegion(this.UTIL, hri, kill);
            AssignmentTestingUtil.waitForRegionToBeInTransition(this.UTIL, hri);
            this.UTIL.waitUntilNoRegionsInTransition();
            this.testGet(hri, 10);
            Assert.assertNotEquals((Object)serverName, (Object)AssignmentTestingUtil.getServerHoldingRegion(this.UTIL, hri));
            if (++nkilled != 2) continue;
            break;
        }
        Assert.assertTrue((String)"expected RSs to be killed", (nkilled > 0 ? 1 : 0) != 0);
    }

    private void testInsert(RegionInfo hri, int nrows) throws IOException {
        Table table = this.UTIL.getConnection().getTable(hri.getTable());
        for (int i = 0; i < nrows; ++i) {
            byte[] row = Bytes.add((byte[])hri.getStartKey(), (byte[])Bytes.toBytes((int)i));
            Put put = new Put(row);
            put.addColumn(FAMILY, null, row);
            table.put(put);
        }
    }

    public int testGet(RegionInfo hri, int nrows) throws IOException {
        int nresults = 0;
        Table table = this.UTIL.getConnection().getTable(hri.getTable());
        for (int i = 0; i < nrows; ++i) {
            byte[] row = Bytes.add((byte[])hri.getStartKey(), (byte[])Bytes.toBytes((int)i));
            Result result = table.get(new Get(row));
            if (result == null || result.isEmpty() || !Bytes.equals((byte[])row, (byte[])result.getValue(FAMILY, null))) continue;
            ++nresults;
        }
        return nresults;
    }
}

