/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.master.balancer.FavoredStochasticBalancer;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestFavoredNodeTableImport {
    private static final Log LOG = LogFactory.getLog(TestFavoredNodeTableImport.class);
    private static final int SLAVES = 3;
    private static final int REGION_NUM = 20;
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final Configuration conf = UTIL.getConfiguration();

    @After
    public void stopCluster() throws Exception {
        UTIL.cleanupTestDir();
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testTableCreation() throws Exception {
        conf.set("hbase.master.loadbalancer.class", StochasticLoadBalancer.class.getName());
        LOG.info((Object)"Starting up cluster");
        UTIL.startMiniCluster(3);
        while (!UTIL.getMiniHBaseCluster().getMaster().isInitialized()) {
            Threads.sleep((long)1L);
        }
        Admin admin = UTIL.getAdmin();
        admin.setBalancerRunning(false, true);
        String tableName = "testFNImport";
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)tableName));
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        admin.createTable((TableDescriptor)desc, Bytes.toBytes((String)"a"), Bytes.toBytes((String)"z"), 20);
        UTIL.waitTableAvailable(desc.getTableName());
        LOG.info((Object)"Shutting down cluster");
        UTIL.shutdownMiniHBaseCluster();
        Thread.sleep(2000L);
        LOG.info((Object)"Starting cluster again with FN Balancer");
        UTIL.getConfiguration().set("hbase.master.loadbalancer.class", FavoredStochasticBalancer.class.getName());
        UTIL.restartHBaseCluster(3);
        while (!UTIL.getMiniHBaseCluster().getMaster().isInitialized()) {
            Threads.sleep((long)1L);
        }
        admin = UTIL.getAdmin();
        UTIL.waitTableAvailable(desc.getTableName());
        FavoredNodesManager fnm = UTIL.getHBaseCluster().getMaster().getFavoredNodesManager();
        List regionsOfTable = admin.getTableRegions(TableName.valueOf((String)tableName));
        for (HRegionInfo rInfo : regionsOfTable) {
            HashSet favNodes = Sets.newHashSet((Iterable)fnm.getFavoredNodes((RegionInfo)rInfo));
            Assert.assertNotNull((Object)favNodes);
            Assert.assertEquals((String)"Required no of favored nodes not found.", (long)3L, (long)favNodes.size());
            for (ServerName fn : favNodes) {
                Assert.assertEquals((String)("StartCode invalid for:" + fn), (long)-1L, (long)fn.getStartcode());
            }
        }
    }
}

