/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.testclassification.FlakeyTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={FlakeyTests.class, MediumTests.class})
public class TestStochasticLoadBalancer2
extends BalancerTestBase {
    private static final Log LOG = LogFactory.getLog(TestStochasticLoadBalancer2.class);

    @Before
    public void before() {
        conf.setFloat("hbase.master.balancer.stochastic.maxMovePercent", 1.0f);
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 2000000L);
        conf.setFloat("hbase.master.balancer.stochastic.localityCost", 0.0f);
        conf.setLong("hbase.master.balancer.stochastic.maxRunningTime", 90000L);
        conf.setFloat("hbase.master.balancer.stochastic.minCostNeedBalance", 0.05f);
        loadBalancer.setConf(conf);
    }

    @After
    public void after() {
        loadBalancer.setConf(conf);
    }

    @Test(timeout=800000L)
    public void testRegionReplicasOnMidCluster() {
        int numNodes = 200;
        int numRegions = 8000;
        int replication = 3;
        int numRegionsPerServer = 30;
        int numTables = 10;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, true, true);
    }

    @Test(timeout=800000L)
    public void testRegionReplicasOnLargeCluster() {
        int numNodes = 1000;
        int numRegions = 20 * numNodes;
        int numRegionsPerServer = 19;
        int numTables = 100;
        int replication = 3;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, true, true);
    }

    @Ignore
    @Test(timeout=800000L)
    public void testRegionReplicasOnMidClusterHighReplication() {
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 4000000L);
        conf.setLong("hbase.master.balancer.stochastic.maxRunningTime", 120000L);
        loadBalancer.setConf(conf);
        int numNodes = 80;
        int numRegions = 6 * numNodes;
        int replication = 80;
        int numRegionsPerServer = 5;
        int numTables = 10;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, false, true);
    }

    @Test(timeout=800000L)
    public void testRegionReplicationOnMidClusterReplicationGreaterThanNumNodes() {
        conf.setLong("hbase.master.balancer.stochastic.maxRunningTime", 120000L);
        loadBalancer.setConf(conf);
        int numNodes = 40;
        int numRegions = 300;
        int replication = 50;
        int numRegionsPerServer = 6;
        int numTables = 10;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, true, false);
    }
}

