/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TestTableDDLProcedureBase;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;

@Category(value={MasterTests.class, MediumTests.class})
public class TestDeleteTableProcedure
extends TestTableDDLProcedureBase {
    private static final Log LOG = LogFactory.getLog(TestDeleteTableProcedure.class);
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    @Rule
    public TestName name = new TestName();

    @Test(timeout=60000L, expected=TableNotFoundException.class)
    public void testDeleteNotExistentTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedurePrepareLatch.CompatibilityLatch latch = new ProcedurePrepareLatch.CompatibilityLatch();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, (ProcedurePrepareLatch)latch));
        latch.await();
    }

    @Test(timeout=60000L, expected=TableNotDisabledException.class)
    public void testDeleteNotDisabledTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        ProcedurePrepareLatch.CompatibilityLatch latch = new ProcedurePrepareLatch.CompatibilityLatch();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, (ProcedurePrepareLatch)latch));
        latch.await();
    }

    @Test(timeout=60000L)
    public void testDeleteDeletedTable() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        UTIL.getAdmin().disableTable(tableName);
        long procId1 = procExec.submitProcedure((Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        long procId2 = procExec.submitProcedure((Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId1);
        MasterProcedureTestingUtility.validateTableDeletion(this.getMaster(), tableName);
        Procedure result = procExec.getResult(procId2);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug((Object)("Delete failed with exception: " + result.getException()));
        Assert.assertTrue((boolean)(ProcedureTestingUtility.getExceptionCause((Procedure)result) instanceof TableNotFoundException));
    }

    @Test(timeout=60000L)
    public void testSimpleDelete() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] splitKeys = null;
        this.testSimpleDelete(tableName, splitKeys);
    }

    @Test(timeout=60000L)
    public void testSimpleDeleteWithSplits() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        this.testSimpleDelete(tableName, splitKeys);
    }

    private void testSimpleDelete(TableName tableName, byte[][] splitKeys) throws Exception {
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        MasterProcedureTestingUtility.validateTableDeletion(this.getMaster(), tableName);
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] splitKeys = null;
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId);
        MasterProcedureTestingUtility.validateTableDeletion(this.getMaster(), tableName);
    }
}

