/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DisableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.EnableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.TruncateTableProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMasterFailoverWithProcedures {
    private static final Log LOG = LogFactory.getLog(TestMasterFailoverWithProcedures.class);
    @ClassRule
    public static final TestRule timeout = CategoryBasedTimeout.forClass(TestMasterFailoverWithProcedures.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.procedure.store.wal.max.retries.before.roll", 1);
        conf.setInt("hbase.procedure.store.wal.wait.before.roll", 0);
        conf.setInt("hbase.procedure.store.wal.max.roll.retries", 1);
        conf.setInt("hbase.procedure.store.wal.sync.failure.roll.max", 1);
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @Before
    public void setup() throws Exception {
        TestMasterFailoverWithProcedures.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2, 1);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setToggleKillBeforeStoreUpdate(procExec, (boolean)false);
        ProcedureTestingUtility.setKillBeforeStoreUpdate(procExec, (boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    @Test
    public void testCreateWithFailover() throws Exception {
        this.testCreateWithFailoverAtStep(MasterProcedureProtos.CreateTableState.CREATE_TABLE_ASSIGN_REGIONS.ordinal());
    }

    private void testCreateWithFailoverAtStep(int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testCreateWithFailoverAtStep" + step));
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillBeforeStoreUpdate(procExec, (boolean)true);
        ProcedureTestingUtility.setToggleKillBeforeStoreUpdate(procExec, (boolean)true);
        byte[][] splitKeys = null;
        TableDescriptor htd = MasterProcedureTestingUtility.createHTD(tableName, "f1", "f2");
        RegionInfo[] regions = ModifyRegionUtils.createRegionInfos((TableDescriptor)htd, (byte[][])splitKeys);
        long procId = procExec.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), htd, regions));
        TestMasterFailoverWithProcedures.testRecoveryAndDoubleExecution(UTIL, procId, step);
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f1", "f2");
    }

    @Test
    public void testDeleteWithFailover() throws Exception {
        this.testDeleteWithFailoverAtStep(MasterProcedureProtos.DeleteTableState.DELETE_TABLE_UNASSIGN_REGIONS.ordinal());
    }

    private void testDeleteWithFailoverAtStep(int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testDeleteWithFailoverAtStep" + step));
        byte[][] splitKeys = null;
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        Path tableDir = FSUtils.getTableDir((Path)this.getRootDir(), (TableName)tableName);
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f1", "f2");
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillBeforeStoreUpdate(procExec, (boolean)true);
        ProcedureTestingUtility.setToggleKillBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DeleteTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName));
        TestMasterFailoverWithProcedures.testRecoveryAndDoubleExecution(UTIL, procId, step);
        MasterProcedureTestingUtility.validateTableDeletion(UTIL.getHBaseCluster().getMaster(), tableName);
    }

    @Test
    public void testTruncateWithFailover() throws Exception {
        this.testTruncateWithFailoverAtStep(true, MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_ADD_TO_META.ordinal());
    }

    private void testTruncateWithFailoverAtStep(boolean preserveSplits, int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testTruncateWithFailoverAtStep" + step));
        String[] families = new String[]{"f1", "f2"};
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, splitKeys, families);
        Assert.assertEquals((long)100L, (long)UTIL.countRows(tableName));
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, preserveSplits));
        TestMasterFailoverWithProcedures.testRecoveryAndDoubleExecution(UTIL, procId, step);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        UTIL.waitUntilAllRegionsAssigned(tableName);
        regions = UTIL.getAdmin().getTableRegions(tableName).toArray(new RegionInfo[0]);
        if (preserveSplits) {
            Assert.assertEquals((long)(1 + splitKeys.length), (long)regions.length);
        } else {
            Assert.assertEquals((long)1L, (long)regions.length);
        }
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, families);
        Assert.assertEquals((long)0L, (long)UTIL.countRows(tableName));
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 50, splitKeys, families);
        Assert.assertEquals((long)50L, (long)UTIL.countRows(tableName));
    }

    @Test
    public void testDisableTableWithFailover() throws Exception {
        this.testDisableTableWithFailoverAtStep(MasterProcedureProtos.DisableTableState.DISABLE_TABLE_MARK_REGIONS_OFFLINE.ordinal());
    }

    private void testDisableTableWithFailoverAtStep(int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testDisableTableWithFailoverAtStep" + step));
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new DisableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        TestMasterFailoverWithProcedures.testRecoveryAndDoubleExecution(UTIL, procId, step);
        MasterProcedureTestingUtility.validateTableIsDisabled(UTIL.getHBaseCluster().getMaster(), tableName);
    }

    @Test
    public void testEnableTableWithFailover() throws Exception {
        this.testEnableTableWithFailoverAtStep(MasterProcedureProtos.EnableTableState.ENABLE_TABLE_MARK_REGIONS_ONLINE.ordinal());
    }

    private void testEnableTableWithFailoverAtStep(int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testEnableTableWithFailoverAtStep" + step));
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new EnableTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, false));
        TestMasterFailoverWithProcedures.testRecoveryAndDoubleExecution(UTIL, procId, step);
        MasterProcedureTestingUtility.validateTableIsEnabled(UTIL.getHBaseCluster().getMaster(), tableName);
    }

    public static void testRecoveryAndDoubleExecution(HBaseTestingUtility testUtil, long procId, int lastStepBeforeFailover) throws Exception {
        ProcedureExecutor procExec = testUtil.getHBaseCluster().getMaster().getMasterProcedureExecutor();
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        Procedure proc = procExec.getProcedure(procId);
        for (int i = 0; i < lastStepBeforeFailover; ++i) {
            LOG.info((Object)("Restart " + i + " exec state: " + proc));
            ProcedureTestingUtility.assertProcNotYetCompleted((ProcedureExecutor)procExec, (long)procId);
            MasterProcedureTestingUtility.restartMasterProcedureExecutor((ProcedureExecutor<MasterProcedureEnv>)procExec);
            ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        }
        ProcedureTestingUtility.assertProcNotYetCompleted((ProcedureExecutor)procExec, (long)procId);
        LOG.info((Object)"Trigger master failover");
        MasterProcedureTestingUtility.masterFailover(testUtil);
        procExec = testUtil.getHBaseCluster().getMaster().getMasterProcedureExecutor();
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed((ProcedureExecutor)procExec, (long)procId);
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    private Path getRootDir() {
        return UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
    }
}

