/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SpaceLimitSettings;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.HashMultimap;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Iterables;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Multimap;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.junit.Assert;
import org.junit.rules.TestName;

@InterfaceAudience.Private
public class SpaceQuotaHelperForTests {
    private static final Log LOG = LogFactory.getLog(SpaceQuotaHelperForTests.class);
    public static final int SIZE_PER_VALUE = 256;
    public static final String F1 = "f1";
    public static final long ONE_KILOBYTE = 1024L;
    public static final long ONE_MEGABYTE = 0x100000L;
    public static final long ONE_GIGABYTE = 0x40000000L;
    private final HBaseTestingUtility testUtil;
    private final TestName testName;
    private final AtomicLong counter;

    public SpaceQuotaHelperForTests(HBaseTestingUtility testUtil, TestName testName, AtomicLong counter) {
        this.testUtil = Objects.requireNonNull(testUtil);
        this.testName = Objects.requireNonNull(testName);
        this.counter = Objects.requireNonNull(counter);
    }

    static void updateConfigForQuotas(Configuration conf) {
        conf.setInt("hbase.regionserver.quotas.fs.utilization.chore.delay", 1000);
        conf.setInt("hbase.regionserver.quotas.fs.utilization.chore.period", 1000);
        conf.setInt("hbase.master.quotas.observer.chore.delay", 1000);
        conf.setInt("hbase.master.quotas.observer.chore.period", 1000);
        conf.setInt("hbase.regionserver.quotas.policy.refresher.chore.delay", 1000);
        conf.setInt("hbase.regionserver.quotas.policy.refresher.chore.period", 1000);
        conf.setInt("hbase.master.quotas.snapshot.chore.delay", 1000);
        conf.setInt("hbase.master.quotas.snapshot.chore.period", 1000);
        conf.setInt("hbase.hfile.compaction.discharger.interval", 5000);
        conf.setBoolean("hbase.quota.enabled", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long listNumDefinedQuotas(Connection conn) throws IOException {
        try (QuotaRetriever scanner = QuotaRetriever.open((Configuration)conn.getConfiguration());){
            long l = Iterables.size((Iterable)scanner);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllQuotas(Connection conn) throws IOException, InterruptedException {
        if (!conn.getAdmin().tableExists(QuotaUtil.QUOTA_TABLE_NAME)) {
            do {
                LOG.debug((Object)"Quota table does not yet exist");
                Thread.sleep(1000L);
            } while (!conn.getAdmin().tableExists(QuotaUtil.QUOTA_TABLE_NAME));
        } else {
            try (QuotaRetriever scanner = QuotaRetriever.open((Configuration)conn.getConfiguration());){
                for (QuotaSettings quotaSettings : scanner) {
                    String namespace = quotaSettings.getNamespace();
                    TableName tableName = quotaSettings.getTableName();
                    if (namespace != null) {
                        LOG.debug((Object)("Deleting quota for namespace: " + namespace));
                        QuotaUtil.deleteNamespaceQuota((Connection)conn, (String)namespace);
                        continue;
                    }
                    assert (tableName != null);
                    LOG.debug((Object)("Deleting quota for table: " + tableName));
                    QuotaUtil.deleteTableQuota((Connection)conn, (TableName)tableName);
                }
            }
        }
    }

    QuotaSettings getTableSpaceQuota(Connection conn, TableName tn) throws IOException {
        try (QuotaRetriever scanner = QuotaRetriever.open((Configuration)conn.getConfiguration(), (QuotaFilter)new QuotaFilter().setTableFilter(tn.getNameAsString()));){
            for (QuotaSettings setting : scanner) {
                if (!setting.getTableName().equals((Object)tn) || setting.getQuotaType() != QuotaType.SPACE) continue;
                QuotaSettings quotaSettings = setting;
                return quotaSettings;
            }
            Iterator iterator = null;
            return iterator;
        }
    }

    void waitForQuotaTable(Connection conn) throws IOException {
        this.waitForQuotaTable(conn, 30000L);
    }

    void waitForQuotaTable(final Connection conn, long timeout) throws IOException {
        this.testUtil.waitFor(timeout, 1000L, new Waiter.Predicate<IOException>(){

            public boolean evaluate() throws IOException {
                return conn.getAdmin().tableExists(QuotaUtil.QUOTA_TABLE_NAME);
            }
        });
    }

    void writeData(TableName tn, long sizeInBytes) throws IOException {
        this.writeData(this.testUtil.getConnection(), tn, sizeInBytes);
    }

    void writeData(Connection conn, TableName tn, long sizeInBytes) throws IOException {
        this.writeData(tn, sizeInBytes, Bytes.toBytes((String)"q1"));
    }

    void writeData(TableName tn, long sizeInBytes, String qual) throws IOException {
        this.writeData(tn, sizeInBytes, Bytes.toBytes((String)qual));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeData(TableName tn, long sizeInBytes, byte[] qual) throws IOException {
        Connection conn = this.testUtil.getConnection();
        try (Table table = conn.getTable(tn);){
            ArrayList<Put> updates = new ArrayList<Put>();
            long bytesToWrite = sizeInBytes;
            long rowKeyId = 0L;
            StringBuilder sb = new StringBuilder();
            Random r = new Random();
            while (bytesToWrite > 0L) {
                sb.setLength(0);
                sb.append(Long.toString(rowKeyId));
                Put p = new Put(Bytes.toBytes((String)sb.reverse().toString()));
                byte[] value = new byte[256];
                r.nextBytes(value);
                p.addColumn(Bytes.toBytes((String)F1), qual, value);
                updates.add(p);
                if (updates.size() > 50) {
                    table.put(updates);
                    updates.clear();
                }
                bytesToWrite -= 256L;
                ++rowKeyId;
            }
            if (!updates.isEmpty()) {
                table.put(updates);
            }
            LOG.debug((Object)"Data was written to HBase");
            this.testUtil.getAdmin().flush(tn);
            LOG.debug((Object)"Data flushed to disk");
        }
    }

    NamespaceDescriptor createNamespace() throws Exception {
        NamespaceDescriptor nd = NamespaceDescriptor.create((String)("ns" + this.counter.getAndIncrement())).build();
        this.testUtil.getAdmin().createNamespace(nd);
        return nd;
    }

    Multimap<TableName, QuotaSettings> createTablesWithSpaceQuotas() throws Exception {
        Admin admin = this.testUtil.getAdmin();
        HashMultimap tablesWithQuotas = HashMultimap.create();
        TableName tn1 = this.createTable();
        TableName tn2 = this.createTable();
        NamespaceDescriptor nd = this.createNamespace();
        TableName tn3 = this.createTableInNamespace(nd);
        TableName tn4 = this.createTableInNamespace(nd);
        TableName tn5 = this.createTableInNamespace(nd);
        long sizeLimit1 = 0x50000000000L;
        SpaceViolationPolicy violationPolicy1 = SpaceViolationPolicy.NO_WRITES;
        QuotaSettings qs1 = QuotaSettingsFactory.limitTableSpace((TableName)tn1, (long)0x50000000000L, (SpaceViolationPolicy)violationPolicy1);
        tablesWithQuotas.put((Object)tn1, (Object)qs1);
        admin.setQuota(qs1);
        long sizeLimit2 = 0x3200000000L;
        SpaceViolationPolicy violationPolicy2 = SpaceViolationPolicy.NO_WRITES_COMPACTIONS;
        QuotaSettings qs2 = QuotaSettingsFactory.limitTableSpace((TableName)tn2, (long)0x3200000000L, (SpaceViolationPolicy)violationPolicy2);
        tablesWithQuotas.put((Object)tn2, (Object)qs2);
        admin.setQuota(qs2);
        long sizeLimit3 = 0x640000000000L;
        SpaceViolationPolicy violationPolicy3 = SpaceViolationPolicy.NO_INSERTS;
        QuotaSettings qs3 = QuotaSettingsFactory.limitNamespaceSpace((String)nd.getName(), (long)0x640000000000L, (SpaceViolationPolicy)violationPolicy3);
        tablesWithQuotas.put((Object)tn3, (Object)qs3);
        tablesWithQuotas.put((Object)tn4, (Object)qs3);
        tablesWithQuotas.put((Object)tn5, (Object)qs3);
        admin.setQuota(qs3);
        long sizeLimit4 = 0x140000000L;
        SpaceViolationPolicy violationPolicy4 = SpaceViolationPolicy.NO_INSERTS;
        QuotaSettings qs4 = QuotaSettingsFactory.limitTableSpace((TableName)tn5, (long)0x140000000L, (SpaceViolationPolicy)violationPolicy4);
        tablesWithQuotas.put((Object)tn5, (Object)qs4);
        admin.setQuota(qs4);
        return tablesWithQuotas;
    }

    TableName getNextTableName() {
        return this.getNextTableName(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR);
    }

    TableName getNextTableName(String namespace) {
        return TableName.valueOf((String)namespace, (String)(this.testName.getMethodName() + this.counter.getAndIncrement()));
    }

    TableName createTable() throws Exception {
        return this.createTableWithRegions(1);
    }

    TableName createTableWithRegions(int numRegions) throws Exception {
        return this.createTableWithRegions(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR, numRegions);
    }

    TableName createTableWithRegions(Admin admin, int numRegions) throws Exception {
        return this.createTableWithRegions(this.testUtil.getAdmin(), NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR, numRegions);
    }

    TableName createTableWithRegions(String namespace, int numRegions) throws Exception {
        return this.createTableWithRegions(this.testUtil.getAdmin(), namespace, numRegions);
    }

    TableName createTableWithRegions(Admin admin, String namespace, int numRegions) throws Exception {
        TableName tn = this.getNextTableName(namespace);
        if (admin.tableExists(tn)) {
            admin.disableTable(tn);
            admin.deleteTable(tn);
        }
        HTableDescriptor tableDesc = new HTableDescriptor(tn);
        tableDesc.addFamily(new HColumnDescriptor(F1));
        if (numRegions == 1) {
            admin.createTable((TableDescriptor)tableDesc);
        } else {
            admin.createTable((TableDescriptor)tableDesc, Bytes.toBytes((String)"0"), Bytes.toBytes((String)"9"), numRegions);
        }
        return tn;
    }

    TableName createTableInNamespace(NamespaceDescriptor nd) throws Exception {
        TableName tn;
        Admin admin = this.testUtil.getAdmin();
        if (admin.tableExists(tn = TableName.valueOf((String)nd.getName(), (String)(this.testName.getMethodName() + this.counter.getAndIncrement())))) {
            admin.disableTable(tn);
            admin.deleteTable(tn);
        }
        HTableDescriptor tableDesc = new HTableDescriptor(tn);
        tableDesc.addFamily(new HColumnDescriptor(F1));
        admin.createTable((TableDescriptor)tableDesc);
        return tn;
    }

    void partitionTablesByQuotaTarget(Multimap<TableName, QuotaSettings> quotas, Set<TableName> tablesWithTableQuota, Set<TableName> tablesWithNamespaceQuota) {
        for (Map.Entry entry : quotas.entries()) {
            SpaceLimitSettings settings = (SpaceLimitSettings)entry.getValue();
            TableName tn = (TableName)entry.getKey();
            if (settings.getTableName() != null) {
                tablesWithTableQuota.add(tn);
            }
            if (settings.getNamespace() != null) {
                tablesWithNamespaceQuota.add(tn);
            }
            if (settings.getTableName() != null || settings.getNamespace() != null) continue;
            Assert.fail((String)("Unexpected table name with null tableName and namespace: " + tn));
        }
    }

    static class NoFilesToDischarge
    implements Waiter.Predicate<Exception> {
        private final MiniHBaseCluster cluster;
        private final TableName tn;

        NoFilesToDischarge(MiniHBaseCluster cluster, TableName tn) {
            this.cluster = cluster;
            this.tn = tn;
        }

        public boolean evaluate() throws Exception {
            for (HRegion region : this.cluster.getRegions(this.tn)) {
                for (HStore store : region.getStores()) {
                    Collection files = store.getStoreEngine().getStoreFileManager().getCompactedfiles();
                    if (null == files || files.isEmpty()) continue;
                    LOG.debug((Object)(region.getRegionInfo().getEncodedName() + " still has compacted files"));
                    return false;
                }
            }
            return true;
        }
    }

    static abstract class SpaceQuotaSnapshotPredicate
    implements Waiter.Predicate<Exception> {
        private final Connection conn;
        private final TableName tn;
        private final String ns;

        SpaceQuotaSnapshotPredicate(Connection conn, TableName tn) {
            this(Objects.requireNonNull(conn), Objects.requireNonNull(tn), null);
        }

        SpaceQuotaSnapshotPredicate(Connection conn, String ns) {
            this(Objects.requireNonNull(conn), null, Objects.requireNonNull(ns));
        }

        SpaceQuotaSnapshotPredicate(Connection conn, TableName tn, String ns) {
            if (null != tn && null != ns || null == tn && null == ns) {
                throw new IllegalArgumentException("One of TableName and Namespace must be non-null, and the other null");
            }
            this.conn = conn;
            this.tn = tn;
            this.ns = ns;
        }

        public boolean evaluate() throws Exception {
            SpaceQuotaSnapshot snapshot = null == this.ns ? QuotaTableUtil.getCurrentSnapshot((Connection)this.conn, (TableName)this.tn) : QuotaTableUtil.getCurrentSnapshot((Connection)this.conn, (String)this.ns);
            LOG.debug((Object)("Saw quota snapshot for " + (null == this.tn ? this.ns : this.tn) + ": " + snapshot));
            if (null == snapshot) {
                return false;
            }
            return this.evaluate(snapshot);
        }

        abstract boolean evaluate(SpaceQuotaSnapshot var1) throws Exception;
    }
}

