/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaSnapshotStore;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestQuotaObserverChoreRegionReports {
    private static final Log LOG = LogFactory.getLog(TestQuotaObserverChoreRegionReports.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        conf.setInt("hbase.master.quotas.region.report.retention.millis", 1000);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testReportExpiration() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.quotas.fs.utilization.chore.period", 25000);
        conf.setInt("hbase.master.quotas.region.report.retention.millis", 5000);
        TEST_UTIL.startMiniCluster(1);
        String FAM1 = "f1";
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        while (master.getMasterQuotaManager() == null) {
            LOG.debug((Object)"MasterQuotaManager is null, waiting...");
            Thread.sleep(500L);
        }
        final MasterQuotaManager quotaManager = master.getMasterQuotaManager();
        final TableName tn = TableName.valueOf((String)"reportExpiration");
        HTableDescriptor tableDesc = new HTableDescriptor(tn);
        tableDesc.addFamily(new HColumnDescriptor("f1"));
        TEST_UTIL.getAdmin().createTable((TableDescriptor)tableDesc);
        Assert.assertEquals((long)0L, (long)this.getRegionReportsForTable(quotaManager.snapshotRegionSizes(), tn));
        long sizeLimit = 0x6400000L;
        SpaceViolationPolicy violationPolicy = SpaceViolationPolicy.NO_INSERTS;
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x6400000L, (SpaceViolationPolicy)violationPolicy);
        TEST_UTIL.getAdmin().setQuota(settings);
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)45000L, (long)1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                int numReports = TestQuotaObserverChoreRegionReports.this.getRegionReportsForTable(quotaManager.snapshotRegionSizes(), tn);
                LOG.debug((Object)("Saw " + numReports + " reports for " + tn + " while waiting for 1"));
                return numReports == 1;
            }
        });
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)15000L, (long)1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                int numReports = TestQuotaObserverChoreRegionReports.this.getRegionReportsForTable(quotaManager.snapshotRegionSizes(), tn);
                LOG.debug((Object)("Saw " + numReports + " reports for " + tn + " while waiting for none"));
                return numReports == 0;
            }
        });
    }

    @Test
    public void testMissingReportsRemovesQuota() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.master.quotas.region.report.retention.millis", 5000);
        TEST_UTIL.startMiniCluster(1);
        String FAM1 = "f1";
        final TableName tn = TableName.valueOf((String)"quotaAcceptanceWithoutReports");
        HTableDescriptor tableDesc = new HTableDescriptor(tn);
        tableDesc.addFamily(new HColumnDescriptor("f1"));
        TEST_UTIL.getAdmin().createTable((TableDescriptor)tableDesc);
        long sizeLimit = 1024L;
        SpaceViolationPolicy violationPolicy = SpaceViolationPolicy.NO_INSERTS;
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)1024L, (SpaceViolationPolicy)violationPolicy);
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(settings);
        final Connection conn = TEST_UTIL.getConnection();
        Put p = new Put(Bytes.toBytes((String)"row1"));
        byte[] bytes = new byte[10];
        Arrays.fill(bytes, (byte)2);
        for (int i = 0; i < 200; ++i) {
            p.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)("qual" + i)), bytes);
        }
        conn.getTable(tn).put(p);
        admin.flush(tn);
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)30000L, (long)1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                SpaceQuotaSnapshot snapshot = TestQuotaObserverChoreRegionReports.this.getSnapshotForTable(conn, tn);
                if (snapshot == null) {
                    return false;
                }
                return snapshot.getQuotaStatus().isInViolation();
            }
        });
        List regions = admin.getRegions(tn);
        Assert.assertEquals((long)1L, (long)regions.size());
        RegionInfo hri = (RegionInfo)regions.get(0);
        admin.unassign(hri.getRegionName(), true);
        Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)30000L, (long)1000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                SpaceQuotaSnapshot snapshot = TestQuotaObserverChoreRegionReports.this.getSnapshotForTable(conn, tn);
                if (snapshot == null) {
                    return false;
                }
                return !snapshot.getQuotaStatus().isInViolation();
            }
        });
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        QuotaSnapshotStore tableStore = master.getQuotaObserverChore().getTableSnapshotStore();
        SpaceQuotaSnapshot snapshot = tableStore.getCurrentState((Object)tn);
        Assert.assertFalse((String)"Quota should not be in violation", (boolean)snapshot.getQuotaStatus().isInViolation());
    }

    /*
     * Exception decompiling
     */
    private SpaceQuotaSnapshot getSnapshotForTable(Connection conn, TableName tn) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getRegionReportsForTable(Map<RegionInfo, Long> reports, TableName tn) {
        int numReports = 0;
        for (Map.Entry<RegionInfo, Long> entry : reports.entrySet()) {
            if (!tn.equals((Object)entry.getKey().getTable())) continue;
            ++numReports;
        }
        return numReports;
    }
}

