/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestClusterId {
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private JVMClusterUtil.RegionServerThread rst;

    @Before
    public void setUp() throws Exception {
        this.TEST_UTIL.getConfiguration().setBoolean("hbase.shutdown.hook", false);
    }

    @After
    public void tearDown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
        if (this.rst != null && this.rst.getRegionServer() != null) {
            this.rst.getRegionServer().stop("end of test");
            this.rst.join();
        }
    }

    @Test
    public void testClusterId() throws Exception {
        this.TEST_UTIL.startMiniZKCluster();
        this.TEST_UTIL.startMiniDFSCluster(1);
        Configuration conf = new Configuration(this.TEST_UTIL.getConfiguration());
        this.rst = JVMClusterUtil.createRegionServerThread((Configuration)conf, HRegionServer.class, (int)0);
        this.rst.start();
        Thread.sleep(10000L);
        this.TEST_UTIL.startMiniHBaseCluster(1, 0);
        this.rst.waitForServerOnline();
        String clusterId = ZKClusterId.readClusterIdZNode((ZooKeeperWatcher)this.TEST_UTIL.getZooKeeperWatcher());
        Assert.assertNotNull((Object)clusterId);
        Assert.assertEquals((Object)clusterId, (Object)this.rst.getRegionServer().getClusterId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRewritingClusterIdToPB() throws Exception {
        this.TEST_UTIL.startMiniZKCluster();
        this.TEST_UTIL.startMiniDFSCluster(1);
        this.TEST_UTIL.createRootDir();
        Path rootDir = FSUtils.getRootDir((Configuration)this.TEST_UTIL.getConfiguration());
        FileSystem fs = rootDir.getFileSystem(this.TEST_UTIL.getConfiguration());
        Path filePath = new Path(rootDir, "hbase.id");
        try (FSDataOutputStream s = null;){
            s = fs.create(filePath);
            s.writeUTF(UUID.randomUUID().toString());
        }
        this.TEST_UTIL.startMiniHBaseCluster(1, 1);
        HMaster master = this.TEST_UTIL.getHBaseCluster().getMaster();
        int expected = LoadBalancer.isTablesOnMaster((Configuration)this.TEST_UTIL.getConfiguration()) ? 2 : 1;
        Assert.assertEquals((long)expected, (long)master.getServerManager().getOnlineServersList().size());
    }
}

