/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.MemStoreLABImpl;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMemstoreLABWithoutPool {
    private static final Configuration conf = new Configuration();
    private static final byte[] rk = Bytes.toBytes((String)"r1");
    private static final byte[] cf = Bytes.toBytes((String)"f");
    private static final byte[] q = Bytes.toBytes((String)"q");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        long globalMemStoreLimit = (long)((double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * 0.8);
        ChunkCreator.initialize((int)0x200008, (boolean)false, (long)globalMemStoreLimit, (float)0.0f, (float)0.0f, null);
    }

    @Test
    public void testLABRandomAllocation() {
        Random rand = new Random();
        MemStoreLABImpl mslab = new MemStoreLABImpl();
        int expectedOff = 0;
        ByteBuffer lastBuffer = null;
        int lastChunkId = -1;
        for (int i = 0; i < 100000; ++i) {
            int valSize = rand.nextInt(1000);
            KeyValue kv = new KeyValue(rk, cf, q, new byte[valSize]);
            int size = KeyValueUtil.length((Cell)kv);
            ByteBufferKeyValue newKv = (ByteBufferKeyValue)mslab.copyCellInto((Cell)kv);
            if (newKv.getBuffer() != lastBuffer) {
                expectedOff = 4;
                lastBuffer = newKv.getBuffer();
                int chunkId = newKv.getBuffer().getInt(0);
                Assert.assertTrue((String)"chunkid should be different", (chunkId != lastChunkId ? 1 : 0) != 0);
                lastChunkId = chunkId;
            }
            Assert.assertEquals((long)expectedOff, (long)newKv.getOffset());
            Assert.assertTrue((String)"Allocation overruns buffer", (newKv.getOffset() + size <= newKv.getBuffer().capacity() ? 1 : 0) != 0);
            expectedOff += size;
        }
    }

    @Test
    public void testLABChunkQueueWithMultipleMSLABs() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        MemStoreLABImpl[] mslab = new MemStoreLABImpl[10];
        for (int i = 0; i < 10; ++i) {
            mslab[i] = new MemStoreLABImpl(conf);
        }
        ArrayList<Thread> threads = new ArrayList<Thread>();
        KeyValue kv = new KeyValue(Bytes.toBytes((String)"r"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"q"), new byte[0]);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                threads.add(this.getChunkQueueTestThread(mslab[i], "testLABChunkQueue-" + j, (Cell)kv));
            }
        }
        for (Thread thread : threads) {
            thread.start();
        }
        Thread.sleep(3000L);
        for (Thread thread : threads) {
            thread.interrupt();
        }
        boolean threadsRunning = true;
        boolean alive = false;
        while (threadsRunning) {
            alive = false;
            for (Thread thread : threads) {
                if (!thread.isAlive()) continue;
                alive = true;
                break;
            }
            if (alive) continue;
            threadsRunning = false;
        }
        for (int i = 0; i < 10; ++i) {
            mslab[i].close();
        }
        Assert.assertTrue((String)"All the chunks must have been cleared", (ChunkCreator.INSTANCE.numberOfMappedChunks() == 0 ? 1 : 0) != 0);
    }

    private Thread getChunkQueueTestThread(final MemStoreLABImpl mslab, String threadName, final Cell cellToCopyInto) {
        Thread thread = new Thread(){
            volatile boolean stopped = false;

            @Override
            public void run() {
                while (!this.stopped) {
                    mslab.copyCellInto(cellToCopyInto);
                }
            }

            @Override
            public void interrupt() {
                this.stopped = true;
            }
        };
        thread.setName(threadName);
        thread.setDaemon(true);
        return thread;
    }
}

