/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestMutateRowsRecovery {
    private MiniHBaseCluster cluster = null;
    private Connection connection = null;
    private static final int NB_SERVERS = 3;
    static final byte[] qual1 = Bytes.toBytes((String)"qual1");
    static final byte[] qual2 = Bytes.toBytes((String)"qual2");
    static final byte[] value1 = Bytes.toBytes((String)"value1");
    static final byte[] value2 = Bytes.toBytes((String)"value2");
    static final byte[] row1 = Bytes.toBytes((String)"rowA");
    static final byte[] row2 = Bytes.toBytes((String)"rowB");
    static final HBaseTestingUtility TESTING_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void before() throws Exception {
        TESTING_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void after() throws Exception {
        TESTING_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        TESTING_UTIL.ensureSomeNonStoppedRegionServersAvailable(3);
        this.connection = ConnectionFactory.createConnection((Configuration)TESTING_UTIL.getConfiguration());
        this.cluster = TESTING_UTIL.getMiniHBaseCluster();
    }

    @After
    public void tearDown() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MutateRowsAndCheckPostKill() throws IOException, InterruptedException {
        TableName tableName = TableName.valueOf((String)"test");
        Admin admin = null;
        Table hTable = null;
        try {
            admin = this.connection.getAdmin();
            hTable = this.connection.getTable(tableName);
            HTableDescriptor desc = new HTableDescriptor(tableName);
            desc.addFamily(new HColumnDescriptor(HBaseTestingUtility.fam1));
            admin.createTable((TableDescriptor)desc);
            RowMutations rm = new RowMutations(row1);
            Put p1 = new Put(row1);
            p1.addColumn(HBaseTestingUtility.fam1, qual1, value1);
            p1.setDurability(Durability.SYNC_WAL);
            rm.add(p1);
            hTable.mutateRow(rm);
            Put p2 = new Put(row1);
            p2.addColumn(HBaseTestingUtility.fam1, qual2, value2);
            p2.setDurability(Durability.SYNC_WAL);
            hTable.put(p2);
            HRegionServer rs1 = TESTING_UTIL.getRSForFirstRegionInTable(tableName);
            long now = EnvironmentEdgeManager.currentTime();
            rs1.tryRegionServerReport(now - 30000L, now);
            this.cluster.killRegionServer(rs1.serverName);
            Get g1 = new Get(row1);
            Result result = hTable.get(g1);
            Assert.assertTrue((result.getValue(HBaseTestingUtility.fam1, qual1) != null ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])result.getValue(HBaseTestingUtility.fam1, qual1), (byte[])value1));
            Assert.assertTrue((result.getValue(HBaseTestingUtility.fam1, qual2) != null ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])result.getValue(HBaseTestingUtility.fam1, qual2), (byte[])value2));
        }
        finally {
            if (admin != null) {
                admin.close();
            }
            if (hTable != null) {
                hTable.close();
            }
        }
    }
}

