/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.regionserver.AnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestPriorityRpc {
    private HRegionServer regionServer = null;
    private PriorityFunction priority = null;

    @Before
    public void setup() {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.testing.nocluster", true);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.getDataTestDir(this.getClass().getName());
        this.regionServer = HRegionServer.constructRegionServer(HRegionServer.class, (Configuration)conf);
        this.priority = this.regionServer.rpcServices.getPriority();
    }

    @Test
    public void testQosFunctionForMeta() throws IOException {
        this.priority = this.regionServer.rpcServices.getPriority();
        RPCProtos.RequestHeader.Builder headerBuilder = RPCProtos.RequestHeader.newBuilder();
        headerBuilder.setMethodName("foo");
        ClientProtos.GetRequest.Builder getRequestBuilder = ClientProtos.GetRequest.newBuilder();
        HBaseProtos.RegionSpecifier.Builder regionSpecifierBuilder = HBaseProtos.RegionSpecifier.newBuilder();
        regionSpecifierBuilder.setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME);
        ByteString name = UnsafeByteOperations.unsafeWrap((byte[])RegionInfoBuilder.FIRST_META_REGIONINFO.getRegionName());
        regionSpecifierBuilder.setValue(name);
        HBaseProtos.RegionSpecifier regionSpecifier = regionSpecifierBuilder.build();
        getRequestBuilder.setRegion(regionSpecifier);
        ClientProtos.Get.Builder getBuilder = ClientProtos.Get.newBuilder();
        getBuilder.setRow(UnsafeByteOperations.unsafeWrap((byte[])"somerow".getBytes()));
        getRequestBuilder.setGet(getBuilder.build());
        ClientProtos.GetRequest getRequest = getRequestBuilder.build();
        RPCProtos.RequestHeader header = headerBuilder.build();
        HRegion mockRegion = (HRegion)Mockito.mock(HRegion.class);
        HRegionServer mockRS = (HRegionServer)Mockito.mock(HRegionServer.class);
        RSRpcServices mockRpc = (RSRpcServices)Mockito.mock(RSRpcServices.class);
        Mockito.when((Object)mockRS.getRSRpcServices()).thenReturn((Object)mockRpc);
        RegionInfo mockRegionInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)mockRpc.getRegion((HBaseProtos.RegionSpecifier)Mockito.any())).thenReturn((Object)mockRegion);
        Mockito.when((Object)mockRegion.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRegionInfo.getTable()).thenReturn((Object)RegionInfoBuilder.FIRST_META_REGIONINFO.getTable());
        ((AnnotationReadingPriorityFunction)this.priority).setRegionServer(mockRS);
        Assert.assertEquals((long)200L, (long)this.priority.getPriority(header, (Message)getRequest, User.createUserForTesting((Configuration)this.regionServer.conf, (String)"someuser", (String[])new String[]{"somegroup"})));
    }

    @Test
    public void testQosFunctionWithoutKnownArgument() throws IOException {
        RPCProtos.RequestHeader.Builder headerBuilder = RPCProtos.RequestHeader.newBuilder();
        headerBuilder.setMethodName("foo");
        RPCProtos.RequestHeader header = headerBuilder.build();
        PriorityFunction qosFunc = this.regionServer.rpcServices.getPriority();
        Assert.assertEquals((long)0L, (long)qosFunc.getPriority(header, null, User.createUserForTesting((Configuration)this.regionServer.conf, (String)"someuser", (String[])new String[]{"somegroup"})));
    }

    @Test
    public void testQosFunctionForScanMethod() throws IOException {
        RPCProtos.RequestHeader.Builder headerBuilder = RPCProtos.RequestHeader.newBuilder();
        headerBuilder.setMethodName("Scan");
        RPCProtos.RequestHeader header = headerBuilder.build();
        ClientProtos.ScanRequest.Builder scanBuilder = ClientProtos.ScanRequest.newBuilder();
        ClientProtos.ScanRequest scanRequest = scanBuilder.build();
        HRegion mockRegion = (HRegion)Mockito.mock(HRegion.class);
        HRegionServer mockRS = (HRegionServer)Mockito.mock(HRegionServer.class);
        RSRpcServices mockRpc = (RSRpcServices)Mockito.mock(RSRpcServices.class);
        Mockito.when((Object)mockRS.getRSRpcServices()).thenReturn((Object)mockRpc);
        RegionInfo mockRegionInfo = (RegionInfo)Mockito.mock(RegionInfo.class);
        Mockito.when((Object)mockRpc.getRegion((HBaseProtos.RegionSpecifier)Mockito.any())).thenReturn((Object)mockRegion);
        Mockito.when((Object)mockRegion.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRegionInfo.getTable()).thenReturn((Object)TableName.valueOf((String)"testQosFunctionForScanMethod"));
        ((AnnotationReadingPriorityFunction)this.priority).setRegionServer(mockRS);
        int qos = this.priority.getPriority(header, (Message)scanRequest, User.createUserForTesting((Configuration)this.regionServer.conf, (String)"someuser", (String[])new String[]{"somegroup"}));
        Assert.assertTrue((String)("" + qos), (qos == 0 ? 1 : 0) != 0);
        scanBuilder = ClientProtos.ScanRequest.newBuilder();
        scanBuilder.setScannerId(12345L);
        scanRequest = scanBuilder.build();
        RegionScanner mockRegionScanner = (RegionScanner)Mockito.mock(RegionScanner.class);
        Mockito.when((Object)mockRpc.getScanner(12345L)).thenReturn((Object)mockRegionScanner);
        Mockito.when((Object)mockRegionScanner.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRpc.getRegion((HBaseProtos.RegionSpecifier)Mockito.any())).thenReturn((Object)mockRegion);
        Mockito.when((Object)mockRegion.getRegionInfo()).thenReturn((Object)mockRegionInfo);
        Mockito.when((Object)mockRegionInfo.getTable()).thenReturn((Object)RegionInfoBuilder.FIRST_META_REGIONINFO.getTable());
        ((AnnotationReadingPriorityFunction)this.priority).setRegionServer(mockRS);
        Assert.assertEquals((long)200L, (long)this.priority.getPriority(header, (Message)scanRequest, User.createUserForTesting((Configuration)this.regionServer.conf, (String)"someuser", (String[])new String[]{"somegroup"})));
        Mockito.when((Object)mockRegionInfo.getTable()).thenReturn((Object)TableName.valueOf((String)"testQosFunctionForScanMethod"));
        Assert.assertEquals((long)0L, (long)this.priority.getPriority(header, (Message)scanRequest, User.createUserForTesting((Configuration)this.regionServer.conf, (String)"someuser", (String[])new String[]{"somegroup"})));
    }
}

