/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionReplicasAreDistributed {
    private static final Log LOG = LogFactory.getLog(TestRegionReplicasAreDistributed.class);
    private static final int NB_SERVERS = 3;
    private static Table table;
    private static final HBaseTestingUtility HTU;
    private static final byte[] f;
    Map<ServerName, Collection<RegionInfo>> serverVsOnlineRegions;
    Map<ServerName, Collection<RegionInfo>> serverVsOnlineRegions2;
    Map<ServerName, Collection<RegionInfo>> serverVsOnlineRegions3;
    Map<ServerName, Collection<RegionInfo>> serverVsOnlineRegions4;

    @BeforeClass
    public static void before() throws Exception {
        HTU.getConfiguration().setInt(">hbase.master.wait.on.regionservers.mintostart", 3);
        HTU.startMiniCluster(3);
        Thread.sleep(3000L);
        TableName tableName = TableName.valueOf((String)TestRegionReplicasAreDistributed.class.getSimpleName());
        TestRegionReplicasAreDistributed.createTableDirectlyFromHTD(tableName);
    }

    private static void createTableDirectlyFromHTD(TableName tableName) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.setRegionReplication(3);
        table = HTU.createTable((TableDescriptor)htd, (byte[][])new byte[][]{f}, TestRegionReplicasAreDistributed.getSplits(20), new Configuration(HTU.getConfiguration()));
    }

    private static byte[][] getSplits(int numRegions) {
        RegionSplitter.UniformSplit split = new RegionSplitter.UniformSplit();
        split.setFirstRow(Bytes.toBytes((long)0L));
        split.setLastRow(Bytes.toBytes((long)Long.MAX_VALUE));
        return split.split(numRegions);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HRegionServer.TEST_SKIP_REPORTING_TRANSITION = false;
        table.close();
        HTU.shutdownMiniCluster();
    }

    private HRegionServer getRS() {
        return HTU.getMiniHBaseCluster().getRegionServer(0);
    }

    private HRegionServer getSecondaryRS() {
        return HTU.getMiniHBaseCluster().getRegionServer(1);
    }

    private HRegionServer getTertiaryRS() {
        return HTU.getMiniHBaseCluster().getRegionServer(2);
    }

    @Test(timeout=60000L)
    public void testRegionReplicasCreatedAreDistributed() throws Exception {
        try {
            this.checkAndAssertRegionDistribution(false);
            HTU.getAdmin().disableTable(table.getName());
            LOG.info((Object)("Disabled the table " + table.getName()));
            LOG.info((Object)("enabling the table " + table.getName()));
            HTU.getAdmin().enableTable(table.getName());
            LOG.info((Object)("Enabled the table " + table.getName()));
            boolean res = this.checkAndAssertRegionDistribution(true);
            Assert.assertTrue((String)"Region retainment not done ", (boolean)res);
        }
        finally {
            HTU.getAdmin().disableTable(table.getName());
            HTU.getAdmin().deleteTable(table.getName());
        }
    }

    private boolean checkAndAssertRegionDistribution(boolean checkfourth) throws Exception {
        ArrayList<RegionInfo> onlineRegions = new ArrayList<RegionInfo>(this.getRS().getOnlineRegionsLocalContext().size());
        for (Object region : this.getRS().getOnlineRegionsLocalContext()) {
            onlineRegions.add(region.getRegionInfo());
        }
        if (this.serverVsOnlineRegions == null) {
            this.serverVsOnlineRegions = new HashMap<ServerName, Collection<RegionInfo>>();
            this.serverVsOnlineRegions.put(this.getRS().getServerName(), onlineRegions);
        } else {
            ArrayList<RegionInfo> existingRegions = new ArrayList<RegionInfo>(this.serverVsOnlineRegions.get(this.getRS().getServerName()));
            LOG.info((Object)("Count is " + existingRegions.size() + " " + onlineRegions.size()));
            for (RegionInfo existingRegion : existingRegions) {
                if (onlineRegions.contains(existingRegion)) continue;
                return false;
            }
        }
        ArrayList<RegionInfo> onlineRegions2 = new ArrayList<RegionInfo>(this.getSecondaryRS().getOnlineRegionsLocalContext().size());
        for (Object region : this.getSecondaryRS().getOnlineRegionsLocalContext()) {
            onlineRegions2.add(region.getRegionInfo());
        }
        if (this.serverVsOnlineRegions2 == null) {
            this.serverVsOnlineRegions2 = new HashMap<ServerName, Collection<RegionInfo>>();
            this.serverVsOnlineRegions2.put(this.getSecondaryRS().getServerName(), onlineRegions2);
        } else {
            ArrayList<RegionInfo> existingRegions = new ArrayList<RegionInfo>(this.serverVsOnlineRegions2.get(this.getSecondaryRS().getServerName()));
            LOG.info((Object)("Count is " + existingRegions.size() + " " + onlineRegions2.size()));
            for (RegionInfo existingRegion : existingRegions) {
                if (onlineRegions2.contains(existingRegion)) continue;
                return false;
            }
        }
        ArrayList<RegionInfo> onlineRegions3 = new ArrayList<RegionInfo>(this.getTertiaryRS().getOnlineRegionsLocalContext().size());
        for (HRegion region : this.getTertiaryRS().getOnlineRegionsLocalContext()) {
            onlineRegions3.add(region.getRegionInfo());
        }
        if (this.serverVsOnlineRegions3 == null) {
            this.serverVsOnlineRegions3 = new HashMap<ServerName, Collection<RegionInfo>>();
            this.serverVsOnlineRegions3.put(this.getTertiaryRS().getServerName(), onlineRegions3);
        } else {
            ArrayList<RegionInfo> existingRegions = new ArrayList<RegionInfo>(this.serverVsOnlineRegions3.get(this.getTertiaryRS().getServerName()));
            LOG.info((Object)("Count is " + existingRegions.size() + " " + onlineRegions3.size()));
            for (RegionInfo existingRegion : existingRegions) {
                if (onlineRegions3.contains(existingRegion)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        HTU = new HBaseTestingUtility();
        f = HConstants.CATALOG_FAMILY;
    }
}

