/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestRegionServerHostname {
    private static final Log LOG = LogFactory.getLog(TestRegionServerHostname.class);
    private HBaseTestingUtility TEST_UTIL;
    private static final int NUM_MASTERS = 1;
    private static final int NUM_RS = 1;

    @Before
    public void setup() {
        Configuration conf = HBaseConfiguration.create();
        this.TEST_UTIL = new HBaseTestingUtility(conf);
    }

    @After
    public void teardown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=30000L)
    public void testInvalidRegionServerHostnameAbortsServer() throws Exception {
        String invalidHostname = "hostAddr.invalid";
        this.TEST_UTIL.getConfiguration().set("hbase.regionserver.hostname", invalidHostname);
        HRegionServer hrs = null;
        try {
            hrs = new HRegionServer(this.TEST_UTIL.getConfiguration());
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((String)iae.getMessage(), (iae.getMessage().contains("Failed resolve of " + invalidHostname) || iae.getMessage().contains("Problem binding to " + invalidHostname) ? 1 : 0) != 0);
        }
        Assert.assertNull((String)"Failed to validate against invalid hostname", (Object)hrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testRegionServerHostname() throws Exception {
        Enumeration<NetworkInterface> netInterfaceList = NetworkInterface.getNetworkInterfaces();
        while (netInterfaceList.hasMoreElements()) {
            NetworkInterface ni = netInterfaceList.nextElement();
            Enumeration<InetAddress> addrList = ni.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                if (addr.isLoopbackAddress() || addr.isLinkLocalAddress() || addr.isMulticastAddress()) continue;
                String hostName = addr.getHostName();
                LOG.info((Object)("Found " + hostName + " on " + ni));
                this.TEST_UTIL.getConfiguration().set("hbase.master.hostname", hostName);
                this.TEST_UTIL.getConfiguration().set("hbase.regionserver.hostname", hostName);
                this.TEST_UTIL.startMiniCluster(1, 1);
                try {
                    ZooKeeperWatcher zkw = this.TEST_UTIL.getZooKeeperWatcher();
                    List servers = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)zkw.znodePaths.rsZNode);
                    Assert.assertTrue((servers.size() == 1 + (LoadBalancer.isTablesOnMaster((Configuration)this.TEST_UTIL.getConfiguration()) ? 1 : 0) ? 1 : 0) != 0);
                    for (String server : servers) {
                        Assert.assertTrue((String)("From zookeeper: " + server + " hostname: " + hostName), (boolean)server.startsWith(hostName.toLowerCase(Locale.ROOT) + ","));
                    }
                    zkw.close();
                }
                finally {
                    this.TEST_UTIL.shutdownMiniCluster();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testConflictRegionServerHostnameConfigurationsAbortServer() throws Exception {
        Enumeration<NetworkInterface> netInterfaceList = NetworkInterface.getNetworkInterfaces();
        while (netInterfaceList.hasMoreElements()) {
            NetworkInterface ni = netInterfaceList.nextElement();
            Enumeration<InetAddress> addrList = ni.getInetAddresses();
            while (addrList.hasMoreElements()) {
                InetAddress addr = addrList.nextElement();
                if (addr.isLoopbackAddress() || addr.isLinkLocalAddress() || addr.isMulticastAddress()) continue;
                String hostName = addr.getHostName();
                LOG.info((Object)("Found " + hostName + " on " + ni));
                this.TEST_UTIL.getConfiguration().set("hbase.master.hostname", hostName);
                this.TEST_UTIL.getConfiguration().set("hbase.regionserver.hostname", hostName);
                this.TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.hostname.disable.master.reversedns", true);
                try {
                    this.TEST_UTIL.startMiniCluster(1, 1);
                }
                catch (Exception e) {
                    Throwable t1 = e.getCause();
                    Throwable t2 = t1.getCause();
                    Assert.assertTrue((String)(t1.getMessage() + " - " + t2.getMessage()), (boolean)t2.getMessage().contains("hbase.regionserver.hostname.disable.master.reversedns and hbase.regionserver.hostname are mutually exclusive"));
                    return;
                }
                finally {
                    this.TEST_UTIL.shutdownMiniCluster();
                }
                Assert.assertTrue((String)"Failed to validate against conflict hostname configurations", (boolean)false);
            }
        }
    }

    @Test(timeout=30000L)
    public void testRegionServerHostnameReportedToMaster() throws Exception {
        this.TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.hostname.disable.master.reversedns", true);
        this.TEST_UTIL.startMiniCluster(1, 1);
        boolean tablesOnMaster = LoadBalancer.isTablesOnMaster((Configuration)this.TEST_UTIL.getConfiguration());
        int expectedRS = 1 + (tablesOnMaster ? 1 : 0);
        try (ZooKeeperWatcher zkw = this.TEST_UTIL.getZooKeeperWatcher();){
            List servers = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)zkw.znodePaths.rsZNode);
            Assert.assertEquals((long)expectedRS, (long)servers.size());
        }
    }
}

