/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hbase.io.ByteArrayOutputStream;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestSimpleTimeRangeTracker {
    protected TimeRangeTracker getTimeRangeTracker() {
        return TimeRangeTracker.create((TimeRangeTracker.Type)TimeRangeTracker.Type.NON_SYNC);
    }

    protected TimeRangeTracker getTimeRangeTracker(long min, long max) {
        return TimeRangeTracker.create((TimeRangeTracker.Type)TimeRangeTracker.Type.NON_SYNC, (long)min, (long)max);
    }

    @Test
    public void testExtreme() {
        TimeRange tr = new TimeRange();
        Assert.assertTrue((boolean)tr.includesTimeRange(new TimeRange()));
        TimeRangeTracker trt = this.getTimeRangeTracker();
        Assert.assertFalse((boolean)trt.includesTimeRange(new TimeRange()));
        trt.includeTimestamp(1L);
        trt.includeTimestamp(10L);
        Assert.assertTrue((boolean)trt.includesTimeRange(new TimeRange()));
    }

    @Test
    public void testTimeRangeInitialized() {
        TimeRangeTracker src = this.getTimeRangeTracker();
        TimeRange tr = new TimeRange(System.currentTimeMillis());
        Assert.assertFalse((boolean)src.includesTimeRange(tr));
    }

    @Test
    public void testTimeRangeTrackerNullIsSameAsTimeRangeNull() throws IOException {
        TimeRangeTracker src = this.getTimeRangeTracker(1L, 2L);
        byte[] bytes = TimeRangeTracker.toByteArray((TimeRangeTracker)src);
        TimeRange tgt = TimeRangeTracker.parseFrom((byte[])bytes).toTimeRange();
        Assert.assertEquals((long)src.getMin(), (long)tgt.getMin());
        Assert.assertEquals((long)src.getMax(), (long)tgt.getMax());
    }

    @Test
    public void testSerialization() throws IOException {
        TimeRangeTracker src = this.getTimeRangeTracker(1L, 2L);
        TimeRangeTracker tgt = TimeRangeTracker.parseFrom((byte[])TimeRangeTracker.toByteArray((TimeRangeTracker)src));
        Assert.assertEquals((long)src.getMin(), (long)tgt.getMin());
        Assert.assertEquals((long)src.getMax(), (long)tgt.getMax());
    }

    @Test
    public void testLegacySerialization() throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream((OutputStream)data);
        output.writeLong(100L);
        output.writeLong(200L);
        TimeRangeTracker tgt = TimeRangeTracker.parseFrom((byte[])data.toByteArray());
        Assert.assertEquals((long)100L, (long)tgt.getMin());
        Assert.assertEquals((long)200L, (long)tgt.getMax());
    }

    @Test
    public void testAlwaysDecrementingSetsMaximum() {
        TimeRangeTracker trr = this.getTimeRangeTracker();
        trr.includeTimestamp(3L);
        trr.includeTimestamp(2L);
        trr.includeTimestamp(1L);
        Assert.assertTrue((trr.getMin() != Long.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((trr.getMax() != -1L ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleInRange() {
        TimeRangeTracker trr = this.getTimeRangeTracker();
        trr.includeTimestamp(0L);
        trr.includeTimestamp(2L);
        Assert.assertTrue((boolean)trr.includesTimeRange(new TimeRange(1L)));
    }

    @Test
    public void testRangeConstruction() throws IOException {
        TimeRange defaultRange = new TimeRange();
        Assert.assertEquals((long)0L, (long)defaultRange.getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)defaultRange.getMax());
        Assert.assertTrue((boolean)defaultRange.isAllTime());
        TimeRange oneArgRange = new TimeRange(0L);
        Assert.assertEquals((long)0L, (long)oneArgRange.getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)oneArgRange.getMax());
        Assert.assertTrue((boolean)oneArgRange.isAllTime());
        TimeRange oneArgRange2 = new TimeRange(1L);
        Assert.assertEquals((long)1L, (long)oneArgRange2.getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)oneArgRange2.getMax());
        Assert.assertFalse((boolean)oneArgRange2.isAllTime());
        TimeRange twoArgRange = new TimeRange(0L, Long.MAX_VALUE);
        Assert.assertEquals((long)0L, (long)twoArgRange.getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)twoArgRange.getMax());
        Assert.assertTrue((boolean)twoArgRange.isAllTime());
        TimeRange twoArgRange2 = new TimeRange(0L, 0x7FFFFFFFFFFFFFFEL);
        Assert.assertEquals((long)0L, (long)twoArgRange2.getMin());
        Assert.assertEquals((long)0x7FFFFFFFFFFFFFFEL, (long)twoArgRange2.getMax());
        Assert.assertFalse((boolean)twoArgRange2.isAllTime());
        TimeRange twoArgRange3 = new TimeRange(1L, Long.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)twoArgRange3.getMin());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)twoArgRange3.getMax());
        Assert.assertFalse((boolean)twoArgRange3.isAllTime());
    }
}

