/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestSwitchToStreamRead {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"stream");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[] QUAL = Bytes.toBytes((String)"cq");
    private static String VALUE_PREFIX;
    private static HRegion REGION;

    @BeforeClass
    public static void setUp() throws IOException {
        int i;
        UTIL.getConfiguration().setLong("hbase.storescanner.pread.max.bytes", 2048L);
        StringBuilder sb = new StringBuilder(256);
        for (i = 0; i < 255; ++i) {
            sb.append((char)ThreadLocalRandom.current().nextInt(65, 123));
        }
        VALUE_PREFIX = sb.append("-").toString();
        REGION = UTIL.createLocalHRegion(TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).addColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setBlocksize(1024).build()).build(), null, null);
        for (i = 0; i < 900; ++i) {
            REGION.put(new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUAL, Bytes.toBytes((String)(VALUE_PREFIX + i))));
        }
        REGION.flush(true);
        for (i = 900; i < 1000; ++i) {
            REGION.put(new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUAL, Bytes.toBytes((String)(VALUE_PREFIX + i))));
        }
    }

    @AfterClass
    public static void tearDown() throws IOException {
        REGION.close(true);
        UTIL.cleanupTestDir();
    }

    @Test
    public void test() throws IOException {
        try (HRegion.RegionScannerImpl scanner = REGION.getScanner(new Scan());){
            Result result;
            StoreScanner storeScanner = (StoreScanner)scanner.getStoreHeapForTesting().getCurrentForTesting();
            for (KeyValueScanner kvs : storeScanner.getAllScannersForTesting()) {
                if (!(kvs instanceof StoreFileScanner)) continue;
                StoreFileScanner sfScanner = (StoreFileScanner)kvs;
                Assert.assertTrue((boolean)sfScanner.getReader().shared);
            }
            ArrayList cells = new ArrayList();
            for (int i = 0; i < 500; ++i) {
                Assert.assertTrue((boolean)scanner.next(cells));
                result = Result.create(cells);
                Assert.assertEquals((Object)(VALUE_PREFIX + i), (Object)Bytes.toString((byte[])result.getValue(FAMILY, QUAL)));
                cells.clear();
                scanner.shipped();
            }
            for (KeyValueScanner kvs : storeScanner.getAllScannersForTesting()) {
                if (!(kvs instanceof StoreFileScanner)) continue;
                StoreFileScanner sfScanner = (StoreFileScanner)kvs;
                Assert.assertFalse((boolean)sfScanner.getReader().shared);
            }
            for (int i = 500; i < 1000; ++i) {
                Assert.assertEquals((Object)(i != 999 ? 1 : 0), (Object)scanner.next(cells));
                result = Result.create(cells);
                Assert.assertEquals((Object)(VALUE_PREFIX + i), (Object)Bytes.toString((byte[])result.getValue(FAMILY, QUAL)));
                cells.clear();
                scanner.shipped();
            }
        }
        for (HStoreFile sf : REGION.getStore(FAMILY).getStorefiles()) {
            Assert.assertFalse((boolean)sf.isReferencedInReads());
        }
    }
}

