/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestWALMonotonicallyIncreasingSeqId {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Path testDir = TEST_UTIL.getDataTestDir("TestWALMonotonicallyIncreasingSeqId");
    private WALFactory wals;
    private FileSystem fileSystem;
    private Configuration walConf;
    public static final String KEY_SEED = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final int KEY_SEED_LEN = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".length();
    private static final char[] KEY_SEED_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    @Rule
    public TestName name = new TestName();
    CountDownLatch latch = new CountDownLatch(1);

    private HTableDescriptor getTableDesc(TableName tableName, byte[] ... families) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            hcd.setMaxVersions(Integer.MAX_VALUE);
            htd.addFamily(hcd);
        }
        return htd;
    }

    private Region initHRegion(HTableDescriptor htd, byte[] startKey, byte[] stopKey, int replicaId) throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.hregion.mvcc.preassign", false);
        Path tableDir = FSUtils.getTableDir((Path)testDir, (TableName)htd.getTableName());
        HRegionInfo info = new HRegionInfo(htd.getTableName(), startKey, stopKey, false, 0L, replicaId);
        this.fileSystem = tableDir.getFileSystem(conf);
        HRegionFileSystem fs = new HRegionFileSystem(conf, this.fileSystem, tableDir, (RegionInfo)info);
        Configuration walConf = new Configuration(conf);
        FSUtils.setRootDir((Configuration)walConf, (Path)tableDir);
        this.walConf = walConf;
        this.wals = new WALFactory(walConf, null, "log_" + replicaId);
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null);
        HRegion region = HRegion.createHRegion((RegionInfo)info, (Path)TEST_UTIL.getDefaultRootDirPath(), (Configuration)conf, (TableDescriptor)htd, (WAL)this.wals.getWAL(info.getEncodedNameAsBytes(), info.getTable().getNamespace()));
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestWALMonotonicallyIncreasingSeqId() throws Exception {
        byte[][] families = new byte[][]{Bytes.toBytes((String)"cf")};
        byte[] qf = Bytes.toBytes((String)"cq");
        HTableDescriptor htd = this.getTableDesc(TableName.valueOf((String)this.name.getMethodName()), families);
        HRegion region = (HRegion)this.initHRegion(htd, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, 0);
        ArrayList<PutThread> putThreads = new ArrayList<PutThread>();
        for (int i = 0; i < 1; ++i) {
            putThreads.add(new PutThread(region));
        }
        IncThread incThread = new IncThread(region);
        for (int i = 0; i < 1; ++i) {
            ((Thread)putThreads.get(i)).start();
        }
        incThread.start();
        incThread.join();
        Path logPath = ((FSHLog)region.getWAL()).getCurrentFileName();
        region.getWAL().rollWriter();
        Thread.sleep(10L);
        Path hbaseDir = new Path(this.walConf.get("hbase.rootdir"));
        Path oldWalsDir = new Path(hbaseDir, "oldWALs");
        WAL.Reader reader = null;
        try {
            reader = this.wals.createReader(this.fileSystem, logPath);
        }
        catch (Throwable t) {
            reader = this.wals.createReader(this.fileSystem, new Path(oldWalsDir, logPath.getName()));
        }
        try {
            WAL.Entry e;
            long currentMaxSeqid = 0L;
            while ((e = reader.next()) != null) {
                if (WALEdit.isMetaEditFamily((Cell)((Cell)e.getEdit().getCells().get(0)))) continue;
                long currentSeqid = e.getKey().getSequenceId();
                if (currentSeqid > currentMaxSeqid) {
                    currentMaxSeqid = currentSeqid;
                    continue;
                }
                Assert.fail((String)("Current max Seqid is " + currentMaxSeqid + ", but the next seqid in wal is smaller:" + currentSeqid));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (region != null) {
                region.close();
            }
        }
    }

    public class IncThread
    extends Thread {
        HRegion region;

        public IncThread(HRegion region) {
            this.region = region;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < 100; ++i) {
                    byte[] row = Bytes.toBytes((String)("incrementRow" + i));
                    Increment inc = new Increment(row);
                    inc.addColumn("cf".getBytes(), Bytes.toBytes((int)0), 1L);
                    this.region.increment(inc);
                    TestWALMonotonicallyIncreasingSeqId.this.latch.countDown();
                    Thread.sleep(10L);
                }
            }
            catch (Throwable t) {
                TestWALMonotonicallyIncreasingSeqId.this.LOG.warn((Object)"Error happend when Put: ", t);
            }
        }
    }

    public class PutThread
    extends Thread {
        HRegion region;

        public PutThread(HRegion region) {
            this.region = region;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < 100; ++i) {
                    byte[] row = Bytes.toBytes((String)("putRow" + i));
                    Put put = new Put(row);
                    put.addColumn("cf".getBytes(), Bytes.toBytes((int)0), Bytes.toBytes((String)""));
                    TestWALMonotonicallyIncreasingSeqId.this.latch.await();
                    this.region.batchMutate(new Mutation[]{put});
                    Thread.sleep(10L);
                }
            }
            catch (Throwable t) {
                TestWALMonotonicallyIncreasingSeqId.this.LOG.warn((Object)"Error happend when Increment: ", t);
            }
        }
    }
}

