/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.regionserver.compactions.OffPeakHours;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestOffPeakHours {
    private static HBaseTestingUtility testUtil;
    private int hourOfDay;
    private int hourPlusOne;
    private int hourMinusOne;
    private int hourMinusTwo;
    private Configuration conf;

    @BeforeClass
    public static void setUpClass() {
        testUtil = new HBaseTestingUtility();
    }

    @Before
    public void setUp() {
        this.hourOfDay = 15;
        this.hourPlusOne = (this.hourOfDay + 1) % 24;
        this.hourMinusOne = (this.hourOfDay - 1 + 24) % 24;
        this.hourMinusTwo = (this.hourOfDay - 2 + 24) % 24;
        this.conf = testUtil.getConfiguration();
    }

    @Test
    public void testWithoutSettings() {
        Configuration conf = testUtil.getConfiguration();
        OffPeakHours target = OffPeakHours.getInstance((Configuration)conf);
        Assert.assertFalse((boolean)target.isOffPeakHour(this.hourOfDay));
    }

    @Test
    public void testSetPeakHourToTargetTime() {
        this.conf.setLong("hbase.offpeak.start.hour", (long)this.hourMinusOne);
        this.conf.setLong("hbase.offpeak.end.hour", (long)this.hourPlusOne);
        OffPeakHours target = OffPeakHours.getInstance((Configuration)this.conf);
        Assert.assertTrue((boolean)target.isOffPeakHour(this.hourOfDay));
    }

    @Test
    public void testSetPeakHourOutsideCurrentSelection() {
        this.conf.setLong("hbase.offpeak.start.hour", (long)this.hourMinusTwo);
        this.conf.setLong("hbase.offpeak.end.hour", (long)this.hourMinusOne);
        OffPeakHours target = OffPeakHours.getInstance((Configuration)this.conf);
        Assert.assertFalse((boolean)target.isOffPeakHour(this.hourOfDay));
    }
}

