/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ExplicitColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestExplicitColumnTracker {
    private final byte[] col1 = Bytes.toBytes((String)"col1");
    private final byte[] col2 = Bytes.toBytes((String)"col2");
    private final byte[] col3 = Bytes.toBytes((String)"col3");
    private final byte[] col4 = Bytes.toBytes((String)"col4");
    private final byte[] col5 = Bytes.toBytes((String)"col5");

    private void runTest(int maxVersions, TreeSet<byte[]> trackColumns, List<byte[]> scannerColumns, List<ScanQueryMatcher.MatchCode> expected) throws IOException {
        ExplicitColumnTracker exp = new ExplicitColumnTracker(trackColumns, 0, maxVersions, Long.MIN_VALUE);
        ArrayList<ScanQueryMatcher.MatchCode> result = new ArrayList<ScanQueryMatcher.MatchCode>(scannerColumns.size());
        long timestamp = 0L;
        for (byte[] col : scannerColumns) {
            result.add(ScanQueryMatcher.checkColumn((ColumnTracker)exp, (byte[])col, (int)0, (int)col.length, (long)(++timestamp), (byte)KeyValue.Type.Put.getCode(), (boolean)false));
        }
        Assert.assertEquals((long)expected.size(), (long)result.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((Object)expected.get(i), result.get(i));
        }
    }

    @Test
    public void testGetSingleVersion() throws IOException {
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(this.col2);
        columns.add(this.col4);
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>(5);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW);
        int maxVersions = 1;
        ArrayList<byte[]> scanner = new ArrayList<byte[]>(5);
        scanner.add(this.col1);
        scanner.add(this.col2);
        scanner.add(this.col3);
        scanner.add(this.col4);
        scanner.add(this.col5);
        this.runTest(maxVersions, columns, scanner, expected);
    }

    @Test
    public void testGetMultiVersion() throws IOException {
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(this.col2);
        columns.add(this.col4);
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>(15);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW);
        int maxVersions = 2;
        ArrayList<byte[]> scanner = new ArrayList<byte[]>(15);
        scanner.add(this.col1);
        scanner.add(this.col1);
        scanner.add(this.col1);
        scanner.add(this.col2);
        scanner.add(this.col2);
        scanner.add(this.col2);
        scanner.add(this.col3);
        scanner.add(this.col3);
        scanner.add(this.col3);
        scanner.add(this.col4);
        scanner.add(this.col4);
        scanner.add(this.col4);
        scanner.add(this.col5);
        scanner.add(this.col5);
        scanner.add(this.col5);
        this.runTest(maxVersions, columns, scanner, expected);
    }

    @Test
    public void testStackOverflow() throws IOException {
        byte[] col;
        int i;
        int maxVersions = 1;
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (int i2 = 0; i2 < 100000; ++i2) {
            columns.add(Bytes.toBytes((String)("col" + i2)));
        }
        ExplicitColumnTracker explicit = new ExplicitColumnTracker(columns, 0, maxVersions, Long.MIN_VALUE);
        for (i = 0; i < 100000; i += 2) {
            col = Bytes.toBytes((String)("col" + i));
            ScanQueryMatcher.checkColumn((ColumnTracker)explicit, (byte[])col, (int)0, (int)col.length, (long)1L, (byte)KeyValue.Type.Put.getCode(), (boolean)false);
        }
        explicit.reset();
        for (i = 1; i < 100000; i += 2) {
            col = Bytes.toBytes((String)("col" + i));
            ScanQueryMatcher.checkColumn((ColumnTracker)explicit, (byte[])col, (int)0, (int)col.length, (long)1L, (byte)KeyValue.Type.Put.getCode(), (boolean)false);
        }
    }

    @Test
    public void testInfiniteLoop() throws IOException {
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.addAll(Arrays.asList(this.col2, this.col3, this.col5));
        List<byte[]> scanner = Arrays.asList(this.col1, this.col4);
        List<ScanQueryMatcher.MatchCode> expected = Arrays.asList(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL, ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        this.runTest(1, columns, scanner, expected);
    }
}

